/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.XMLElement;
import freemind.modes.ArrowLinkAdapter;
import freemind.modes.CloudAdapter;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindMap;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.XMLElementAdapter;
import freemind.modes.mindmapmode.EncryptedMindMapNode;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.modes.mindmapmode.MindMapCloudModel;
import freemind.modes.mindmapmode.MindMapEdgeModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;

public class MindMapXMLElement
extends XMLElementAdapter {
    private static Logger logger;

    public MindMapXMLElement(ModeController pModeController) {
        super(pModeController);
        this.init();
    }

    protected MindMapXMLElement(ModeController pModeController, Vector ArrowLinkAdapters, HashMap IDToTarget) {
        super(pModeController, ArrowLinkAdapters, IDToTarget);
        this.init();
    }

    private void init() {
        if (logger == null) {
            logger = this.getFrame().getLogger(this.getClass().getName());
        }
    }

    protected XMLElement createAnotherElement() {
        return new MindMapXMLElement(this.mModeController, this.mArrowLinkAdapters, this.mIDToTarget);
    }

    protected NodeAdapter createNodeAdapter(FreeMindMain frame, String nodeClass) {
        if (nodeClass == null) {
            return new MindMapNodeModel(frame, this.getMap());
        }
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> nodeJavaClass = Class.forName(nodeClass, true, loader);
            Class[] constrArgs = new Class[]{Object.class, FreeMindMain.class, MindMap.class};
            Object[] constrObjs = new Object[]{null, frame, this.getMap()};
            Constructor<?> constructor = nodeJavaClass.getConstructor(constrArgs);
            NodeAdapter nodeImplementor = (NodeAdapter)constructor.newInstance(constrObjs);
            return nodeImplementor;
        }
        catch (Exception e) {
            Resources.getInstance().logException(e, "Error occurred loading node implementor: " + nodeClass);
            MindMapNodeModel node = new MindMapNodeModel(frame, this.getMap());
            return node;
        }
    }

    protected EdgeAdapter createEdgeAdapter(NodeAdapter node, FreeMindMain frame) {
        return new MindMapEdgeModel(node, frame);
    }

    protected CloudAdapter createCloudAdapter(NodeAdapter node, FreeMindMain frame) {
        return new MindMapCloudModel(node, frame);
    }

    protected ArrowLinkAdapter createArrowLinkAdapter(NodeAdapter source, NodeAdapter target, FreeMindMain frame) {
        return new MindMapArrowLinkModel(source, target, frame);
    }

    protected NodeAdapter createEncryptedNode(String additionalInfo) {
        NodeAdapter node = this.createNodeAdapter(this.frame, EncryptedMindMapNode.class.getName());
        this.setUserObject(node);
        this.copyAttributesToNode(node);
        node.setAdditionalInfo(additionalInfo);
        return node;
    }
}

