/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.HookRegistration;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.MindMapActions;
import freemind.modes.mindmapmode.hooks.MindMapNodeHookAdapter;
import java.awt.event.MouseWheelEvent;
import java.util.ListIterator;
import java.util.logging.Logger;

public class UnfoldAll
extends MindMapNodeHookAdapter {
    public void invoke(MindMapNode node) {
        super.invoke(node);
        boolean foldState = Tools.xmlToBoolean(this.getResourceString("foldingState"));
        String foldingType = this.getResourceString("foldingType");
        String applyTo = this.getResourceString("applyTo");
        if ("root".equals(applyTo)) {
            node = this.getMindMapController().getRootNode();
        }
        if (foldingType.equals("All")) {
            if (foldState) {
                this.foldAll(node);
            } else {
                this.unfoldAll(node);
            }
        } else if (foldState) {
            this.foldOneStage(node);
        } else {
            this.unfoldOneStage(node);
        }
    }

    protected void unfoldOneStage(MindMapNode node) {
        int minDepth = this.getMinDepth(node);
        if (minDepth < Integer.MAX_VALUE) {
            ++minDepth;
        }
        this.unfoldStageN(node, minDepth);
    }

    protected void foldOneStage(MindMapNode node) {
        this.foldStageN(node, this.getMaxDepth(node) - 1);
    }

    protected void foldAll(MindMapNode node) {
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            this.foldAll((MindMapNode)i.next());
        }
        this.setFolded(node, true);
    }

    public void unfoldAll(MindMapNode node) {
        this.setFolded(node, false);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            this.unfoldAll((MindMapNode)i.next());
        }
    }

    public void foldLastBranches(MindMapNode node) {
        boolean nodeHasChildWhichIsLeave = false;
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            if (child.getChildCount() != 0) continue;
            nodeHasChildWhichIsLeave = true;
        }
        this.setFolded(node, nodeHasChildWhichIsLeave);
        i = node.childrenUnfolded();
        while (i.hasNext()) {
            this.foldLastBranches((MindMapNode)i.next());
        }
    }

    protected void setFolded(MindMapNode node, boolean state) {
        if (node.hasChildren() && node.isFolded() != state) {
            this.getMindMapController().setFolded(node, state);
        }
    }

    public void unfoldStageN(MindMapNode node, int stage) {
        int k = this.depth(node);
        if (k < stage) {
            this.setFolded(node, false);
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                this.unfoldStageN((MindMapNode)i.next(), stage);
            }
        } else {
            this.foldAll(node);
        }
    }

    public void foldStageN(MindMapNode node, int stage) {
        int k = this.depth(node);
        if (k < stage) {
            this.setFolded(node, false);
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                this.foldStageN((MindMapNode)i.next(), stage);
            }
        } else {
            this.foldAll(node);
        }
    }

    public int getMinDepth(MindMapNode node) {
        if (node.isFolded()) {
            return this.depth(node);
        }
        if (!node.hasChildren()) {
            return Integer.MAX_VALUE;
        }
        int k = Integer.MAX_VALUE;
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            int l = this.getMinDepth((MindMapNode)i.next());
            if (l >= k) continue;
            k = l;
        }
        return k;
    }

    protected int getMaxDepth(MindMapNode node) {
        if (node.isFolded() || !node.hasChildren()) {
            return this.depth(node);
        }
        int k = 0;
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            int l = this.getMaxDepth((MindMapNode)i.next());
            if (l <= k) continue;
            k = l;
        }
        return k;
    }

    protected int depth(MindMapNode node) {
        if (node.isRoot()) {
            return 0;
        }
        return this.depth((MindMapNode)node.getParent()) + 1;
    }

    public static class Registration
    implements HookRegistration,
    MindMapActions.MouseWheelEventHandler {
        private final MindMapController controller;
        private final MindMap mMap;
        private final Logger logger;
        private UnfoldAll hookInstance;

        public Registration(ModeController controller, MindMap map) {
            this.controller = (MindMapController)controller;
            this.mMap = map;
            this.logger = controller.getFrame().getLogger(this.getClass().getName());
            this.hookInstance = new UnfoldAll();
            this.hookInstance.setController(controller);
            this.hookInstance.setMap(this.mMap);
        }

        public void register() {
            this.controller.registerMouseWheelEventHandler(this);
        }

        public void deRegister() {
            this.controller.deRegisterMouseWheelEventHandler(this);
        }

        public boolean handleMouseWheelEvent(MouseWheelEvent e) {
            if ((e.getModifiers() & 8) != 0) {
                this.logger.info("handleMouseWheelEvent entered.");
                MindMapNode rootNode = this.mMap.getRootNode();
                if (e.getWheelRotation() > 0) {
                    this.hookInstance.unfoldOneStage(rootNode);
                } else {
                    this.controller.select(this.controller.getView().getRoot());
                    this.hookInstance.foldOneStage(rootNode);
                }
                return true;
            }
            return false;
        }
    }
}

