/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import accessories.plugins.dialogs.ChooseFormatPopupDialog;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import freemind.common.PropertyBean;
import freemind.common.PropertyControl;
import freemind.common.SeparatorProperty;
import freemind.common.TextTranslator;
import freemind.common.XmlBindingTools;
import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.Patterns;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.extensions.HookRegistration;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.StylePatternFactory;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.PermanentMindMapNodeHookAdapter;
import freemind.preferences.FreemindPropertyContributor;
import freemind.preferences.FreemindPropertyListener;
import freemind.preferences.layout.OptionPanel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AutomaticLayout
extends PermanentMindMapNodeHookAdapter {
    private static final String AUTOMATIC_FORMAT_LEVEL = "automaticFormat_level";
    private static Patterns patterns = null;

    private void setStyle(MindMapNode node) {
        this.logger.finest("updating node id=" + node.getObjectId(this.getMindMapController()) + " and text:" + node);
        int depth = this.depth(node);
        this.logger.finest("COLOR, depth=" + depth);
        this.reloadPatterns();
        int myIndex = patterns.sizeChoiceList() - 1;
        if (depth < patterns.sizeChoiceList()) {
            myIndex = depth;
        }
        Pattern p = (Pattern)patterns.getChoice(myIndex);
        this.getMindMapController().applyPattern(node, p);
    }

    private int depth(MindMapNode node) {
        if (node.isRoot()) {
            return 0;
        }
        return this.depth(node.getParentNode()) + 1;
    }

    public void onAddChildren(MindMapNode newChildNode) {
        this.logger.finest("onAddChildren " + newChildNode);
        super.onAddChild(newChildNode);
        this.setStyleRecursive(newChildNode);
    }

    public void onUpdateChildrenHook(MindMapNode updatedNode) {
        super.onUpdateChildrenHook(updatedNode);
        this.setStyleRecursive(updatedNode);
    }

    public void onUpdateNodeHook() {
        super.onUpdateNodeHook();
        this.setStyle(this.getNode());
    }

    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.setStyleRecursive(node);
    }

    private void reloadPatterns() {
        if (patterns == null) {
            String property = this.getMindMapController().getFrame().getProperty(AUTOMATIC_FORMAT_LEVEL);
            patterns = StylePatternFactory.getPatternsFromString(property);
        }
    }

    private void setStyleRecursive(MindMapNode node) {
        this.logger.finest("setStyle " + node);
        this.setStyle(node);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.invoke(child);
        }
    }

    private static final class AutomaticLayoutPropertyContributor
    implements FreemindPropertyContributor {
        private final MindMapController modeController;

        public AutomaticLayoutPropertyContributor(MindMapController modeController) {
            this.modeController = modeController;
        }

        public List getControls(TextTranslator pTextTranslator) {
            Vector<PropertyControl> controls = new Vector<PropertyControl>();
            controls.add(new OptionPanel.NewTabProperty("accessories/plugins/AutomaticLayout.properties_PatternTabName"));
            controls.add(new SeparatorProperty("accessories/plugins/AutomaticLayout.properties_PatternSeparatorName"));
            controls.add(new StylePatternListProperty("level", AutomaticLayout.AUTOMATIC_FORMAT_LEVEL, pTextTranslator, this.modeController));
            return controls;
        }
    }

    public static class StylePatternListProperty
    extends PropertyBean
    implements PropertyControl,
    ListSelectionListener {
        String description;
        String label;
        String patterns;
        JList mList;
        boolean mDialogIsShown = false;
        private final TextTranslator mTranslator;
        private final MindMapController mindMapController;
        private DefaultListModel mDefaultListModel;

        public StylePatternListProperty(String description, String label, TextTranslator pTranslator, MindMapController pController) {
            this.description = description;
            this.label = label;
            this.mTranslator = pTranslator;
            this.mindMapController = pController;
            this.mList = new JList();
            this.mList.setSelectionMode(0);
            this.mDefaultListModel = new DefaultListModel();
            this.mList.setModel(this.mDefaultListModel);
            this.mList.addListSelectionListener(this);
            this.patterns = null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.patterns = value;
            Patterns resultPatterns = this.getPatternsFromString();
            this.mDefaultListModel.clear();
            int j = 1;
            StylePropertyTranslator stylePropertyTranslator = new StylePropertyTranslator(this.mindMapController);
            Iterator i = resultPatterns.getListChoiceList().iterator();
            while (i.hasNext()) {
                Pattern pattern = (Pattern)i.next();
                this.mDefaultListModel.addElement(this.mTranslator.getText("level" + j) + ": " + StylePatternFactory.toString(pattern, stylePropertyTranslator));
                ++j;
            }
        }

        public String getValue() {
            return this.patterns;
        }

        public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
            JLabel label = builder.append(pTranslator.getText(this.getLabel()));
            builder.append(new JLabel());
            label.setToolTipText(pTranslator.getText(this.getDescription()));
            builder.appendSeparator();
            builder.append((Component)new JScrollPane(this.mList), 3);
        }

        private Patterns getPatternsFromString() {
            return StylePatternFactory.getPatternsFromString(this.patterns);
        }

        public void setEnabled(boolean pEnabled) {
            this.mList.setEnabled(pEnabled);
        }

        public void valueChanged(ListSelectionEvent e) {
            final Patterns pat = this.getPatternsFromString();
            JList source = (JList)e.getSource();
            if (source.getSelectedIndex() < 0) {
                return;
            }
            final Pattern choice = (Pattern)pat.getChoice(source.getSelectedIndex());
            final ChooseFormatPopupDialog formatDialog = new ChooseFormatPopupDialog(this.mindMapController.getFrame().getJFrame(), this.mindMapController, "accessories/plugins/AutomaticLayout.properties_StyleDialogTitle", choice);
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (StylePatternListProperty.this.mDialogIsShown) {
                        return;
                    }
                    StylePatternListProperty.this.mDialogIsShown = true;
                    try {
                        formatDialog.setModal(true);
                        formatDialog.setVisible(true);
                        if (formatDialog.getResult() == 1) {
                            formatDialog.getPattern(choice);
                            StylePatternListProperty.this.patterns = XmlBindingTools.getInstance().marshall((XmlAction)pat);
                            StylePatternListProperty.this.setValue(StylePatternListProperty.this.patterns);
                            StylePatternListProperty.this.firePropertyChangeEvent();
                        }
                    }
                    finally {
                        StylePatternListProperty.this.mDialogIsShown = false;
                    }
                }
            });
        }
    }

    public static class StylePatternProperty
    extends PropertyBean
    implements PropertyControl,
    ActionListener {
        String description;
        String label;
        String pattern;
        JButton mButton;
        private final TextTranslator mTranslator;
        private final MindMapController mindMapController;

        public StylePatternProperty(String description, String label, TextTranslator pTranslator, MindMapController pController) {
            this.description = description;
            this.label = label;
            this.mTranslator = pTranslator;
            this.mindMapController = pController;
            this.mButton = new JButton();
            this.mButton.addActionListener(this);
            this.pattern = null;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLabel() {
            return this.label;
        }

        public void setValue(String value) {
            this.pattern = value;
            Pattern resultPattern = this.getPatternFromString();
            String patternString = StylePatternFactory.toString(resultPattern, new StylePropertyTranslator(this.mindMapController));
            this.mButton.setText(patternString);
            this.mButton.setToolTipText(patternString);
        }

        public String getValue() {
            return this.pattern;
        }

        public void layout(DefaultFormBuilder builder, TextTranslator pTranslator) {
            JLabel label = builder.append(pTranslator.getText(this.getLabel()), (Component)this.mButton);
            label.setToolTipText(pTranslator.getText(this.getDescription()));
        }

        public void actionPerformed(ActionEvent arg0) {
            Pattern pat = this.getPatternFromString();
            ChooseFormatPopupDialog formatDialog = new ChooseFormatPopupDialog(this.mindMapController.getFrame().getJFrame(), this.mindMapController, "accessories/plugins/AutomaticLayout.properties_StyleDialogTitle", pat);
            formatDialog.setModal(true);
            formatDialog.setVisible(true);
            if (formatDialog.getResult() == 1) {
                Pattern resultPattern = formatDialog.getPattern();
                resultPattern.setName("dummy");
                this.pattern = XmlBindingTools.getInstance().marshall((XmlAction)resultPattern);
                this.setValue(this.pattern);
                this.firePropertyChangeEvent();
            }
        }

        private Pattern getPatternFromString() {
            return StylePatternFactory.getPatternFromString(this.pattern);
        }

        public void setEnabled(boolean pEnabled) {
            this.mButton.setEnabled(pEnabled);
        }
    }

    static class StylePropertyTranslator
    implements TextTranslator {
        private final MindMapController controller;

        StylePropertyTranslator(MindMapController controller) {
            this.controller = controller;
        }

        public String getText(String pKey) {
            return this.controller.getText(pKey);
        }
    }

    public static class Registration
    implements HookRegistration {
        private AutomaticLayoutPropertyContributor mAutomaticLayoutPropertyContributor;
        private final MindMapController modeController;
        private static FreemindPropertyListener listener = null;

        public Registration(ModeController controller, MindMap map) {
            this.modeController = (MindMapController)controller;
        }

        public void register() {
            if (listener == null) {
                listener = new MyFreemindPropertyListener();
            }
            Controller.addPropertyChangeListener(listener);
            this.mAutomaticLayoutPropertyContributor = new AutomaticLayoutPropertyContributor(this.modeController);
            OptionPanel.addContributor(this.mAutomaticLayoutPropertyContributor);
        }

        public void deRegister() {
            OptionPanel.removeContributor(this.mAutomaticLayoutPropertyContributor);
            Controller.removePropertyChangeListener(listener);
        }

        static class MyFreemindPropertyListener
        implements FreemindPropertyListener {
            MyFreemindPropertyListener() {
            }

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.startsWith(AutomaticLayout.AUTOMATIC_FORMAT_LEVEL)) {
                    patterns = null;
                }
            }
        }
    }
}

