/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.common.TextTranslator;
import freemind.common.XmlBindingTools;
import freemind.controller.actions.generated.instance.Pattern;
import freemind.controller.actions.generated.instance.PatternEdgeColor;
import freemind.controller.actions.generated.instance.PatternEdgeStyle;
import freemind.controller.actions.generated.instance.PatternEdgeWidth;
import freemind.controller.actions.generated.instance.PatternIcon;
import freemind.controller.actions.generated.instance.PatternNodeBackgroundColor;
import freemind.controller.actions.generated.instance.PatternNodeColor;
import freemind.controller.actions.generated.instance.PatternNodeFontBold;
import freemind.controller.actions.generated.instance.PatternNodeFontItalic;
import freemind.controller.actions.generated.instance.PatternNodeFontName;
import freemind.controller.actions.generated.instance.PatternNodeFontSize;
import freemind.controller.actions.generated.instance.PatternNodeStyle;
import freemind.controller.actions.generated.instance.PatternPropertyBase;
import freemind.controller.actions.generated.instance.Patterns;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

public class StylePatternFactory {
    public static final String FALSE_VALUE = "false";
    public static final String TRUE_VALUE = "true";
    private static final String PATTERN_DUMMY = "<pattern name='dummy'/>";
    private static final String PATTERNS_DUMMY = "<patterns/>";

    public static List loadPatterns(File file) throws Exception {
        return StylePatternFactory.loadPatterns(new BufferedReader(new FileReader(file)));
    }

    public static List loadPatterns(Reader reader) throws Exception {
        Patterns patterns = (Patterns)XmlBindingTools.getInstance().unMarshall(reader);
        return patterns.getListChoiceList();
    }

    public static void savePatterns(Writer writer, List listOfPatterns) throws Exception {
        Patterns patterns = new Patterns();
        Iterator iter = listOfPatterns.iterator();
        while (iter.hasNext()) {
            Pattern pattern = (Pattern)iter.next();
            patterns.addChoice((Object)pattern);
        }
        String marshalledResult = XmlBindingTools.getInstance().marshall((XmlAction)patterns);
        writer.write(marshalledResult);
        writer.close();
    }

    public static Pattern createPatternFromNode(MindMapNode node) {
        PatternNodeFontName subPattern;
        PatternNodeColor subPattern2;
        Pattern pattern = new Pattern();
        if (node.getColor() != null) {
            subPattern2 = new PatternNodeColor();
            subPattern2.setValue(Tools.colorToXml(node.getColor()));
            pattern.setPatternNodeColor(subPattern2);
        }
        if (node.getBackgroundColor() != null) {
            subPattern2 = new PatternNodeBackgroundColor();
            subPattern2.setValue(Tools.colorToXml(node.getBackgroundColor()));
            pattern.setPatternNodeBackgroundColor((PatternNodeBackgroundColor)subPattern2);
        }
        if (node.getStyle() != null) {
            subPattern2 = new PatternNodeStyle();
            subPattern2.setValue(node.getStyle());
            pattern.setPatternNodeStyle((PatternNodeStyle)subPattern2);
        }
        PatternNodeFontBold nodeFontBold = new PatternNodeFontBold();
        nodeFontBold.setValue(node.isBold() ? TRUE_VALUE : FALSE_VALUE);
        pattern.setPatternNodeFontBold(nodeFontBold);
        PatternNodeFontItalic nodeFontItalic = new PatternNodeFontItalic();
        nodeFontItalic.setValue(node.isItalic() ? TRUE_VALUE : FALSE_VALUE);
        pattern.setPatternNodeFontItalic(nodeFontItalic);
        if (node.getFontSize() != null) {
            PatternNodeFontSize nodeFontSize = new PatternNodeFontSize();
            nodeFontSize.setValue(node.getFontSize());
            pattern.setPatternNodeFontSize(nodeFontSize);
        }
        if (node.getFontFamilyName() != null) {
            subPattern = new PatternNodeFontName();
            subPattern.setValue(node.getFontFamilyName());
            pattern.setPatternNodeFontName(subPattern);
        }
        if (node.getIcons().size() == 1) {
            PatternIcon iconPattern = new PatternIcon();
            iconPattern.setValue(((MindIcon)node.getIcons().get(0)).getName());
            pattern.setPatternIcon(iconPattern);
        }
        if (node.getEdge().getColor() != null) {
            subPattern = new PatternEdgeColor();
            subPattern.setValue(Tools.colorToXml(node.getEdge().getColor()));
            pattern.setPatternEdgeColor((PatternEdgeColor)subPattern);
        }
        if (node.getEdge().getStyle() != null) {
            subPattern = new PatternEdgeStyle();
            subPattern.setValue(node.getEdge().getStyle());
            pattern.setPatternEdgeStyle((PatternEdgeStyle)subPattern);
        }
        if (node.getEdge().getWidth() != -1) {
            subPattern = new PatternEdgeWidth();
            subPattern.setValue("" + node.getEdge().getWidth());
            pattern.setPatternEdgeWidth((PatternEdgeWidth)subPattern);
        }
        return pattern;
    }

    public static String toString(Pattern pPattern, TextTranslator translator) {
        String result = "";
        if (pPattern.getPatternNodeColor() != null) {
            result = StylePatternFactory.addSeparatorIfNecessary(result);
            result = pPattern.getPatternNodeColor().getValue() == null ? result + "-" + translator.getText("PatternToString.color") : result + "+" + translator.getText("PatternToString.color");
        }
        if (pPattern.getPatternNodeBackgroundColor() != null) {
            result = StylePatternFactory.addSeparatorIfNecessary(result);
            result = pPattern.getPatternNodeBackgroundColor().getValue() == null ? result + "-" + translator.getText("PatternToString.backgroundColor") : result + "+" + translator.getText("PatternToString.backgroundColor");
        }
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternNodeFontSize(), "PatternToString.NodeFontSize");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternNodeFontName(), "PatternToString.FontName");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternNodeFontBold(), "PatternToString.FontBold");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternNodeFontItalic(), "PatternToString.FontItalic");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternEdgeStyle(), "PatternToString.EdgeStyle");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternEdgeColor(), "PatternToString.EdgeColor");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternEdgeWidth(), "PatternToString.EdgeWidth");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternIcon(), "PatternToString.Icon");
        result = StylePatternFactory.addSubPatternToString(translator, result, (PatternPropertyBase)pPattern.getPatternChild(), "PatternToString.Child");
        return result;
    }

    private static String addSubPatternToString(TextTranslator translator, String result, PatternPropertyBase patternType, String patternString) {
        if (patternType != null) {
            result = StylePatternFactory.addSeparatorIfNecessary(result);
            result = patternType.getValue() == null ? result + "-" + translator.getText(patternString) : result + "+" + translator.getText(patternString) + " " + patternType.getValue();
        }
        return result;
    }

    private static String addSeparatorIfNecessary(String result) {
        if (result.length() > 0) {
            result = result + ", ";
        }
        return result;
    }

    public static Pattern getPatternFromString(String pattern) {
        String patternString = pattern;
        if (patternString == null) {
            patternString = PATTERN_DUMMY;
        }
        Pattern pat = (Pattern)XmlBindingTools.getInstance().unMarshall(patternString);
        return pat;
    }

    public static Patterns getPatternsFromString(String patterns) {
        String patternsString = patterns;
        if (patternsString == null) {
            patternsString = PATTERNS_DUMMY;
        }
        Patterns pat = (Patterns)XmlBindingTools.getInstance().unMarshall(patternsString);
        return pat;
    }

    public static Pattern intersectPattern(Pattern p1, Pattern p2) {
        Pattern result = new Pattern();
        result.setPatternEdgeColor((PatternEdgeColor)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternEdgeColor(), (PatternPropertyBase)p2.getPatternEdgeColor(), (PatternPropertyBase)new PatternEdgeColor()));
        result.setPatternEdgeStyle((PatternEdgeStyle)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternEdgeStyle(), (PatternPropertyBase)p2.getPatternEdgeStyle(), (PatternPropertyBase)new PatternEdgeStyle()));
        result.setPatternEdgeWidth((PatternEdgeWidth)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternEdgeWidth(), (PatternPropertyBase)p2.getPatternEdgeWidth(), (PatternPropertyBase)new PatternEdgeWidth()));
        result.setPatternIcon((PatternIcon)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternIcon(), (PatternPropertyBase)p2.getPatternIcon(), (PatternPropertyBase)new PatternIcon()));
        result.setPatternNodeBackgroundColor((PatternNodeBackgroundColor)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeBackgroundColor(), (PatternPropertyBase)p2.getPatternNodeBackgroundColor(), (PatternPropertyBase)new PatternNodeBackgroundColor()));
        result.setPatternNodeColor((PatternNodeColor)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeColor(), (PatternPropertyBase)p2.getPatternNodeColor(), (PatternPropertyBase)new PatternNodeColor()));
        result.setPatternNodeFontBold((PatternNodeFontBold)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeFontBold(), (PatternPropertyBase)p2.getPatternNodeFontBold(), (PatternPropertyBase)new PatternNodeFontBold()));
        result.setPatternNodeFontItalic((PatternNodeFontItalic)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeFontItalic(), (PatternPropertyBase)p2.getPatternNodeFontItalic(), (PatternPropertyBase)new PatternNodeFontItalic()));
        result.setPatternNodeFontName((PatternNodeFontName)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeFontName(), (PatternPropertyBase)p2.getPatternNodeFontName(), (PatternPropertyBase)new PatternNodeFontName()));
        result.setPatternNodeFontSize((PatternNodeFontSize)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeFontSize(), (PatternPropertyBase)p2.getPatternNodeFontSize(), (PatternPropertyBase)new PatternNodeFontSize()));
        result.setPatternNodeStyle((PatternNodeStyle)StylePatternFactory.processPatternProperties((PatternPropertyBase)p1.getPatternNodeStyle(), (PatternPropertyBase)p2.getPatternNodeStyle(), (PatternPropertyBase)new PatternNodeStyle()));
        return result;
    }

    private static PatternPropertyBase processPatternProperties(PatternPropertyBase prop1, PatternPropertyBase prop2, PatternPropertyBase destination) {
        if (prop1 == null || prop2 == null) {
            return null;
        }
        if (Tools.safeEquals(prop1.getValue(), prop2.getValue())) {
            destination.setValue(prop1.getValue());
            return destination;
        }
        return null;
    }

    public static Pattern createPatternFromSelected(MindMapNode focussed, List selected) {
        Pattern nodePattern = StylePatternFactory.createPatternFromNode(focussed);
        Iterator iter = selected.iterator();
        while (iter.hasNext()) {
            MindMapNode node = (MindMapNode)iter.next();
            Pattern tempNodePattern = StylePatternFactory.createPatternFromNode(node);
            nodePattern = StylePatternFactory.intersectPattern(nodePattern, tempNodePattern);
        }
        return nodePattern;
    }
}

