/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindMapLine;
import freemind.modes.MindMapNode;
import java.awt.Color;

public abstract class LineAdapter
implements MindMapLine {
    protected FreeMindMain frame;
    protected MindMapNode target;
    public static final int DEFAULT_WIDTH = -1;
    protected int NORMAL_WIDTH = 1;
    protected Color color;
    protected String style;
    protected int width;

    public LineAdapter(MindMapNode target, FreeMindMain frame) {
        this.frame = frame;
        this.target = target;
        this.width = -1;
        this.updateStandards();
    }

    protected void updateStandards() {
        String stdStyle;
        if (this.getStandardColor() == null) {
            String stdColor = this.getFrame().getProperty(this.getStandardColorPropertyString());
            if (stdColor != null && stdColor.length() == 7) {
                this.setStandardColor(Tools.xmlToColor(stdColor));
            } else {
                this.setStandardColor(Color.RED);
            }
        }
        if (this.getStandardStyle() == null && (stdStyle = this.getFrame().getProperty(this.getStandardStylePropertyString())) != null) {
            this.setStandardStyle(stdStyle);
        }
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public Color getColor() {
        if (this.color == null) {
            return this.getStandardColor();
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getWidth() {
        if (this.width == -1) {
            return this.NORMAL_WIDTH;
        }
        return this.width;
    }

    public int getRealWidth() {
        return this.getWidth();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getStyle() {
        if (this.style == null) {
            return this.getStandardStyle();
        }
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String toString() {
        return "";
    }

    public void setTarget(MindMapNode target) {
        this.target = target;
    }

    public MindMapNode getTarget() {
        return this.target;
    }

    public Object clone() {
        try {
            LineAdapter link = (LineAdapter)super.clone();
            link.color = this.color == null ? null : new Color(this.color.getRGB());
            return link;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected abstract void setStandardColor(Color var1);

    protected abstract Color getStandardColor();

    protected abstract void setStandardStyle(String var1);

    protected abstract String getStandardStyle();

    protected abstract String getStandardStylePropertyString();

    protected abstract String getStandardColorPropertyString();
}

