/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLPlugin;
import com.lightdev.app.shtm.Util;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class PluginManager {
    private String PLUGIN_PACKAGE = "installed";
    private URLClassLoader loader;
    private Vector pluginClassNames = new Vector();
    private Hashtable loadedPlugins = new Hashtable();
    private Hashtable nameMap = new Hashtable();
    private Vector urls = new Vector();
    private SHTMLPanelImpl owner;

    public PluginManager(SHTMLPanelImpl owner) {
        this.owner = owner;
    }

    public Enumeration plugins() {
        return this.loadedPlugins.elements();
    }

    public ClassLoader getPluginLoader() {
        return this.loader;
    }

    public SHTMLPlugin pluginForName(String guiName) {
        String intName = (String)this.nameMap.get(guiName);
        return (SHTMLPlugin)this.loadedPlugins.get(intName);
    }

    public Object[] getPluginNames() {
        return this.nameMap.keySet().toArray();
    }

    public void loadPlugins() {
        this.loadedPlugins.clear();
        String pluginPrefix = this.getClass().getPackage().getName() + "." + this.PLUGIN_PACKAGE + ".";
        this.findPlugins(pluginPrefix.replace('.', '/'));
        Enumeration cNames = this.pluginClassNames.elements();
        while (cNames.hasMoreElements()) {
            try {
                String nextClass = (String)cNames.nextElement();
                Class<?> cl = this.loader.loadClass(pluginPrefix + nextClass);
                Object o = cl.newInstance();
                if (!(o instanceof SHTMLPlugin)) continue;
                SHTMLPlugin p = (SHTMLPlugin)o;
                p.initPlugin(this.owner, null, null, null);
                String intName = p.getInternalName();
                this.loadedPlugins.put(intName, o);
                this.nameMap.put(p.getGUIName(), intName);
            }
            catch (Exception e) {
                Util.errMsg(null, this.getClass().getName() + ".loadPlugins: " + e.getMessage(), e);
            }
        }
    }

    private URLClassLoader createLoader(Vector urls) {
        URL[] urlArray = new URL[urls.size()];
        for (int i = 0; i < urls.size(); ++i) {
            urlArray[i] = (URL)urls.elementAt(i);
        }
        return new URLClassLoader(urlArray, this.getClass().getClassLoader());
    }

    private void findPlugins(String pluginPath) {
        String appPath = Util.getClassFilePath(this.getClass());
        String filePath = appPath.indexOf(":") < 0 ? "/" + appPath : appPath;
        this.pluginClassNames.clear();
        this.urls.clear();
        try {
            File[] content;
            File plugindir = new File(filePath);
            if (plugindir != null && (content = plugindir.listFiles()) != null) {
                for (int i = 0; i < content.length; ++i) {
                    if (!content[i].isFile()) continue;
                    String fName = content[i].getName();
                    if (fName.toLowerCase().endsWith("jhall.jar")) {
                        this.urls.addElement(new URL("file:/" + appPath + fName));
                    }
                    if (fName.toLowerCase().endsWith("simplyhtml.jar")) {
                        this.urls.addElement(new URL("file:/" + appPath + fName));
                        continue;
                    }
                    if (!fName.endsWith(".jar")) continue;
                    this.readJar(appPath, pluginPath, content[i], fName);
                }
            }
            this.loader = this.createLoader(this.urls);
        }
        catch (Exception e) {
            Util.errMsg(null, this.getClass().getName() + ".findPlugins: " + e.getMessage(), e);
        }
    }

    private void readJar(String filePath, String pluginPath, File jarFile, String fileName) {
        try {
            Enumeration<JarEntry> jarEntries = new JarFile(jarFile).entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry je = jarEntries.nextElement();
                String jeName = je.getName();
                if (!jeName.startsWith(pluginPath) || je.isDirectory() || !jeName.endsWith(".class")) continue;
                this.urls.addElement(new URL("file:/" + filePath + fileName));
                this.pluginClassNames.addElement(jeName.substring(pluginPath.length(), jeName.indexOf(".")));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

