/*
 * Decompiled with CFR 0.152.
 */
package org.rubycoder.gsm;

import java.io.IOException;
import java.io.InputStream;
import org.rubycoder.gsm.GSMDecoder;
import org.rubycoder.gsm.InvalidGSMFrameException;

class GSMDecoderStream
extends InputStream {
    private static int[] lookup_table;
    private InputStream GSMStream;
    private int gsm_index = 0;
    private final byte[] gsm_frame;
    private final int[] buffer;
    private int buffer_index = 0;
    private int buffer_size = 0;
    private final GSMDecoder theDecoder;

    private static byte lin2mu(int lin) {
        int s;
        if ((lin >>= 2) < 0) {
            lin = -lin;
            s = 1;
        } else {
            s = 0;
        }
        for (int n = 0; n < 8; ++n) {
            int topp = (32 << n + 1) - 32;
            if (lin >= topp) continue;
            int e = n;
            int f = lin - (32 << e) + 32 >>> e + 1;
            return (byte)((s << 7 | e << 4 | f & 0xF) ^ 0xFF);
        }
        return (byte)(s << 8);
    }

    private static int[] create_lookup_table() {
        int[] res = new int[8192];
        for (int i = 0; i < 8192; ++i) {
            int pcm = i - 4096;
            res[i] = GSMDecoderStream.lin2mu(pcm <<= 3) & 0xFF;
        }
        return res;
    }

    public GSMDecoderStream(InputStream is) {
        if (lookup_table == null) {
            lookup_table = GSMDecoderStream.create_lookup_table();
        }
        this.gsm_index = 0;
        this.GSMStream = is;
        this.buffer = new int[160];
        this.buffer_index = 0;
        this.buffer_size = 0;
        this.gsm_frame = new byte[33];
        this.theDecoder = new GSMDecoder();
    }

    public int available() throws IOException {
        try {
            int avail = this.GSMStream.available() / 33;
        }
        catch (IOException ioe) {
            throw new IOException("Recieved IO Exception from source stream.");
        }
        catch (NullPointerException npe) {
            throw new IOException("Source stream not open.");
        }
        avail *= 160;
        return avail += this.buffer_size - this.buffer_index;
    }

    public void close() {
        this.GSMStream = null;
    }

    public synchronized void mark(int size) {
    }

    public boolean markSupported() {
        return false;
    }

    public final int read() {
        int read_count = 0;
        if (this.buffer_index >= this.buffer_size) {
            try {
                read_count = this.GSMStream.read(this.gsm_frame);
            }
            catch (IOException ioe) {
                System.out.println("got io exception");
                this.close();
                return -1;
            }
            catch (NullPointerException npe) {
                return -1;
            }
            if (read_count < 33) {
                this.close();
                return -1;
            }
            try {
                this.theDecoder.decode(this.gsm_frame, this.buffer);
            }
            catch (InvalidGSMFrameException igfe) {
                System.out.println("invalid frame");
                this.close();
                return -1;
            }
            this.buffer_index = 0;
            this.buffer_size = 160;
        }
        int res = lookup_table[(this.buffer[this.buffer_index++] >> 3) + 4096];
        return res;
    }

    public final int read(byte[] output, int start, int length) {
        int i;
        if (this.GSMStream == null) {
            return -1;
        }
        for (i = start; i < length; ++i) {
            int val;
            block10: {
                int read_count = 0;
                if (this.buffer_index >= this.buffer_size) {
                    this.gsm_index = 0;
                    while (this.gsm_index < 33) {
                        try {
                            read_count = this.GSMStream.read(this.gsm_frame, this.gsm_index, 33 - this.gsm_index);
                        }
                        catch (IOException ioe) {
                            System.out.println("got io exception");
                            this.close();
                            val = -1;
                            break block10;
                        }
                        catch (NullPointerException npe) {
                            val = -1;
                            break block10;
                        }
                        if (read_count < 0) {
                            System.out.println("got eof");
                            this.close();
                            val = -1;
                            break block10;
                        }
                        this.gsm_index += read_count;
                    }
                    try {
                        this.theDecoder.decode(this.gsm_frame, this.buffer);
                    }
                    catch (InvalidGSMFrameException igfe) {
                        System.out.println("invalid frame");
                        this.close();
                        val = -1;
                        break block10;
                    }
                    this.buffer_index = 0;
                    this.buffer_size = 160;
                }
                val = lookup_table[(this.buffer[this.buffer_index++] >> 3) + 4096];
            }
            if (val < 0) break;
            output[i] = (byte)val;
        }
        return i;
    }

    public final int read(byte[] output) {
        return this.read(output, 0, output.length);
    }

    public void reset() {
    }

    public void skip(int n) {
    }
}

