/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.xmpp.client.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.GuardedBy;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.ChatStateListener;
import org.jivesoftware.smackx.ChatStateManager;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.friend.api.ChatState;
import org.limewire.friend.api.FriendException;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.IncomingChatListener;
import org.limewire.friend.api.MessageReader;
import org.limewire.friend.api.MessageWriter;
import org.limewire.friend.api.Network;
import org.limewire.friend.api.PresenceEvent;
import org.limewire.friend.api.feature.Feature;
import org.limewire.friend.api.feature.FeatureRegistry;
import org.limewire.friend.impl.AbstractFriend;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.DebugRunnable;
import org.limewire.util.StringUtils;

public class XMPPFriendImpl
extends AbstractFriend {
    private static final Log LOG = LogFactory.getLog(XMPPFriendImpl.class);
    private final String id;
    private final FeatureRegistry featureRegistry;
    private final String idNoService;
    private AtomicReference<RosterEntry> rosterEntry;
    private final XMPPConnection connection;
    private final Network network;
    private final Object presenceLock;
    @GuardedBy(value="presenceLock")
    private final Map<String, FriendPresence> presences;
    @GuardedBy(value="presenceLock")
    private String activePresenceJid;
    private final Object chatListenerLock;
    @GuardedBy(value="chatListenerLock")
    private volatile IncomingChatListenerAdapter listenerAdapter;

    XMPPFriendImpl(String id, RosterEntry rosterEntry, Network network, XMPPConnection connection, FeatureRegistry featureRegistry) {
        this.id = id;
        this.featureRegistry = featureRegistry;
        this.idNoService = XMPPFriendImpl.stripService(id, network.getNetworkName());
        this.network = network;
        this.rosterEntry = new AtomicReference<RosterEntry>(rosterEntry);
        this.presences = new HashMap<String, FriendPresence>();
        this.activePresenceJid = null;
        this.connection = connection;
        this.presenceLock = new Object();
        this.chatListenerLock = new Object();
    }

    private static String stripService(String id, String service) {
        int idx = id.lastIndexOf("@" + service);
        if (idx == -1) {
            return id;
        }
        return id.substring(0, idx);
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        String name = this.rosterEntry.get().getName();
        if (name != null) {
            String service = this.network.getNetworkName();
            int idx = name.lastIndexOf("@" + service);
            if (idx == -1) {
                return name;
            }
            return name.substring(0, idx);
        }
        return null;
    }

    @Override
    public String getRenderName() {
        String visualName = this.getName();
        if (visualName == null) {
            return this.idNoService;
        }
        return visualName;
    }

    @Override
    public String getFirstName() {
        String visualName = this.getName();
        if (visualName == null) {
            return this.idNoService;
        }
        String[] subStrings = visualName.split(" ");
        return subStrings[0];
    }

    void setRosterEntry(RosterEntry rosterEntry) {
        this.rosterEntry.set(rosterEntry);
    }

    @Override
    public void setName(final String name) {
        Thread t = ThreadExecutor.newManagedThread(new DebugRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    ((RosterEntry)XMPPFriendImpl.this.rosterEntry.get()).setName(name);
                }
                catch (XMPPException e) {
                    LOG.debugf("set name failed", (Object)e);
                }
            }
        }), "set-name-thread-" + this.toString());
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, FriendPresence> getPresences() {
        Object object = this.presenceLock;
        synchronized (object) {
            return Collections.unmodifiableMap(new HashMap<String, FriendPresence>(this.presences));
        }
    }

    @Override
    public boolean isSubscribed() {
        switch (this.rosterEntry.get().getType()) {
            case both: 
            case to: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPresense(FriendPresence presence) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("adding presence {0}", (Object)presence.getPresenceId());
        }
        Object object = this.presenceLock;
        synchronized (object) {
            this.presences.put(presence.getPresenceId(), presence);
        }
        this.firePresenceEvent(new PresenceEvent(presence, PresenceEvent.Type.PRESENCE_NEW));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePresense(FriendPresence presence) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("removing presence {0}", (Object)presence.getPresenceId());
        }
        Collection<Feature> features = presence.getFeatures();
        for (Feature feature : features) {
            LOG.debugf("removing feature {0} for {1}", (Object)feature, (Object)presence);
            this.featureRegistry.get(feature.getID()).removeFeature(presence);
        }
        Object object = this.presenceLock;
        synchronized (object) {
            this.presences.remove(presence.getPresenceId());
            if (presence.getPresenceId().equals(this.activePresenceJid)) {
                this.activePresenceJid = null;
            }
            if (!this.isSignedIn()) {
                this.removeChatListener();
            }
        }
        this.firePresenceEvent(new PresenceEvent(presence, PresenceEvent.Type.PRESENCE_UPDATE));
    }

    public String toString() {
        return StringUtils.toString(this, this.id, this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePresence(FriendPresence updatedPresence) {
        if (LOG.isDebugEnabled()) {
            LOG.debugf("updating presence {0}", (Object)updatedPresence.getPresenceId());
        }
        Object object = this.presenceLock;
        synchronized (object) {
            this.presences.put(updatedPresence.getPresenceId(), updatedPresence);
        }
        this.firePresenceEvent(new PresenceEvent(updatedPresence, PresenceEvent.Type.PRESENCE_UPDATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FriendPresence getPresence(String jid) {
        Object object = this.presenceLock;
        synchronized (object) {
            return this.presences.get(jid);
        }
    }

    @Override
    public Network getNetwork() {
        return this.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getChatParticipantId() {
        Object object = this.presenceLock;
        synchronized (object) {
            return this.activePresenceJid == null ? this.id : this.activePresenceJid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActivePresence(String presenceId) {
        Object object = this.presenceLock;
        synchronized (object) {
            this.activePresenceJid = presenceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FriendPresence getActivePresence() {
        Object object = this.presenceLock;
        synchronized (object) {
            return this.presences.get(this.activePresenceJid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActivePresence() {
        Object object = this.presenceLock;
        synchronized (object) {
            return this.activePresenceJid != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSignedIn() {
        Object object = this.presenceLock;
        synchronized (object) {
            return !this.presences.isEmpty();
        }
    }

    @Override
    public MessageWriter createChat(MessageReader reader) {
        if (LOG.isInfoEnabled()) {
            LOG.info("new chat with " + this.getChatParticipantId());
        }
        Chat chat = this.connection.getChatManager().createChat(this.getChatParticipantId(), new DefaultChatStateListener(reader));
        return new DefaultMessageWriter(chat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setChatListenerIfNecessary(IncomingChatListener listener) {
        Object object = this.chatListenerLock;
        synchronized (object) {
            if (this.listenerAdapter == null) {
                this.listenerAdapter = new IncomingChatListenerAdapter(listener);
                this.connection.getChatManager().addChatListener(this.listenerAdapter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChatListener() {
        Object object = this.chatListenerLock;
        synchronized (object) {
            if (this.listenerAdapter != null) {
                this.connection.getChatManager().removeChatListener(this.listenerAdapter);
                this.listenerAdapter = null;
            }
        }
    }

    private class DefaultChatStateListener
    implements ChatStateListener {
        private final MessageReader reader;

        DefaultChatStateListener(MessageReader reader) {
            this.reader = reader;
        }

        @Override
        public void processMessage(Chat chat, Message message) {
            String msgFromJid = message.getFrom();
            if (!XMPPFriendImpl.this.getChatParticipantId().equals(msgFromJid)) {
                XMPPFriendImpl.this.setActivePresence(msgFromJid);
            }
            if (message.getType() == Message.Type.error) {
                String errorMsg = this.parseError(message);
                if (errorMsg != null) {
                    this.reader.error(this.parseError(message));
                }
            } else {
                this.reader.readMessage(message.getBody());
            }
        }

        @Override
        public void stateChanged(Chat chat, org.jivesoftware.smackx.ChatState state) {
            if (XMPPFriendImpl.this.isSignedIn()) {
                this.reader.newChatState(ChatState.valueOf(state.toString()));
            }
        }

        private String parseError(Message errorMessage) {
            String body;
            XMPPError error = errorMessage.getError();
            if (error != null && (body = errorMessage.getBody()) != null) {
                return "Error sending message: '" + body + "' : " + error.toString();
            }
            return null;
        }
    }

    private class DefaultMessageWriter
    implements MessageWriter {
        private Chat chat;

        DefaultMessageWriter(Chat chat) {
            this.chat = chat;
        }

        @Override
        public void writeMessage(String message) throws FriendException {
            try {
                this.chat.setParticipant(XMPPFriendImpl.this.getChatParticipantId());
                this.chat.sendMessage(message);
            }
            catch (XMPPException e) {
                throw new FriendException(e);
            }
        }

        @Override
        public void setChatState(ChatState chatState) throws FriendException {
            try {
                ChatStateManager.getInstance(XMPPFriendImpl.this.connection).setCurrentState(org.jivesoftware.smackx.ChatState.valueOf(chatState.toString()), this.chat);
            }
            catch (XMPPException e) {
                throw new FriendException(e);
            }
        }
    }

    private class IncomingChatListenerAdapter
    implements ChatManagerListener {
        private final IncomingChatListener listener;

        public IncomingChatListenerAdapter(IncomingChatListener listener) {
            this.listener = listener;
        }

        @Override
        public void chatCreated(Chat chat, boolean createdLocally) {
            String chatParticipant = chat.getParticipant();
            if (!createdLocally && this.isForThisUser(chatParticipant)) {
                if (!chatParticipant.equals(XMPPFriendImpl.this.getChatParticipantId())) {
                    XMPPFriendImpl.this.setActivePresence(chatParticipant);
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info("new incoming chat with " + XMPPFriendImpl.this.getChatParticipantId());
                }
                DefaultMessageWriter writer = new DefaultMessageWriter(chat);
                MessageReader reader = this.listener.incomingChat(writer);
                chat.addMessageListener(new DefaultChatStateListener(reader));
            }
        }

        private boolean isForThisUser(String incomingMsgJid) {
            return incomingMsgJid.startsWith(XMPPFriendImpl.this.id);
        }
    }
}

