/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.warnings;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.ui.swing.components.FocusJOptionPane;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorTable;
import org.limewire.ui.swing.util.I18n;

class LibraryFileAdder {
    private final Provider<LibraryMediator> libraryMediator;
    private final Provider<LibraryNavigatorTable> libraryNavigatorTable;
    private final CategoryManager categoryManager;

    @Inject
    public LibraryFileAdder(Provider<LibraryMediator> libraryMediator, Provider<LibraryNavigatorTable> libraryNavigatorTable, CategoryManager categoryManager) {
        this.libraryMediator = libraryMediator;
        this.libraryNavigatorTable = libraryNavigatorTable;
        this.categoryManager = categoryManager;
    }

    void addFilesInner(LocalFileList fileList, List<File> files, FileFilter fileFilter) {
        LibraryNavItem libraryNavItem;
        if (this.libraryMediator.get().isInitialized() && (libraryNavItem = this.libraryNavigatorTable.get().getSelectedItem()) != null && libraryNavItem.getLocalFileList() == fileList && this.shouldClearFilter(files)) {
            this.libraryMediator.get().clearFilters();
        }
        ArrayList<File> rejectedFiles = new ArrayList<File>();
        for (File file : files) {
            if (fileList.isDirectoryAllowed(file)) {
                fileList.addFolder(file, fileFilter);
                continue;
            }
            if (fileList.isFileAllowed(file)) {
                fileList.addFile(file);
                continue;
            }
            rejectedFiles.add(file);
        }
        if (rejectedFiles.size() > 0) {
            FocusJOptionPane.showMessageDialog(null, this.getRejectedMessage(rejectedFiles), I18n.trn("File/Folder not added", "File(s)/Folder(s) not added", rejectedFiles.size()), 1);
        }
    }

    private boolean shouldClearFilter(List<File> files) {
        Category category = this.libraryMediator.get().getComponent().getSelectedCategory();
        boolean shouldClear = false;
        for (File file : files) {
            if (file.isDirectory()) {
                shouldClear = true;
                break;
            }
            Category fileCategory = this.categoryManager.getCategoryForFile(file);
            if (fileCategory == category) continue;
            shouldClear = true;
            break;
        }
        return shouldClear;
    }

    private String getRejectedMessage(List<File> rejectedFiles) {
        if (rejectedFiles.size() == 1) {
            return I18n.tr("{0} could not be added to the Library.", rejectedFiles.get(0).getName());
        }
        int folderCount = 0;
        int fileCount = 0;
        for (File file : rejectedFiles) {
            if (file.isDirectory()) {
                ++folderCount;
                continue;
            }
            ++fileCount;
        }
        if (folderCount > 0 && fileCount > 0) {
            return I18n.tr("{0} folders and {1} files could not be added to the Library.", folderCount, fileCount);
        }
        if (folderCount > 0) {
            return I18n.tr("{0} folders could not be added to the Library.", folderCount);
        }
        return I18n.tr("{0} files could not be added to the Library.", fileCount);
    }
}

