/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.util;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.collection.FixedsizeForgetfulHashSet;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.core.api.Category;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.settings.SharingSettings;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.FileIconController;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.SwingUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class NativeFileIconController
implements FileIconController {
    private final SmartFileView VIEW;
    private final Map<String, Icon> EXTENSIONS = new HashMap<String, Icon>();
    private final Icon NULL = new ImageIcon();
    private final CategoryManager categoryManager;

    @Inject
    NativeFileIconController(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
        SmartFileView view = this.getNativeFileView();
        if (view == null) {
            this.VIEW = null;
        } else {
            this.VIEW = new DelegateFileView(view);
            if (SwingUiSettings.PRELOAD_NATIVE_ICONS.getValue()) {
                this.preload();
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.VIEW != null && this.VIEW.isViewAvailable();
    }

    @Override
    public boolean isIconForFileAvailable(File f) {
        return this.VIEW.isIconCached(f);
    }

    private SmartFileView getNativeFileView() {
        if (OSUtils.isWindows()) {
            return this.constructFSVView();
        }
        return this.constructFileChooserView();
    }

    private SmartFileView constructFileChooserView() {
        JFileChooser chooser = null;
        for (int i = 0; i < 10; ++i) {
            try {
                chooser = new JFileChooser(){
                    {
                        FileChooserUI ui = (FileChooserUI)GuiUtils.getNativeUI(this);
                        this.setUI(ui);
                        this.setFileView(ui.getFileView(this));
                    }
                };
            }
            catch (NullPointerException ignored) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (chooser != null) break;
        }
        if (chooser == null) {
            return null;
        }
        return new SmartChooserView(chooser.getFileView());
    }

    public SmartFileView constructFSVView() {
        final AtomicReference ref = new AtomicReference();
        SwingUtils.invokeNowOrWait(new Runnable(){

            @Override
            public void run() {
                try {
                    ref.set(new FSVFileView());
                }
                catch (Throwable err) {
                    ref.set(null);
                }
            }
        });
        return (SmartFileView)ref.get();
    }

    @Override
    public Icon getIconForFile(File f) {
        if (f == null) {
            return null;
        }
        if (this.VIEW.isIconCached(f) || f.exists()) {
            return this.VIEW.getIcon(f);
        }
        String extension = FileUtils.getFileExtension(f);
        if (!extension.isEmpty()) {
            return this.getIconForExtension(extension);
        }
        return null;
    }

    @Override
    public Icon getIconForExtension(String ext) {
        Icon icon = this.EXTENSIONS.get(ext = ext.trim().toLowerCase());
        if (icon != null) {
            if (icon != this.NULL) {
                return icon;
            }
            return null;
        }
        File dir = SharingSettings.INCOMPLETE_DIRECTORY.get();
        File tmp = new File(dir, ".LimeWireIconFinder." + ext);
        if (tmp.exists()) {
            icon = this.VIEW.getIcon(tmp);
        } else {
            try {
                FileUtils.touch(tmp);
                icon = this.VIEW.getIcon(tmp);
                if (icon == null) {
                    icon = this.NULL;
                }
            }
            catch (IOException fnfe) {
                icon = this.NULL;
            }
        }
        tmp.delete();
        this.EXTENSIONS.put(ext, icon);
        this.VIEW.removeFromCache(tmp);
        return icon;
    }

    private void preload() {
        ListeningExecutorService queue = ExecutorsHelper.newProcessingQueue("IconLoader");
        Category[] categories = Category.values();
        final AtomicBoolean continueLoading = new AtomicBoolean(true);
        for (int i = 0; i < categories.length && continueLoading.get(); ++i) {
            Collection<String> exts = this.categoryManager.getExtensionsForCategory(categories[i]);
            Iterator<String> j = exts.iterator();
            while (j.hasNext() && continueLoading.get()) {
                final String next = j.next();
                queue.execute(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtils.invokeNowOrWait(new Runnable(){

                            @Override
                            public void run() {
                                NativeFileIconController.this.getIconForExtension(next);
                                if (!NativeFileIconController.this.VIEW.isViewAvailable()) {
                                    continueLoading.set(false);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private static class SmartChooserView
    extends SmartFileView {
        private final FileView DELEGATE;
        private final Set<File> CACHE = new FixedsizeForgetfulHashSet<File>(5000, 1000);

        public SmartChooserView(FileView delegate) {
            this.DELEGATE = delegate;
        }

        @Override
        public String getDescription(File f) {
            return this.DELEGATE.getDescription(f);
        }

        @Override
        public Icon getIcon(File f) {
            this.CACHE.add(f);
            return this.DELEGATE.getIcon(f);
        }

        @Override
        public String getName(File f) {
            return this.DELEGATE.getName(f);
        }

        @Override
        public String getTypeDescription(File f) {
            return this.DELEGATE.getTypeDescription(f);
        }

        @Override
        public Boolean isTraversable(File f) {
            return this.DELEGATE.isTraversable(f);
        }

        @Override
        public boolean isIconCached(File f) {
            return this.CACHE.contains(f);
        }

        @Override
        public boolean removeFromCache(File f) {
            return this.CACHE.remove(f);
        }
    }

    private static class FSVFileView
    extends SmartFileView {
        private final FileSystemView VIEW = FileSystemView.getFileSystemView();
        private final Map<File, Icon> CACHE = new FixedsizeForgetfulHashMap<File, Icon>(50000);

        FSVFileView() {
            File documents;
            File child;
            String path;
            File[] roots = this.VIEW.getRoots();
            for (int i = 0; i < roots.length; ++i) {
                this.CACHE.put(new File(roots[i].getPath()), this.VIEW.getSystemIcon(roots[i]));
            }
            if (OSUtils.isWindows() && !OSUtils.isWindowsVista() && !OSUtils.isWindows7() && roots.length == 1 && (path = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOCUMENTS)) != null && (child = this.VIEW.getChild(roots[0], (documents = new File(path)).getName())) != null) {
                this.CACHE.put(documents, this.VIEW.getSystemIcon(child));
            }
        }

        @Override
        public String getDescription(File f) {
            return this.VIEW.getSystemTypeDescription(f);
        }

        @Override
        public Icon getIcon(File f) {
            Icon icon = this.CACHE.get(f);
            if (icon == null) {
                icon = this.VIEW.getSystemIcon(f);
                this.CACHE.put(f, icon);
            }
            return icon;
        }

        @Override
        public String getName(File f) {
            return this.VIEW.getSystemDisplayName(f);
        }

        @Override
        public String getTypeDescription(File f) {
            return this.VIEW.getSystemTypeDescription(f);
        }

        @Override
        public Boolean isTraversable(File f) {
            return this.VIEW.isTraversable(f);
        }

        @Override
        public boolean isIconCached(File f) {
            return this.CACHE.containsKey(f);
        }

        @Override
        public boolean removeFromCache(File f) {
            return this.CACHE.remove(f) != null;
        }
    }

    private static class DelegateFileView
    extends SmartFileView {
        private final SmartFileView DELEGATE;
        private boolean linkFailed = false;

        DelegateFileView(SmartFileView real) {
            this.DELEGATE = real;
        }

        @Override
        public boolean isViewAvailable() {
            return !this.linkFailed;
        }

        @Override
        public Icon getIcon(File f) {
            try {
                Icon icon = this.DELEGATE.getIcon(f);
                return icon;
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.linkFailed = true;
                return null;
            }
        }

        @Override
        public String getDescription(File f) {
            try {
                return this.DELEGATE.getDescription(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.linkFailed = true;
                return null;
            }
        }

        @Override
        public String getName(File f) {
            try {
                return this.DELEGATE.getName(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.linkFailed = true;
                return null;
            }
        }

        @Override
        public String getTypeDescription(File f) {
            try {
                return this.DELEGATE.getTypeDescription(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.linkFailed = true;
                return null;
            }
        }

        @Override
        public Boolean isTraversable(File f) {
            try {
                return this.DELEGATE.isTraversable(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
            catch (UnsatisfiedLinkError ule) {
                this.linkFailed = true;
                return null;
            }
        }

        @Override
        public boolean isIconCached(File f) {
            return this.DELEGATE.isIconCached(f);
        }

        @Override
        public boolean removeFromCache(File f) {
            return this.DELEGATE.removeFromCache(f);
        }
    }

    private static abstract class SmartFileView
    extends FileView {
        private SmartFileView() {
        }

        public abstract boolean isIconCached(File var1);

        public abstract boolean removeFromCache(File var1);

        public boolean isViewAvailable() {
            return true;
        }
    }
}

