/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.table.TableColumnExt;
import org.limewire.ui.swing.settings.TablesHandler;
import org.limewire.ui.swing.table.ColumnStateInfo;
import org.limewire.ui.swing.table.GlazedJXTable;
import org.limewire.ui.swing.table.VisibleTableFormat;

public class ColumnStateHandler
implements TableColumnModelListener,
MouseListener,
PropertyChangeListener {
    private final GlazedJXTable table;
    private final VisibleTableFormat format;
    private boolean columnMoved = false;
    private boolean visibleChangeEnabled = true;

    public ColumnStateHandler(GlazedJXTable table, VisibleTableFormat format) {
        this.table = table;
        this.format = format;
        this.startListening();
        for (int i = 0; i < format.getColumnCount(); ++i) {
            table.getColumnExt(i).addPropertyChangeListener(this);
        }
    }

    private void startListening() {
        this.table.getTableHeader().addMouseListener(this);
        this.table.getColumnModel().addColumnModelListener(this);
    }

    private void stopListening() {
        this.table.getTableHeader().removeMouseListener(this);
        this.table.getColumnModel().removeColumnModelListener(this);
    }

    public void removeListeners() {
        this.stopListening();
        for (int i = 0; i < this.format.getColumnCount(); ++i) {
            TableColumnExt ext = this.table.getColumnExt(this.format.getColumnName(i));
            if (ext == null) continue;
            ext.removePropertyChangeListener(this);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (e.getFromIndex() == e.getToIndex() || !this.table.isShowing()) {
            return;
        }
        this.columnMoved = true;
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TableColumn column;
        if (SwingUtilities.isLeftMouseButton(e) && (column = this.table.getSortedColumn()) != null) {
            SortOrder sortOrder = this.getSortOrder(this.table, column.getModelIndex());
            this.setSortedColumn(column.getModelIndex(), sortOrder.isAscending());
        }
    }

    private SortOrder getSortOrder(GlazedJXTable table, int modelColumn) {
        SortController sortController = table.getSortController();
        if (sortController == null) {
            return SortOrder.UNSORTED;
        }
        List<? extends SortKey> sortKeys = sortController.getSortKeys();
        if (sortKeys == null) {
            return SortOrder.UNSORTED;
        }
        SortKey firstKey = SortKey.getFirstSortingKey(sortKeys);
        if (firstKey != null && firstKey.getColumn() == modelColumn) {
            return firstKey.getSortOrder();
        }
        return SortOrder.UNSORTED;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.columnMoved) {
            this.columnMoved = false;
            this.saveColumnOrder();
        }
    }

    private void saveColumnOrder() {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn column = this.table.getColumn(i);
            ColumnStateInfo info = this.format.getColumnInfo(column.getModelIndex());
            if (info.getPreferredViewIndex() == i) continue;
            info.setPreferredViewIndex(i);
            this.setOrder(info, i);
        }
    }

    public void revertToDefault() {
    }

    public void setupColumnWidths() {
        for (int i = 0; i < this.format.getColumnCount(); ++i) {
            if (this.format.getMaxsWidth(i) != -1) {
                this.table.getColumn(i).setMaxWidth(this.format.getMaxsWidth(i));
            }
            this.table.getColumn(i).setPreferredWidth(this.format.getInitialWidth(i));
        }
    }

    public void setupColumnOrder() {
        this.stopListening();
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumn(i);
            columns.add(tableColumn);
        }
        Collections.sort(columns, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn o1, TableColumn o2) {
                ColumnStateInfo info1 = ColumnStateHandler.this.format.getColumnInfo(o1.getModelIndex());
                ColumnStateInfo info2 = ColumnStateHandler.this.format.getColumnInfo(o2.getModelIndex());
                Integer prefferedIndex1 = info1.getPreferredViewIndex();
                Integer prefferedIndex2 = info2.getPreferredViewIndex();
                return prefferedIndex1.compareTo(prefferedIndex2) * -1;
            }
        });
        for (TableColumn tableColumn : columns) {
            int currentIndex = this.getCurrentIndex(tableColumn);
            if (currentIndex <= 0 || currentIndex >= this.table.getColumnCount()) continue;
            this.table.getColumnModel().moveColumn(currentIndex, 0);
        }
        this.startListening();
    }

    private int getCurrentIndex(TableColumn tableColumn) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            if (this.table.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    public void setupColumnVisibility() {
        this.setupColumnVisibility(true);
    }

    public void setupColumnVisibility(boolean propertyChangeEnabled) {
        this.visibleChangeEnabled = propertyChangeEnabled;
        this.stopListening();
        for (int i = this.format.getColumnCount() - 1; i >= 0; --i) {
            TableColumnExt column = this.table.getColumnExt(i);
            column.setVisible(this.format.isVisibleAtStartup(column.getModelIndex()));
        }
        this.startListening();
        this.visibleChangeEnabled = true;
    }

    private void setVisibility(ColumnStateInfo info, boolean isVisible) {
        TablesHandler.getVisibility(info.getId(), info.isDefaultlyShown()).setValue(isVisible);
    }

    private void setOrder(ColumnStateInfo column, int order) {
        TablesHandler.getOrder(column.getId(), column.getModelIndex()).setValue(order);
    }

    private void setWidth(ColumnStateInfo column, int width) {
        TablesHandler.getWidth(column.getId(), column.getDefaultWidth()).setValue(width);
    }

    private void setSortedColumn(int sortedColumn, boolean sortOrder) {
        TablesHandler.getSortedColumn(this.format.getSortOrderID(), this.format.getSortedColumn()).setValue(sortedColumn);
        TablesHandler.getSortedOrder(this.format.getSortOrderID(), this.format.getSortOrder()).setValue(sortOrder);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ColumnStateInfo info;
        if (evt.getPropertyName().equals("width") && this.table.isShowing()) {
            info = this.format.getColumnInfo(((TableColumnExt)evt.getSource()).getModelIndex());
            this.setWidth(info, (Integer)evt.getNewValue());
        }
        if (evt.getPropertyName().equals("visible") && this.table.isShowing() && this.visibleChangeEnabled) {
            info = this.format.getColumnInfo(((TableColumnExt)evt.getSource()).getModelIndex());
            this.setVisibility(info, Boolean.TRUE.equals(evt.getNewValue()));
            this.saveColumnOrder();
        }
    }
}

