/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.NECallable;
import org.limewire.collection.StringTrieSet;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.SimpleFuture;
import org.limewire.ui.swing.components.AutoCompleter;
import org.limewire.ui.swing.components.CollectionBackedListModel;
import org.limewire.ui.swing.components.ExtendedCompoundBorder;
import org.limewire.ui.swing.components.SideLineBorder;
import org.limewire.ui.swing.util.FontUtils;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;

public class HistoryAndFriendAutoCompleter
implements AutoCompleter {
    private final ListeningExecutorService queue = ExecutorsHelper.newProcessingQueue("AutoCompleteQueue");
    @Resource
    private Color selectionBackground;
    @Resource
    private Font font;
    private ListeningFuture<Boolean> lastFuture;
    private final JPanel entryPanel;
    private AutoCompleter.AutoCompleterCallback callback;
    private String currentText;
    private boolean showSuggestions = true;
    private AutoCompleteDictionary historyDictionary;
    private AutoCompleteDictionary suggestionDictionary;
    private final AutoCompleteList entryList;

    public HistoryAndFriendAutoCompleter() {
        this(new StringTrieSet(true));
    }

    public HistoryAndFriendAutoCompleter(AutoCompleteDictionary dictionary) {
        GuiUtils.assignResources(this);
        this.suggestionDictionary = dictionary;
        this.entryPanel = new JPanel(new MigLayout("insets 0, gap 0, fill"));
        this.entryPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        this.entryList = new AutoCompleteList();
        JScrollPane entryScrollPane = new JScrollPane(this.entryList);
        entryScrollPane.setBorder(BorderFactory.createEmptyBorder());
        entryScrollPane.setVerticalScrollBarPolicy(20);
        entryScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)entryScrollPane, "grow");
    }

    public void setSuggestionsShown(boolean value) {
        this.showSuggestions = value;
    }

    public void setSuggestionDictionary(AutoCompleteDictionary dictionary) {
        this.suggestionDictionary = dictionary;
    }

    public void setHistoryDictionary(AutoCompleteDictionary dictionary) {
        this.historyDictionary = dictionary;
    }

    @Override
    public void setAutoCompleterCallback(AutoCompleter.AutoCompleterCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean isAutoCompleteAvailable() {
        return this.entryList.getModel().getSize() != 0;
    }

    @Override
    public void decrementSelection() {
        this.entryList.decrementSelection();
    }

    @Override
    public JComponent getRenderComponent() {
        return this.entryPanel;
    }

    @Override
    public String getSelectedAutoCompleteString() {
        Object selection = this.entryList.getSelectedValue();
        if (selection != null) {
            return selection.toString();
        }
        return null;
    }

    @Override
    public void incrementSelection() {
        this.entryList.incrementSelection();
    }

    @Override
    public ListeningFuture<Boolean> setInput(String input) {
        if (input == null) {
            input = "";
        }
        this.currentText = input;
        if (this.historyDictionary.isImmediate() && this.suggestionDictionary.isImmediate()) {
            try {
                this.lookupAndSetItems(this.currentText);
            }
            catch (InterruptedException error) {
                throw new IllegalStateException(error);
            }
            return new SimpleFuture<Boolean>(true);
        }
        if (this.lastFuture != null) {
            this.lastFuture.cancel(true);
        }
        this.setItems(Collections.<Entry>emptyList());
        final String lookupText = this.currentText;
        this.lastFuture = this.queue.submit(new NECallable<Boolean>(){

            @Override
            public Boolean call() {
                if (Thread.interrupted()) {
                    return false;
                }
                try {
                    HistoryAndFriendAutoCompleter.this.lookupAndSetItems(lookupText);
                    return true;
                }
                catch (InterruptedException ignored) {
                    return false;
                }
            }
        });
        return this.lastFuture;
    }

    private void lookupAndSetItems(String lookupText) throws InterruptedException {
        Collection<String> histories = this.historyDictionary.getPrefixedBy(lookupText);
        final ArrayList<Entry> items = new ArrayList<Entry>(histories.size());
        for (String string : histories) {
            items.add(new Entry(string, Entry.Reason.HISTORY));
        }
        if (this.showSuggestions) {
            Collection<String> suggestions = this.suggestionDictionary.getPrefixedBy(lookupText);
            items.ensureCapacity(items.size() + suggestions.size());
            boolean needFirstSuggestion = true;
            for (String string : suggestions) {
                if (needFirstSuggestion) {
                    items.add(new Entry(string, Entry.Reason.FIRST_SUGGESTION));
                    needFirstSuggestion = false;
                    continue;
                }
                items.add(new Entry(string, Entry.Reason.SUGGESTION));
            }
        }
        SwingUtils.invokeNowOrWaitWithInterrupted(new Runnable(){

            @Override
            public void run() {
                HistoryAndFriendAutoCompleter.this.setItems(items);
            }
        });
    }

    private void setItems(Collection<Entry> items) {
        this.entryList.setModel(new CollectionBackedListModel(items));
        this.entryList.setVisibleRowCount(Math.min(8, items.size()));
    }

    private static class Entry {
        private final String item;
        private final Reason reason;

        public Entry(String item, Reason reason) {
            this.item = item;
            this.reason = reason;
        }

        public String toString() {
            return this.item;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return ((Entry)obj).item.equals(this.item) && ((Entry)obj).reason == this.reason;
        }

        private static enum Reason {
            HISTORY,
            FIRST_SUGGESTION,
            SUGGESTION;

        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private final ExtendedCompoundBorder compoundBorder;
        private final JPanel firstSuggestionPanel;
        private final DefaultListCellRenderer firstSuggestionLabel;
        private final JLabel firstSuggestionTitle;
        private final Border firstSuggestionBorder = new SideLineBorder(Color.GRAY, SideLineBorder.Side.TOP);

        public Renderer() {
            this.compoundBorder = new ExtendedCompoundBorder(BorderFactory.createEmptyBorder(), BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.firstSuggestionPanel = new JPanel();
            this.firstSuggestionPanel.setLayout(new MigLayout("fill, gap 0, insets 0"));
            this.firstSuggestionPanel.setBorder(this.compoundBorder);
            this.firstSuggestionLabel = new DefaultListCellRenderer();
            this.firstSuggestionTitle = new DefaultListCellRenderer();
            this.firstSuggestionTitle.setText(I18n.tr("Friend Suggestions"));
            FontUtils.changeSize(this.firstSuggestionTitle, -1.0f);
            this.firstSuggestionTitle.setForeground(Color.GRAY);
            this.firstSuggestionPanel.add((Component)this.firstSuggestionLabel, "alignx left, grow, wmin 0, gapright 10");
            this.firstSuggestionPanel.add((Component)this.firstSuggestionTitle, "alignx right");
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String render;
            if (value == null) {
                render = "";
            } else {
                render = value.toString();
                if (value instanceof Entry && ((Entry)value).reason == Entry.Reason.FIRST_SUGGESTION) {
                    this.firstSuggestionLabel.getListCellRendererComponent((JList<?>)list, render, index, isSelected, cellHasFocus);
                    this.firstSuggestionLabel.setBorder(BorderFactory.createEmptyBorder());
                    if (isSelected) {
                        this.firstSuggestionTitle.setForeground(list.getSelectionForeground());
                    } else {
                        this.firstSuggestionTitle.setForeground(Color.GRAY);
                    }
                    if (index != 0) {
                        this.compoundBorder.setOuterBorder(this.firstSuggestionBorder);
                    } else {
                        this.compoundBorder.setOuterBorder(BorderFactory.createEmptyBorder());
                    }
                    this.firstSuggestionTitle.setBackground(this.firstSuggestionLabel.getBackground());
                    this.firstSuggestionPanel.setBackground(this.firstSuggestionLabel.getBackground());
                    return this.firstSuggestionPanel;
                }
            }
            super.getListCellRendererComponent((JList<?>)list, render, index, isSelected, cellHasFocus);
            this.compoundBorder.setOuterBorder(this.getBorder());
            this.setBorder(this.compoundBorder);
            return this;
        }
    }

    private class AutoCompleteList
    extends JList {
        AutoCompleteList() {
            this.enableEvents(16L);
            this.setSelectionMode(0);
            this.setFocusable(false);
            this.setCellRenderer(new Renderer());
            this.setFont(HistoryAndFriendAutoCompleter.this.font);
            this.setSelectionBackground(HistoryAndFriendAutoCompleter.this.selectionBackground);
            this.setSelectionForeground(Color.BLACK);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            int idx;
            super.processMouseEvent(me);
            if (me.getID() == 500 && (idx = this.locationToIndex(me.getPoint())) != -1 && this.isSelectedIndex(idx)) {
                HistoryAndFriendAutoCompleter.this.callback.itemSuggested(this.getSelectedValue().toString(), false, true);
            }
        }

        void incrementSelection() {
            if (this.getSelectedIndex() == this.getModel().getSize() - 1) {
                HistoryAndFriendAutoCompleter.this.callback.itemSuggested(HistoryAndFriendAutoCompleter.this.currentText, true, false);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex() + 1;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                HistoryAndFriendAutoCompleter.this.callback.itemSuggested(this.getSelectedValue().toString(), true, false);
            }
        }

        void decrementSelection() {
            if (this.getSelectedIndex() == 0) {
                HistoryAndFriendAutoCompleter.this.callback.itemSuggested(HistoryAndFriendAutoCompleter.this.currentText, true, false);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex();
                selectedIndex = selectedIndex == -1 ? this.getModel().getSize() - 1 : --selectedIndex;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                HistoryAndFriendAutoCompleter.this.callback.itemSuggested(this.getSelectedValue().toString(), true, false);
            }
        }
    }
}

