/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.Category;
import org.limewire.core.settings.SharingSettings;
import org.limewire.setting.FileSetting;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.LabelTextField;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.options.actions.BrowseDirectoryAction;
import org.limewire.ui.swing.options.actions.CancelDialogAction;
import org.limewire.ui.swing.util.CategoryIconManager;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.util.Objects;

public class ManageSaveFoldersOptionPanel
extends OptionPanel {
    private Map<Category, String> mediaDirectoryMap = new EnumMap<Category, String>(Category.class);
    private LabelTextField audioTextField;
    private LabelTextField videoTextField;
    private LabelTextField imageTextField;
    private LabelTextField documentTextField;
    private LabelTextField programTextField;
    private LabelTextField otherTextField;
    private JButton audioBrowseButton;
    private JButton videoBrowseButton;
    private JButton imageBrowseButton;
    private JButton documentBrowseButton;
    private JButton programBrowseButton;
    private JButton otherBrowseButton;
    private JButton defaultButton;
    private JButton okButton;
    private JButton cancelButton;

    @Inject
    public ManageSaveFoldersOptionPanel(CategoryIconManager categoryIconManager, @Assisted Action okAction, @Assisted CancelDialogAction cancelAction, Provider<IconManager> iconManager) {
        GuiUtils.assignResources(this);
        this.setLayout(new MigLayout("fill, gapy 10"));
        this.audioTextField = new LabelTextField(iconManager);
        this.videoTextField = new LabelTextField(iconManager);
        this.imageTextField = new LabelTextField(iconManager);
        this.documentTextField = new LabelTextField(iconManager);
        this.programTextField = new LabelTextField(iconManager);
        this.otherTextField = new LabelTextField(iconManager);
        this.audioBrowseButton = new JButton(new BrowseDirectoryAction(this, this.audioTextField));
        this.audioTextField.addMouseListener(this.audioBrowseButton.getAction());
        this.videoBrowseButton = new JButton(new BrowseDirectoryAction(this, this.videoTextField));
        this.videoTextField.addMouseListener(this.videoBrowseButton.getAction());
        this.imageBrowseButton = new JButton(new BrowseDirectoryAction(this, this.imageTextField));
        this.imageTextField.addMouseListener(this.imageBrowseButton.getAction());
        this.documentBrowseButton = new JButton(new BrowseDirectoryAction(this, this.documentTextField));
        this.documentTextField.addMouseListener(this.documentBrowseButton.getAction());
        this.programBrowseButton = new JButton(new BrowseDirectoryAction(this, this.programTextField));
        this.programTextField.addMouseListener(this.programBrowseButton.getAction());
        this.otherBrowseButton = new JButton(new BrowseDirectoryAction(this, this.otherTextField));
        this.otherTextField.addMouseListener(this.otherBrowseButton.getAction());
        cancelAction.setOptionPanel(this);
        this.defaultButton = new JButton(new DefaultAction());
        this.okButton = new JButton(okAction);
        this.cancelButton = new JButton(cancelAction);
        this.add((Component)new JLabel(I18n.tr("Choose where specific file types get saved")), "span, wrap");
        this.add((Component)new JLabel(I18n.tr("Audio"), categoryIconManager.getIcon(Category.AUDIO), 4), "span, wrap");
        this.add((Component)this.audioTextField, "growx");
        this.add((Component)this.audioBrowseButton, "gapleft 30, wrap");
        this.add((Component)new JLabel(I18n.tr("Video"), categoryIconManager.getIcon(Category.VIDEO), 4), "span, wrap");
        this.add((Component)this.videoTextField, "growx");
        this.add((Component)this.videoBrowseButton, "gapleft 30, wrap");
        this.add((Component)new JLabel(I18n.tr("Images"), categoryIconManager.getIcon(Category.IMAGE), 4), "span, wrap");
        this.add((Component)this.imageTextField, "growx");
        this.add((Component)this.imageBrowseButton, "gapleft 30, wrap");
        this.add((Component)new JLabel(I18n.tr("Documents"), categoryIconManager.getIcon(Category.DOCUMENT), 4), "span, wrap");
        this.add((Component)this.documentTextField, "growx");
        this.add((Component)this.documentBrowseButton, "gapleft 30, wrap");
        this.add((Component)new JLabel(I18n.tr("Programs"), categoryIconManager.getIcon(Category.PROGRAM), 4), "span, wrap");
        this.add((Component)this.programTextField, "growx");
        this.add((Component)this.programBrowseButton, "gapleft 30, wrap");
        this.add((Component)new JLabel(I18n.tr("Other"), categoryIconManager.getIcon(Category.OTHER), 4), "span, wrap");
        this.add((Component)this.otherTextField, "growx");
        this.add((Component)this.otherBrowseButton, "gapleft 30, wrap");
        this.add((Component)this.defaultButton, "gaptop 10, span, split 3, push");
        this.add((Component)this.okButton, "tag ok, alignx right, gaptop 10");
        this.add((Component)this.cancelButton, "tag cancel, alignx right, gaptop 10");
    }

    @Override
    boolean applyOptions() {
        this.applyOption(Category.AUDIO, this.audioTextField);
        this.applyOption(Category.VIDEO, this.videoTextField);
        this.applyOption(Category.IMAGE, this.imageTextField);
        this.applyOption(Category.DOCUMENT, this.documentTextField);
        this.applyOption(Category.PROGRAM, this.programTextField);
        this.applyOption(Category.OTHER, this.otherTextField);
        return false;
    }

    private void revertToDefault(LabelTextField textField) {
        textField.setText(SharingSettings.getSaveDirectory().getAbsolutePath());
    }

    void revertToDefault() {
        this.revertToDefault(this.audioTextField);
        this.revertToDefault(this.videoTextField);
        this.revertToDefault(this.imageTextField);
        this.revertToDefault(this.documentTextField);
        this.revertToDefault(this.programTextField);
        this.revertToDefault(this.otherTextField);
    }

    boolean isConfigCustom() {
        File defaultLocation = SharingSettings.getSaveDirectory();
        if (!SharingSettings.getFileSettingForCategory(Category.AUDIO).get().equals(defaultLocation)) {
            return true;
        }
        if (!SharingSettings.getFileSettingForCategory(Category.VIDEO).get().equals(defaultLocation)) {
            return true;
        }
        if (!SharingSettings.getFileSettingForCategory(Category.IMAGE).get().equals(defaultLocation)) {
            return true;
        }
        if (!SharingSettings.getFileSettingForCategory(Category.DOCUMENT).get().equals(defaultLocation)) {
            return true;
        }
        if (!SharingSettings.getFileSettingForCategory(Category.PROGRAM).get().equals(defaultLocation)) {
            return true;
        }
        return !SharingSettings.getFileSettingForCategory(Category.OTHER).get().equals(defaultLocation);
    }

    private void applyOption(Category mediaType, LabelTextField textField) {
        if (this.hasChanged(mediaType, textField)) {
            String saveDirString;
            FileSetting saveDirSetting = SharingSettings.getFileSettingForCategory(mediaType);
            String newSaveDirString = textField.getText();
            if (!newSaveDirString.equals(saveDirString = SharingSettings.getSaveDirectory().getAbsolutePath())) {
                File newSaveDir = new File(newSaveDirString);
                saveDirSetting.set(newSaveDir);
            } else {
                saveDirSetting.revertToDefault();
            }
        }
    }

    @Override
    boolean hasChanged() {
        return this.hasChanged(Category.AUDIO, this.audioTextField) || this.hasChanged(Category.VIDEO, this.videoTextField) || this.hasChanged(Category.IMAGE, this.imageTextField) || this.hasChanged(Category.DOCUMENT, this.documentTextField) || this.hasChanged(Category.PROGRAM, this.programTextField) || this.hasChanged(Category.OTHER, this.otherTextField);
    }

    private boolean hasChanged(Category mediaType, LabelTextField textField) {
        String newSaveDirString;
        String oldSaveDirString = this.mediaDirectoryMap.get((Object)mediaType);
        return !Objects.equalOrNull(oldSaveDirString, newSaveDirString = textField.getText());
    }

    @Override
    public void initOptions() {
        this.initField(Category.AUDIO, this.audioTextField);
        this.initField(Category.VIDEO, this.videoTextField);
        this.initField(Category.IMAGE, this.imageTextField);
        this.initField(Category.DOCUMENT, this.documentTextField);
        this.initField(Category.PROGRAM, this.programTextField);
        this.initField(Category.OTHER, this.otherTextField);
    }

    private void initField(Category mediaType, LabelTextField textField) {
        FileSetting saveDirSetting = SharingSettings.getFileSettingForCategory(mediaType);
        File saveDir = saveDirSetting.get();
        String saveDirString = saveDir.getAbsolutePath();
        textField.setText(saveDirString);
        this.mediaDirectoryMap.put(mediaType, saveDirString);
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Revert directories to the default"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ManageSaveFoldersOptionPanel.this.revertToDefault();
        }
    }
}

