/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.application.Resource;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.util.GuiUtils;

class LibraryNavTableRenderer
extends JLabel
implements TableCellRenderer {
    private Border border;
    private Border dropBorder;
    @Resource
    private Color selectedColor;
    @Resource
    private Font font;
    @Resource
    private Color fontColor;
    @Resource
    private int iconGap;
    @Resource
    private Icon libraryIcon;
    @Resource
    private Icon publicIcon;
    @Resource
    private Icon listIcon;
    @Resource
    private Icon listSharedIcon;
    @Resource
    private Color dropBackgroundColor;
    @Resource
    private Color dropBorderColor;

    @Inject
    public LibraryNavTableRenderer() {
        GuiUtils.assignResources(this);
        this.border = BorderFactory.createEmptyBorder(5, 6, 5, 6);
        this.dropBorder = new CompoundBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, this.dropBorderColor), BorderFactory.createEmptyBorder(3, 4, 3, 4));
        this.setBackground(this.selectedColor);
        this.setFont(this.font);
        this.setIconTextGap(this.iconGap);
        this.setForeground(this.fontColor);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof LibraryNavItem) {
            LibraryNavItem item = (LibraryNavItem)value;
            this.setText(item.getDisplayText());
            this.setToolTipText(item.getDisplayText());
            this.setIconType(item);
        } else {
            this.setText("");
            this.setToolTipText("");
            this.setIcon(null);
        }
        JTable.DropLocation dropLocation = table.getDropLocation();
        if (dropLocation != null && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
            this.setOpaque(true);
            this.setBorder(this.dropBorder);
            this.setBackground(this.dropBackgroundColor);
        } else {
            this.setBorder(this.border);
            this.setOpaque(isSelected);
            this.setBackground(this.selectedColor);
        }
        return this;
    }

    private void setIconType(LibraryNavItem item) {
        if (item.getType() == LibraryNavItem.NavType.LIBRARY) {
            this.setIcon(this.libraryIcon);
        } else if (item.getType() == LibraryNavItem.NavType.PUBLIC_SHARED) {
            this.setIcon(this.publicIcon);
        } else if (item.getLocalFileList() instanceof SharedFileList) {
            if (((SharedFileList)item.getLocalFileList()).getFriendIds().size() > 0) {
                this.setIcon(this.listSharedIcon);
            } else {
                this.setIcon(this.listIcon);
            }
        } else {
            this.setIcon(this.listIcon);
        }
    }
}

