/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.images;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.DefaultEventListModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXList;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.images.ImageCellRenderer;
import org.limewire.ui.swing.images.ImagePopupHandler;
import org.limewire.ui.swing.library.table.LibraryPopupMenu;
import org.limewire.ui.swing.table.TablePopupHandler;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.NativeLaunchUtils;

public class ImageList
extends JXList
implements Disposable {
    @Resource
    private Color backgroundListcolor;
    private final ImageCellRenderer imageCellRenderer;
    private final CategoryManager categoryManager;
    private DefaultEventListModel cachedEventListModel;
    private DefaultEventSelectionModel<LocalFileItem> cachedEventSelectionModel;

    @Inject
    public ImageList(ImageCellRenderer imageCellRenderer, Provider<LibraryPopupMenu> libraryPopupMenu, CategoryManager categoryManager) {
        this.imageCellRenderer = imageCellRenderer;
        this.categoryManager = categoryManager;
        GuiUtils.assignResources(this);
        this.setBackground(this.backgroundListcolor);
        this.setSelectionMode(2);
        this.setLayoutOrientation(2);
        this.setVisibleRowCount(-1);
        this.setCellRenderer((ListCellRenderer)imageCellRenderer);
        imageCellRenderer.setBorder(BorderFactory.createEmptyBorder(15, 7, 0, 7));
        Insets insets = imageCellRenderer.getBorder().getBorderInsets(imageCellRenderer);
        this.setFixedCellHeight(imageCellRenderer.getHeight() + insets.top + insets.bottom);
        this.setFixedCellWidth(imageCellRenderer.getWidth() + insets.left + insets.right);
        this.addMouseListener(new ImageDoubleClickMouseListener());
        this.setPopupHandler(new ImagePopupHandler(this, libraryPopupMenu));
    }

    public void setModel(EventList<LocalFileItem> eventList) {
        DefaultEventListModel<LocalFileItem> newEventListModel = new DefaultEventListModel<LocalFileItem>(eventList);
        DefaultEventSelectionModel<LocalFileItem> newEventSelectionModel = new DefaultEventSelectionModel<LocalFileItem>(eventList);
        this.setSelectionModel(newEventSelectionModel);
        this.setModel(newEventListModel);
        newEventSelectionModel.setSelectionMode(103);
        if (this.cachedEventListModel != null) {
            this.cachedEventSelectionModel.dispose();
            this.cachedEventListModel.dispose();
        }
        this.cachedEventListModel = newEventListModel;
        this.cachedEventSelectionModel = newEventSelectionModel;
    }

    public List<LocalFileItem> getSelectedItems() {
        return this.cachedEventSelectionModel.getSelected();
    }

    @Override
    public void dispose() {
        if (this.cachedEventListModel != null) {
            this.cachedEventSelectionModel.dispose();
            this.cachedEventListModel.dispose();
        }
    }

    public void setPopupHandler(final TablePopupHandler popupHandler) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popupHandler.maybeShowPopup(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public ImageCellRenderer getImageCellRenderer() {
        return this.imageCellRenderer;
    }

    private final class ImageDoubleClickMouseListener
    extends MouseAdapter {
        private ImageDoubleClickMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ImageList imageList;
            int index;
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (index = (imageList = (ImageList)e.getComponent()).locationToIndex(e.getPoint())) >= 0) {
                LocalFileItem val = (LocalFileItem)imageList.getElementAt(index);
                File file = val.getFile();
                NativeLaunchUtils.safeLaunchFile(file, ImageList.this.categoryManager);
            }
        }
    }
}

