/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.limewire.core.api.FilePropertyKey;
import org.limewire.ui.swing.filter.FilterType;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.util.IconManager;
import org.limewire.util.Objects;

class PropertyMatcher<E extends FilterableItem>
implements Matcher<E> {
    private final FilterType filterType;
    private final FilePropertyKey propertyKey;
    private final Provider<IconManager> iconManager;
    private final Set<Object> values = new HashSet<Object>();

    public PropertyMatcher(FilterType filterType, FilePropertyKey propertyKey, Provider<IconManager> iconManager, Collection<Object> values) {
        this.filterType = filterType;
        this.propertyKey = propertyKey;
        this.iconManager = iconManager;
        this.values.addAll(values);
    }

    @Override
    public boolean matches(E item) {
        if (item == null) {
            return false;
        }
        if (this.values.isEmpty()) {
            return true;
        }
        switch (this.filterType) {
            case EXTENSION: {
                return this.values.contains(item.getFileExtension().toLowerCase());
            }
            case PROPERTY: {
                Object property = item.getProperty(this.propertyKey);
                if (FilePropertyKey.isLong(this.propertyKey)) {
                    return this.values.contains(property);
                }
                for (Object value : this.values) {
                    if (Objects.compareToNullIgnoreCase((String)value, (String)property, false) != 0) continue;
                    return true;
                }
                return false;
            }
            case FILE_TYPE: {
                String type = this.iconManager.get().getMIMEDescription(item.getFileExtension());
                return this.values.contains(type);
            }
        }
        return false;
    }
}

