/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table.renderer;

import com.google.inject.Inject;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.ui.swing.components.decorators.ProgressBarDecorator;
import org.limewire.ui.swing.transfer.TransferProgressRenderer;
import org.limewire.ui.swing.util.I18n;
import org.limewire.util.CommonUtils;

public class DownloadProgressRenderer
extends TransferProgressRenderer {
    @Inject
    public DownloadProgressRenderer(ProgressBarDecorator progressBarDecorator) {
        super(progressBarDecorator);
    }

    @Override
    protected void updateProgress(Object value, int columnWidth) {
        if (value instanceof DownloadItem) {
            DownloadItem item = (DownloadItem)value;
            DownloadState state = item.getState();
            this.progressBar.setValue(item.getPercentComplete());
            this.progressBar.setVisible(columnWidth > this.resources.getProgressBarCutoffWidth() && (state == DownloadState.DOWNLOADING || state == DownloadState.PAUSED || state == DownloadState.SCANNING || state == DownloadState.SCANNING_FRAGMENT));
            this.progressBar.setEnabled(state != DownloadState.PAUSED);
        } else {
            this.progressBar.setValue(0);
            this.progressBar.setVisible(false);
            this.progressBar.setEnabled(true);
        }
    }

    @Override
    protected void updateTime(Object value) {
        if (value instanceof DownloadItem) {
            DownloadItem item = (DownloadItem)value;
            DownloadState state = item.getState();
            if (state == DownloadState.SCANNING) {
                this.timeLabel.setText(I18n.tr("Finalizing..."));
                this.timeLabel.setMinimumSize(this.timeLabel.getPreferredSize());
                this.timeLabel.setVisible(true);
            } else if (state != DownloadState.DOWNLOADING || item.getRemainingDownloadTime() > 9223372036854774807L) {
                this.timeLabel.setVisible(false);
            } else {
                this.timeLabel.setText(I18n.tr("{0} left", CommonUtils.seconds2time(item.getRemainingDownloadTime())));
                this.timeLabel.setMinimumSize(this.timeLabel.getPreferredSize());
                this.timeLabel.setVisible(true);
            }
        } else {
            this.timeLabel.setVisible(false);
        }
    }
}

