/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.advanced.connection;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import com.google.inject.Inject;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.connection.ConnectionItem;
import org.limewire.core.api.connection.FWTStatusReason;
import org.limewire.core.api.connection.FirewallStatus;
import org.limewire.core.api.connection.FirewallStatusEvent;
import org.limewire.core.api.connection.FirewallTransferStatus;
import org.limewire.core.api.connection.FirewallTransferStatusEvent;
import org.limewire.core.api.connection.GnutellaConnectionManager;
import org.limewire.listener.EventBean;
import org.limewire.ui.swing.advanced.connection.PopupManager;
import org.limewire.ui.swing.components.Disposable;
import org.limewire.ui.swing.components.HTMLLabel;
import org.limewire.ui.swing.components.IconButton;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

public class ConnectionSummaryPanel
extends JPanel
implements Disposable {
    private static final String DISCONNECTED_PANEL_KEY = "DISCONNECTED_KEY";
    private static final String CONNECTED_PANEL_KEY = "CONNECTED_KEY";
    private final String IS_ULTRAPEER = I18n.tr("You are an Ultrapeer node");
    private final String IS_LEAF = I18n.tr("You are a Leaf node");
    private final String IS_NOT_FIREWALLED = I18n.tr("You are not behind a firewall");
    private final String IS_FIREWALLED_TRANSFERS = I18n.tr("You are behind a firewall and support firewall transfers");
    private final String IS_FIREWALLED_NO_TRANSFERS = I18n.tr("You are behind a firewall and do not support firewall transfers");
    private final String CONNECTED_TO = I18n.tr("Connected to:");
    private final String RESOLVE = I18n.tr("Show hostnames of connected peers");
    @Resource
    private Icon questionMarkIcon;
    private final GnutellaConnectionManager gnutellaConnectionManager;
    private final EventBean<FirewallStatusEvent> firewallStatusBean;
    private final EventBean<FirewallTransferStatusEvent> firewallTransferBean;
    private TransformedList<ConnectionItem, ConnectionItem> connectionList;
    private final JLabel nodeLabel = new JLabel();
    private final FirewallPanel firewallLabelPanel;
    private final JLabel summaryLabel = new JLabel();
    private final JTable summaryTable = new JTable();
    private final SummaryTableModel summaryTableModel = new SummaryTableModel();
    private final JCheckBox resolveCheckBox = new JCheckBox(this.RESOLVE);
    private final JLabel disconnectedMessageLabel = new JLabel();
    private final CardLayout switcher;
    private final JPanel disconnectedPanel;
    private final JPanel connectedPanel;

    @Inject
    public ConnectionSummaryPanel(GnutellaConnectionManager gnutellaConnectionManager, EventBean<FirewallStatusEvent> firewallStatusBean, EventBean<FirewallTransferStatusEvent> firewallTransferBean) {
        GuiUtils.assignResources(this);
        this.gnutellaConnectionManager = gnutellaConnectionManager;
        this.firewallStatusBean = firewallStatusBean;
        this.firewallTransferBean = firewallTransferBean;
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setPreferredSize(new Dimension(120, 120));
        this.setOpaque(false);
        this.firewallLabelPanel = new FirewallPanel(this.questionMarkIcon);
        this.firewallLabelPanel.setOpaque(false);
        this.summaryLabel.setText(this.CONNECTED_TO);
        this.summaryTable.setModel(this.summaryTableModel);
        this.summaryTable.setSelectionForeground(Color.BLACK);
        this.summaryTable.setPreferredSize(new Dimension(120, 120));
        this.summaryTable.setShowGrid(false);
        this.summaryTable.setFocusable(false);
        this.summaryTable.getColumnModel().getColumn(0).setPreferredWidth(24);
        this.summaryTable.getColumnModel().getColumn(1).setPreferredWidth(96);
        this.summaryTable.getColumnModel().getColumn(0).setCellRenderer(new SummaryCellRenderer());
        this.resolveCheckBox.setContentAreaFilled(false);
        boolean resolve = SwingUiSettings.RESOLVE_CONNECTION_HOSTNAMES.getValue();
        this.resolveCheckBox.setSelected(resolve);
        this.resolveCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean resolve = ConnectionSummaryPanel.this.resolveCheckBox.isSelected();
                SwingUiSettings.RESOLVE_CONNECTION_HOSTNAMES.setValue(resolve);
            }
        });
        this.connectedPanel = new JPanel(new MigLayout("insets 0 0 0 0,fill", "[left]", "[top][top][bottom][top,fill]"));
        this.connectedPanel.setOpaque(false);
        this.connectedPanel.add((Component)this.nodeLabel, "cell 0 0");
        this.connectedPanel.add((Component)this.firewallLabelPanel, "cell 0 1, growx 100");
        this.connectedPanel.add((Component)this.summaryLabel, "cell 0 2");
        this.connectedPanel.add((Component)this.summaryTable, "cell 0 3");
        this.connectedPanel.add((Component)this.resolveCheckBox, "cell 0 4");
        this.disconnectedPanel = new JPanel(new GridBagLayout());
        this.disconnectedPanel.setOpaque(false);
        this.disconnectedPanel.add(this.disconnectedMessageLabel);
        this.switcher = new CardLayout();
        this.setLayout(this.switcher);
        this.add((Component)this.connectedPanel, CONNECTED_PANEL_KEY);
        this.add((Component)this.disconnectedPanel, DISCONNECTED_PANEL_KEY);
    }

    @Override
    public void setBackground(Color bgColor) {
        super.setBackground(bgColor);
        if (this.summaryTable != null) {
            this.summaryTable.setBackground(bgColor);
            this.summaryTable.setSelectionBackground(bgColor);
        }
    }

    public void initData() {
        if (this.connectionList == null) {
            this.connectionList = GlazedListsFactory.swingThreadProxyEventList(this.gnutellaConnectionManager.getConnectionList());
            this.updateStatus();
        }
    }

    @Override
    public void dispose() {
        if (this.connectionList != null) {
            this.connectionList.dispose();
            this.connectionList = null;
        }
    }

    public void refresh() {
        this.updateStatus();
        this.summaryTableModel.update(this.connectionList);
    }

    private void updateStatus() {
        if (this.gnutellaConnectionManager.isConnected()) {
            this.switcher.show(this, CONNECTED_PANEL_KEY);
            boolean isUltrapeer = this.gnutellaConnectionManager.isUltrapeer();
            this.nodeLabel.setText(isUltrapeer ? this.IS_ULTRAPEER : this.IS_LEAF);
            FirewallStatus firewallStatus = (FirewallStatus)((Object)this.firewallStatusBean.getLastEvent().getData());
            if (firewallStatus == FirewallStatus.FIREWALLED) {
                FirewallTransferStatusEvent event = this.firewallTransferBean.getLastEvent();
                FirewallTransferStatus transferStatus = (FirewallTransferStatus)((Object)event.getData());
                FWTStatusReason transferReason = (FWTStatusReason)((Object)event.getType());
                if (transferStatus == FirewallTransferStatus.DOES_NOT_SUPPORT_FWT) {
                    this.firewallLabelPanel.setStatusText(this.IS_FIREWALLED_NO_TRANSFERS, this.getReasonText(transferReason));
                } else {
                    this.firewallLabelPanel.setStatusText(this.IS_FIREWALLED_TRANSFERS, null);
                }
            } else {
                this.firewallLabelPanel.setStatusText(this.IS_NOT_FIREWALLED, null);
            }
        } else {
            this.switcher.show(this, DISCONNECTED_PANEL_KEY);
            switch (this.gnutellaConnectionManager.getConnectionStrength()) {
                case NO_INTERNET: {
                    this.disconnectedMessageLabel.setText(I18n.tr("No internet connection!"));
                    break;
                }
                case DISCONNECTED: {
                    this.disconnectedMessageLabel.setText("<html>" + I18n.tr("Gnutella is disconnected however internet connection detected!") + "</html>");
                }
            }
        }
    }

    private String getReasonText(FWTStatusReason reason) {
        switch (reason) {
            case INVALID_EXTERNAL_ADDRESS: {
                return I18n.tr("LimeWire has not been able to determine the external IP address of your NAT or firewall");
            }
            case NO_SOLICITED_INCOMING_MESSAGES: {
                return I18n.tr("LimeWire has not received any incoming UDP messages");
            }
            case REUSING_STATUS_FROM_PREVIOUS_SESSION: {
                return I18n.tr("LimeWire was not able to support firewall transfers in a previous session");
            }
            case PORT_UNSTABLE: {
                return I18n.tr("LimeWire is behind a NAT or firewall that assigns a different external port to each connection");
            }
        }
        return "";
    }

    private static class SummaryTableModel
    extends AbstractTableModel {
        private final String CONNECTING = I18n.tr("Connecting");
        private final String LEAVES = I18n.tr("Leaves");
        private final String PEERS = I18n.tr("Peers");
        private final String STANDARD = I18n.tr("Standard");
        private final String ULTRAPEERS = I18n.tr("Ultrapeers");
        private int[] connectCounts = new int[5];

        private SummaryTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return 5;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                switch (rowIndex) {
                    case 0: {
                        return this.connectCounts[1];
                    }
                    case 1: {
                        return this.connectCounts[2];
                    }
                    case 2: {
                        return this.connectCounts[3];
                    }
                    case 3: {
                        return this.connectCounts[0];
                    }
                    case 4: {
                        return this.connectCounts[4];
                    }
                }
                return null;
            }
            if (columnIndex == 1) {
                switch (rowIndex) {
                    case 0: {
                        return this.ULTRAPEERS;
                    }
                    case 1: {
                        return this.PEERS;
                    }
                    case 2: {
                        return this.LEAVES;
                    }
                    case 3: {
                        return this.CONNECTING;
                    }
                    case 4: {
                        return this.STANDARD;
                    }
                }
                return null;
            }
            return null;
        }

        public void update(EventList<ConnectionItem> connectionList) {
            Arrays.fill(this.connectCounts, 0);
            for (int i = 0; i < connectionList.size(); ++i) {
                ConnectionItem item = (ConnectionItem)connectionList.get(i);
                if (!item.isConnected()) {
                    this.connectCounts[0] = this.connectCounts[0] + 1;
                    continue;
                }
                if (item.isUltrapeer()) {
                    this.connectCounts[1] = this.connectCounts[1] + 1;
                    continue;
                }
                if (item.isPeer()) {
                    this.connectCounts[2] = this.connectCounts[2] + 1;
                    continue;
                }
                if (item.isLeaf()) {
                    this.connectCounts[3] = this.connectCounts[3] + 1;
                    continue;
                }
                this.connectCounts[4] = this.connectCounts[4] + 1;
            }
            this.fireTableDataChanged();
        }
    }

    private static class SummaryCellRenderer
    extends DefaultTableCellRenderer {
        private SummaryCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (renderer instanceof JLabel) {
                ((JLabel)renderer).setHorizontalAlignment(4);
                ((JLabel)renderer).setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
            }
            return renderer;
        }
    }

    private class FirewallPanel
    extends JPanel
    implements PopupManager.PopupProvider {
        private Point popupLocation;
        private String reasonText;
        private HTMLLabel statusLabel = new HTMLLabel();
        private IconButton reasonButton;
        private PopupManager reasonPopupManager;

        public FirewallPanel(Icon argIcon) {
            this.statusLabel.setOpaque(false);
            this.reasonButton = new IconButton(argIcon);
            this.reasonButton.setBorder(null);
            this.reasonButton.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    FirewallPanel.this.popupLocation = e.getPoint();
                    ((FirewallPanel)FirewallPanel.this).popupLocation.x = FirewallPanel.this.getWidth();
                    FirewallPanel.this.showPopup();
                }
            });
            this.reasonButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    FirewallPanel.this.reasonPopupManager.hidePopup();
                }
            });
            this.reasonButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    FirewallPanel.this.showPopup();
                }
            });
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.statusLabel);
            this.add(this.reasonButton);
            this.reasonButton.setVisible(false);
            this.reasonPopupManager = new PopupManager(this);
        }

        private void showPopup() {
            this.reasonPopupManager.showTimedPopup(this, this.popupLocation.x + 18, this.popupLocation.y + 10);
        }

        @Override
        public Component getPopupContent() {
            if (this.reasonText != null && this.reasonText.length() > 0) {
                JToolTip toolTip = this.createToolTip();
                toolTip.setBackground(Color.WHITE);
                toolTip.setTipText(this.reasonText);
                toolTip.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                return toolTip;
            }
            return null;
        }

        public void setStatusText(String statusText, String reasonText) {
            this.statusLabel.setText(statusText);
            this.reasonText = reasonText;
            if (statusText != null && statusText.length() > 0 && reasonText != null && reasonText.length() > 0) {
                this.reasonButton.setVisible(true);
            } else {
                this.reasonButton.setVisible(false);
            }
            this.repaint();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.statusLabel.getMinimumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.statusLabel.getPreferredSize();
        }
    }
}

