/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Locale;
import org.limewire.ui.swing.AWTSplashWindow;

public class Main {
    private static long startTime;

    public static void main(String[] args) {
        startTime = System.currentTimeMillis();
        try {
            if (Main.isMacOSX()) {
                Class<?> clazz = Class.forName("org.limewire.ui.swing.GURLHandler");
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                Object gurl = getInstance.invoke(null, new Object[0]);
                Method register = gurl.getClass().getMethod("register", new Class[0]);
                register.invoke(gurl, new Object[0]);
            }
            SplashScreen splashScreen = SplashScreen.getSplashScreen();
            Frame splash = null;
            Image splashImage = null;
            if (args == null || args.length == 0) {
                Rectangle bounds;
                if (splashScreen != null && splashScreen.isVisible()) {
                    bounds = splashScreen.getBounds();
                    splashImage = Toolkit.getDefaultToolkit().createImage(splashScreen.getImageURL());
                } else {
                    bounds = null;
                    splashImage = Main.getSplashImage();
                }
                if (splashImage != null) {
                    splash = AWTSplashWindow.splash(splashImage, bounds);
                } else if (splashScreen != null && splashScreen.isVisible()) {
                    splashScreen.close();
                }
            } else if (splashScreen != null && splashScreen.isVisible()) {
                splashScreen.close();
            }
            if (splashImage == null) {
                splashImage = Main.getSplashImage();
            }
            Class<?> loadClass = Class.forName("org.limewire.ui.swing.GuiLoader");
            Object loadInstance = loadClass.newInstance();
            Method loadMethod = loadClass.getMethod("load", String[].class, Frame.class, Image.class);
            loadMethod.invoke(loadInstance, args, splash, splashImage);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static Image getSplashImage() {
        URL imageURL = ClassLoader.getSystemResource("org/limewire/ui/swing/mainframe/resources/splash.png");
        if (imageURL != null) {
            return Toolkit.getDefaultToolkit().createImage(imageURL);
        }
        return null;
    }

    private static boolean isMacOSX() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).startsWith("mac os x");
    }

    public static long getStartTime() {
        return startTime;
    }
}

