/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.swarm.SwarmBlockSelector;
import org.limewire.swarm.SwarmBlockVerifier;
import org.limewire.swarm.SwarmFile;
import org.limewire.swarm.SwarmFileSystem;
import org.limewire.swarm.SwarmWriteJob;
import org.limewire.swarm.SwarmWriteJobControl;
import org.limewire.swarm.VerificationException;
import org.limewire.swarm.file.SwarmWriteJobImpl;
import org.limewire.swarm.impl.AbstractSwarmCoordinator;
import org.limewire.swarm.impl.LoggingSwarmCoordinatorListener;
import org.limewire.util.Objects;

public class FileCoordinatorImpl
extends AbstractSwarmCoordinator {
    private static final Log LOG = LogFactory.getLog(FileCoordinatorImpl.class);
    private static final long DEFAULT_BLOCK_SIZE = 16384L;
    private final long blockSize;
    private final IntervalSet leasedBlocks;
    private final IntervalSet writtenBlocks;
    private final IntervalSet verifiedBlocks;
    private final IntervalSet pendingBlocks;
    private final SwarmBlockSelector blockSelector;
    private final SwarmFileSystem fileSystem;
    private final ExecutorService writeService;
    private final SwarmBlockVerifier swarmBlockVerifier;
    private long amountLost;
    private final Object LOCK = new Object();

    public FileCoordinatorImpl(SwarmFileSystem fileSystem, SwarmBlockVerifier swarmFileVerifier, ExecutorService writeService, SwarmBlockSelector selectionStrategy) {
        this(fileSystem, swarmFileVerifier, writeService, selectionStrategy, 16384L);
    }

    public FileCoordinatorImpl(SwarmFileSystem fileSystem, SwarmBlockVerifier swarmFileVerifier, ExecutorService writeService, SwarmBlockSelector selectionStrategy, long blockSize) {
        this.blockSelector = Objects.nonNull(selectionStrategy, "selectionStrategy");
        this.fileSystem = Objects.nonNull(fileSystem, "fileSystem");
        this.writeService = Objects.nonNull(writeService, "writeService");
        this.swarmBlockVerifier = Objects.nonNull(swarmFileVerifier, "swarmFileVerifier");
        assert (blockSize > 0L);
        this.leasedBlocks = new IntervalSet();
        this.writtenBlocks = new IntervalSet();
        this.pendingBlocks = new IntervalSet();
        this.verifiedBlocks = new IntervalSet();
        this.blockSize = blockSize;
        if (LOG.isDebugEnabled() || LOG.isTraceEnabled()) {
            this.addListener(new LoggingSwarmCoordinatorListener());
        }
    }

    @Override
    public Range leasePortion(IntervalSet availableRanges) {
        return this.lease(availableRanges, this.blockSize, this.blockSelector);
    }

    @Override
    public Range leasePortion(IntervalSet availableRanges, SwarmBlockSelector swarmSelector) {
        return this.lease(availableRanges, this.blockSize, this.blockSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Range lease(IntervalSet availableRanges, long blockSize, SwarmBlockSelector swarmSelector) {
        Range chosen;
        IntervalSet neededBytes;
        if (availableRanges != null) {
            availableRanges = availableRanges.clone();
        }
        if ((availableRanges = this.getAvailableRangesForLease(availableRanges, neededBytes = new IntervalSet())).isEmpty()) {
            return null;
        }
        try {
            chosen = swarmSelector.selectAssignment(availableRanges, neededBytes, blockSize);
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.addLease(chosen);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Leasing: " + chosen + ", from available: " + availableRanges + ", needed: " + neededBytes);
        }
        return chosen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlease(Range range) {
        Object object = this.LOCK;
        synchronized (object) {
            this.deleteLease(range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pending(Range range) {
        Object object = this.LOCK;
        synchronized (object) {
            assert (this.hasLease(range));
            this.deleteLease(range);
            this.addPending(range);
        }
    }

    private void addLease(Range chosen) {
        this.leasedBlocks.add(chosen);
        this.listeners().blockLeased(chosen);
    }

    private boolean hasLease(Range range) {
        return this.leasedBlocks.contains(range);
    }

    private void addPending(Range range) {
        this.pendingBlocks.add(range);
        this.listeners().blockPending(range);
    }

    private void deleteLease(Range range) {
        this.leasedBlocks.delete(range);
        this.listeners().blockUnleased(range);
    }

    private void deletePending(Range range) {
        this.pendingBlocks.delete(range);
        this.listeners().blockUnpending(range);
    }

    private boolean hasPending(Range range) {
        return this.pendingBlocks.contains(range);
    }

    private void addWritten(Range writtenRange) {
        this.writtenBlocks.add(writtenRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpending(Range range) {
        Object object = this.LOCK;
        synchronized (object) {
            assert (this.hasPending(range));
            this.deletePending(range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wrote(Range writtenRange) {
        boolean complete;
        List<Range> verifiableRanges;
        Object object = this.LOCK;
        synchronized (object) {
            assert (this.hasPending(writtenRange));
            this.deletePending(writtenRange);
            this.addWritten(writtenRange);
            verifiableRanges = this.swarmBlockVerifier.scanForVerifiableRanges(this.writtenBlocks, this.fileSystem.getCompleteSize());
            complete = verifiableRanges.isEmpty() && this.isComplete();
        }
        this.listeners().blockWritten(writtenRange);
        if (complete) {
            this.listeners().downloadCompleted(this.fileSystem);
        }
        this.verifyRanges(verifiableRanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this.LOCK;
        synchronized (object) {
            IntervalSet blocksToCheck = null;
            if (this.verifiedBlocks.isEmpty()) {
                blocksToCheck = this.writtenBlocks;
            } else if (this.writtenBlocks.isEmpty()) {
                blocksToCheck = this.verifiedBlocks;
            }
            return blocksToCheck != null && blocksToCheck.getNumberOfIntervals() == 1 && blocksToCheck.getSize() == this.fileSystem.getCompleteSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRanges(List<Range> verifiableRanges) {
        if (LOG.isDebugEnabled() && !verifiableRanges.isEmpty()) {
            LOG.debug("Verifying ranges: " + verifiableRanges);
        }
        boolean complete = false;
        for (Range rangeToVerify : verifiableRanges) {
            boolean verified;
            try {
                verified = this.swarmBlockVerifier.verify(rangeToVerify, this.fileSystem);
            }
            catch (VerificationException e) {
                LOG.warn(e.getMessage(), e);
                verified = false;
            }
            Object object = this.LOCK;
            synchronized (object) {
                assert (this.writtenBlocks.contains(rangeToVerify));
                this.writtenBlocks.delete(rangeToVerify);
                if (verified) {
                    this.verifiedBlocks.add(rangeToVerify);
                    complete = this.isComplete();
                    this.listeners().blockVerified(rangeToVerify);
                    this.handleVerifiedPieces();
                } else {
                    this.listeners().blockVerificationFailed(rangeToVerify);
                    this.amountLost += rangeToVerify.getHigh() - rangeToVerify.getLow() + 1L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Lost range: " + rangeToVerify + ", total lost: " + this.amountLost);
                    }
                }
            }
        }
        if (complete) {
            this.listeners().downloadCompleted(this.fileSystem);
        }
    }

    private void handleVerifiedPieces() {
        List<SwarmFile> swarmFiles = this.fileSystem.getSwarmFiles();
        for (SwarmFile swarmFile : swarmFiles) {
            Range fileRange = Range.createRange(swarmFile.getStartBytePosition(), swarmFile.getEndBytePosition());
            if (!this.verifiedBlocks.contains(fileRange)) continue;
            try {
                this.fileSystem.closeSwarmFile(swarmFile);
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Error closing swarmFile: " + swarmFile, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountVerified() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.verifiedBlocks.getSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAmountLost() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.amountLost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reverify() {
        List<Object> verifiableRanges;
        Object object = this.LOCK;
        synchronized (object) {
            this.writtenBlocks.add(this.verifiedBlocks);
            this.verifiedBlocks.clear();
            verifiableRanges = this.pendingBlocks.getNumberOfIntervals() == 0 && !this.writtenBlocks.isEmpty() ? this.swarmBlockVerifier.scanForVerifiableRanges(this.writtenBlocks, this.fileSystem.getCompleteSize()) : Collections.emptyList();
        }
        if (!verifiableRanges.isEmpty()) {
            this.writeService.execute(new Runnable(){

                @Override
                public void run() {
                    FileCoordinatorImpl.this.verifyRanges(verifiableRanges);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() {
        List<Object> verifiableRanges;
        Object object = this.LOCK;
        synchronized (object) {
            verifiableRanges = this.pendingBlocks.getNumberOfIntervals() == 0 && !this.writtenBlocks.isEmpty() ? this.swarmBlockVerifier.scanForVerifiableRanges(this.writtenBlocks, this.fileSystem.getCompleteSize()) : Collections.emptyList();
        }
        if (!verifiableRanges.isEmpty()) {
            this.writeService.execute(new Runnable(){

                @Override
                public void run() {
                    FileCoordinatorImpl.this.verifyRanges(verifiableRanges);
                }
            });
        }
    }

    public boolean isRangeAvailableForLease() {
        return this.isRangeAvailableForLease(null);
    }

    public boolean isRangeAvailableForLease(IntervalSet availableRanges) {
        return !this.getAvailableRangesForLease(availableRanges, null).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IntervalSet getAvailableRangesForLease(IntervalSet availableRanges, IntervalSet neededBytes) {
        if (availableRanges == null) {
            availableRanges = IntervalSet.createSingletonSet(0L, this.fileSystem.getCompleteSize() - 1L);
        }
        if (neededBytes == null) {
            neededBytes = IntervalSet.createSingletonSet(0L, this.fileSystem.getCompleteSize() - 1L);
        } else {
            neededBytes.add(Range.createRange(0L, this.fileSystem.getCompleteSize() - 1L));
        }
        Object object = this.LOCK;
        synchronized (object) {
            neededBytes.delete(this.leasedBlocks);
            neededBytes.delete(this.writtenBlocks);
            neededBytes.delete(this.pendingBlocks);
            neededBytes.delete(this.verifiedBlocks);
        }
        availableRanges.delete(neededBytes.invert(this.fileSystem.getCompleteSize()));
        return availableRanges;
    }

    @Override
    public SwarmWriteJob createWriteJob(Range range, SwarmWriteJobControl callback) {
        return new SwarmWriteJobImpl(range, this, this.writeService, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(Range range, ByteBuffer swarmContent) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            long position = range.getLow();
            long startRange = range.getLow();
            long endRange = startRange - (long)swarmContent.position() + (long)swarmContent.limit() - 1L;
            Range pendingRange = Range.createRange(startRange, endRange);
            this.pending(pendingRange);
            long bytesWritten = this.fileSystem.write(swarmContent, position);
            this.wrote(pendingRange);
            return bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.fileSystem.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Range renewLease(Range oldLease, Range newLease) {
        Object object = this.LOCK;
        synchronized (object) {
            assert (this.hasLease(oldLease));
            assert (newLease.isSubrange(oldLease));
            this.deleteLease(oldLease);
            this.addLease(newLease);
            return newLease;
        }
    }

    @Override
    public SwarmFile getSwarmFile(Range range) {
        return this.fileSystem.getSwarmFile(range.getLow());
    }
}

