/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.security.MACCalculator;
import org.limewire.security.MACCalculatorFactory;
import org.limewire.security.MACCalculatorRepository;
import org.limewire.security.SettingsProvider;

class MACCalculatorRotator
implements MACCalculatorRepository {
    private final SettingsProvider provider;
    private final MACCalculatorFactory factory;
    private final ScheduledExecutorService scheduler;
    private MACCalculator current;
    private MACCalculator old;
    private final Runnable rotator;
    private final Runnable expirer;

    MACCalculatorRotator(ScheduledExecutorService scheduler, MACCalculatorFactory factory, SettingsProvider provider) {
        this.provider = provider;
        this.factory = factory;
        this.scheduler = scheduler;
        if (provider.getGracePeriod() >= provider.getChangePeriod()) {
            throw new IllegalArgumentException("settings not supported");
        }
        this.rotator = new Runnable(){

            @Override
            public void run() {
                MACCalculatorRotator.this.rotate();
            }
        };
        this.expirer = new Runnable(){

            @Override
            public void run() {
                MACCalculatorRotator.this.expireOld();
            }
        };
        this.rotate();
    }

    @Override
    public synchronized MACCalculator[] getValidMACCalculators() {
        if (this.old == null) {
            return new MACCalculator[]{this.current};
        }
        return new MACCalculator[]{this.current, this.old};
    }

    @Override
    public synchronized MACCalculator getCurrentMACCalculator() {
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotate() {
        MACCalculator newKQ = this.factory.createMACCalculator();
        MACCalculatorRotator mACCalculatorRotator = this;
        synchronized (mACCalculatorRotator) {
            this.old = this.current;
            this.current = newKQ;
        }
        this.scheduler.schedule(this.rotator, this.provider.getChangePeriod(), TimeUnit.MILLISECONDS);
        this.scheduler.schedule(this.expirer, this.provider.getGracePeriod(), TimeUnit.MILLISECONDS);
    }

    private synchronized void expireOld() {
        this.old = null;
    }
}

