/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.net;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.inspection.InspectionRequirement;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.AbstractSocketController;
import org.limewire.net.ProxyManager;
import org.limewire.net.SocketBindingSettings;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NBSocketFactory;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.Shutdownable;

@Singleton
class LimitedSocketController
extends AbstractSocketController {
    private static final Log LOG = LogFactory.getLog(LimitedSocketController.class);
    private static final int DEFAULT_MAX_CONNECTING_SOCKETS = 4;
    private final int MAX_CONNECTING_SOCKETS;
    private int _socketsConnecting = 0;
    private final List<Requestor> WAITING_REQUESTS = new LinkedList<Requestor>();
    @InspectionPoint(value="limited-socket-stats", requires={InspectionRequirement.OS_WINDOWS})
    private final LimitedSocketInspectable inspectable = new LimitedSocketInspectable();
    @InspectionPoint(value="limited-socket-req", requires={InspectionRequirement.OS_WINDOWS})
    private final InspectionHistogram<Integer> requestsInQueue = new InspectionHistogram();

    @Inject
    LimitedSocketController(ProxyManager proxyManager, SocketBindingSettings socketBindingSettings) {
        this(proxyManager, socketBindingSettings, 4);
    }

    LimitedSocketController(ProxyManager proxyManager, SocketBindingSettings socketBindingSettings, int maxConnectingSockets) {
        super(proxyManager, socketBindingSettings);
        this.MAX_CONNECTING_SOCKETS = maxConnectingSockets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Socket connectPlain(InetSocketAddress localAddr, NBSocketFactory factory, InetSocketAddress addr, int timeout, ConnectObserver observer) throws IOException {
        NBSocket socket = factory.createSocket();
        this.bindSocket(socket, localAddr);
        this.requestsInQueue.count(this.getNumWaitingSockets());
        if (observer == null) {
            if (LOG.isDebugEnabled()) {
                int waiting = this.getNumWaitingSockets();
                LOG.debug(waiting + " waiting for sockets (blocking)");
            }
            this.waitForSocket();
            if (LOG.isDebugEnabled()) {
                String ipp = addr.getAddress().getHostAddress() + ":" + addr.getPort();
                LOG.debug("Connecting to " + ipp + " (blocking)");
            }
            try {
                socket.connect(addr, timeout);
            }
            finally {
                this.releaseSocket();
            }
        } else if (this.addWaitingSocket(socket, addr, timeout, observer)) {
            if (LOG.isDebugEnabled()) {
                String ipp = addr.getAddress().getHostAddress() + ":" + addr.getPort();
                LOG.debug("Connecting to " + ipp + " (non-blocking)");
            }
            socket.connect(addr, timeout, new DelegateConnector(observer));
        } else if (LOG.isDebugEnabled()) {
            int waiting = this.getNumWaitingSockets();
            LOG.debug(waiting + " waiting for sockets (non-blocking)");
        }
        return socket;
    }

    @Override
    public synchronized boolean removeConnectObserver(ConnectObserver observer) {
        Iterator<Requestor> i = this.WAITING_REQUESTS.iterator();
        while (i.hasNext()) {
            Requestor next = i.next();
            if (next.observer == observer) {
                i.remove();
                return true;
            }
            if (!(next.observer instanceof ProxyManager.ProxyConnector) || ((ProxyManager.ProxyConnector)next.observer).getDelegateObserver() != observer) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public int getNumAllowedSockets() {
        return this.MAX_CONNECTING_SOCKETS;
    }

    @Override
    public synchronized int getNumWaitingSockets() {
        return this.WAITING_REQUESTS.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWaitingRequests() {
        Requestor next;
        ArrayList<Requestor> toBeProcessed = new ArrayList<Requestor>(Math.min(this.WAITING_REQUESTS.size(), Math.max(0, this.MAX_CONNECTING_SOCKETS - this._socketsConnecting)));
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            while (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS && !this.WAITING_REQUESTS.isEmpty()) {
                next = this.WAITING_REQUESTS.remove(0);
                if (!next.socket.isClosed()) {
                    toBeProcessed.add(next);
                    ++this._socketsConnecting;
                    continue;
                }
                this.inspectable.incrementCancelledRequestCount();
            }
        }
        for (int i = 0; i < toBeProcessed.size(); ++i) {
            next = (Requestor)toBeProcessed.get(i);
            this.inspectable.addReadyRequest(next);
            if (LOG.isDebugEnabled()) {
                String ipp = next.addr.getAddress().getHostAddress() + ":" + next.addr.getPort();
                LOG.debug("Connecting to " + ipp + " (waiting)");
            }
            next.socket.setShutdownObserver(null);
            next.socket.connect(next.addr, next.timeout, new DelegateConnector(next.observer));
        }
    }

    private synchronized boolean addWaitingSocket(NBSocket socket, InetSocketAddress addr, int timeout, ConnectObserver observer) {
        if (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            this.WAITING_REQUESTS.add(new Requestor(socket, addr, timeout, observer));
            this.inspectable.setMaxConnReqInQueueIfNecessary(this.getNumWaitingSockets());
            socket.setShutdownObserver(new RemovalObserver(observer));
            return false;
        }
        ++this._socketsConnecting;
        return true;
    }

    private synchronized void waitForSocket() throws IOException {
        while (this._socketsConnecting >= this.MAX_CONNECTING_SOCKETS) {
            try {
                this.wait();
            }
            catch (InterruptedException ix) {
                throw new IOException(ix.getMessage());
            }
        }
        ++this._socketsConnecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSocket() {
        LimitedSocketController limitedSocketController = this;
        synchronized (limitedSocketController) {
            --this._socketsConnecting;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Releasing socket, " + this._socketsConnecting + " connecting, " + this.getNumWaitingSockets() + " waiting");
            }
        }
        this.runWaitingRequests();
        limitedSocketController = this;
        synchronized (limitedSocketController) {
            if (this._socketsConnecting < this.MAX_CONNECTING_SOCKETS) {
                this.notifyAll();
            }
        }
    }

    private static class LimitedSocketInspectable
    implements Inspectable {
        private int maxConnectRequestsInQueue = 0;
        private int numberOfCancelledRequests = 0;
        private int totalQueueRequestsProcessed = 0;
        private long maxTimeSpentInQueue = 0L;
        private long totalWaitTimeInQueue = 0L;

        private LimitedSocketInspectable() {
        }

        @Override
        public synchronized Object inspect() {
            HashMap<String, Number> ret = new HashMap<String, Number>();
            ret.put("req_processed", this.totalQueueRequestsProcessed);
            ret.put("max_requests_in_queue", this.maxConnectRequestsInQueue);
            ret.put("max_time_in_queue", this.maxTimeSpentInQueue);
            ret.put("req_cancelled", this.numberOfCancelledRequests);
            ret.put("total_time_in_queue", this.totalWaitTimeInQueue);
            return ret;
        }

        synchronized void setMaxConnReqInQueueIfNecessary(int newMax) {
            if (newMax > this.maxConnectRequestsInQueue) {
                this.maxConnectRequestsInQueue = newMax;
            }
        }

        synchronized void incrementCancelledRequestCount() {
            ++this.numberOfCancelledRequests;
        }

        synchronized void addReadyRequest(Requestor request) {
            ++this.totalQueueRequestsProcessed;
            long timeSpent = System.currentTimeMillis() - request.creationTime;
            this.totalWaitTimeInQueue += timeSpent;
            if (timeSpent > this.maxTimeSpentInQueue) {
                this.maxTimeSpentInQueue = timeSpent;
            }
        }
    }

    private static class Requestor {
        private final InetSocketAddress addr;
        private final int timeout;
        private final NBSocket socket;
        private final ConnectObserver observer;
        private final long creationTime;

        Requestor(NBSocket socket, InetSocketAddress addr, int timeout, ConnectObserver observer) {
            this.socket = socket;
            this.addr = addr;
            this.timeout = timeout;
            this.observer = observer;
            this.creationTime = System.currentTimeMillis();
        }
    }

    private class DelegateConnector
    implements ConnectObserver {
        private final ConnectObserver delegate;

        DelegateConnector(ConnectObserver observer) {
            this.delegate = observer;
        }

        @Override
        public void handleConnect(Socket s) throws IOException {
            LimitedSocketController.this.releaseSocket();
            this.delegate.handleConnect(s);
        }

        @Override
        public void shutdown() {
            LimitedSocketController.this.releaseSocket();
            this.delegate.shutdown();
        }

        @Override
        public void handleIOException(IOException x) {
        }
    }

    private class RemovalObserver
    implements Shutdownable {
        private final ConnectObserver delegate;

        RemovalObserver(ConnectObserver observer) {
            this.delegate = observer;
        }

        @Override
        public void shutdown() {
            if (LimitedSocketController.this.removeConnectObserver(this.delegate)) {
                LimitedSocketController.this.inspectable.incrementCancelledRequestCount();
                this.delegate.shutdown();
            }
        }
    }
}

