/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.routing.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.PatriciaTrie;
import org.limewire.collection.Trie;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.exceptions.DHTTimeoutException;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.routing.impl.BucketNode;
import org.limewire.mojito.routing.impl.LocalContact;
import org.limewire.mojito.settings.RouteTableSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.ExceptionUtils;
import org.limewire.service.ErrorService;

public class RouteTableImpl
implements RouteTable {
    private static final long serialVersionUID = -7351267868357880369L;
    private static final Log LOG = LogFactory.getLog(RouteTableImpl.class);
    private final PatriciaTrie<KUID, Bucket> bucketTrie;
    private int consecutiveFailures = 0;
    private transient RouteTable.ContactPinger pinger;
    private Contact localNode;
    private volatile transient List<RouteTable.RouteTableListener> listeners = new CopyOnWriteArrayList<RouteTable.RouteTableListener>();
    private volatile transient DHTExecutorService notifier;

    public RouteTableImpl() {
        this(KUID.createRandomID());
    }

    public RouteTableImpl(byte[] nodeId) {
        this(KUID.createWithBytes(nodeId));
    }

    public RouteTableImpl(String nodeId) {
        this(KUID.createWithHexString(nodeId));
    }

    public RouteTableImpl(KUID nodeId) {
        this.localNode = ContactFactory.createLocalContact(Vendor.UNKNOWN, Version.ZERO, nodeId, 0, false);
        this.bucketTrie = new PatriciaTrie(KUID.KEY_ANALYZER);
        this.init();
    }

    private void init() {
        KUID bucketId = KUID.MINIMUM;
        BucketNode bucket = new BucketNode(this, bucketId, 0);
        this.bucketTrie.put(bucketId, bucket);
        this.addContactToBucket(bucket, this.localNode);
        this.consecutiveFailures = 0;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new CopyOnWriteArrayList<RouteTable.RouteTableListener>();
        for (Bucket bucket : this.bucketTrie.values()) {
            ((BucketNode)bucket).postInit();
        }
    }

    @Override
    public void setContactPinger(RouteTable.ContactPinger pinger) {
        this.pinger = pinger;
    }

    @Override
    public void setNotifier(DHTExecutorService executor) {
        this.notifier = executor;
    }

    @Override
    public void addRouteTableListener(RouteTable.RouteTableListener l) {
        if (l == null) {
            throw new NullPointerException("RouteTableListener is null");
        }
        this.listeners.add(l);
    }

    @Override
    public void removeRouteTableListener(RouteTable.RouteTableListener l) {
        if (l == null) {
            throw new NullPointerException("RouteTableListener is null");
        }
        this.listeners.remove(l);
    }

    @Override
    public synchronized void add(Contact node) {
        if (this.localNode.equals(node)) {
            String msg = "Cannot add the local Node: " + node;
            if (LOG.isErrorEnabled()) {
                LOG.error(msg);
            }
            ErrorService.error(new IllegalArgumentException(msg));
            return;
        }
        if (node.isFirewalled()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(node + " is firewalled");
            }
            return;
        }
        if (!ContactUtils.isSameAddressSpace(this.localNode, node)) {
            if (LOG.isErrorEnabled()) {
                LOG.error(node + " is from a different IP address space than " + this.localNode);
            }
            return;
        }
        this.consecutiveFailures = 0;
        KUID nodeId = node.getNodeID();
        Bucket bucket = this.bucketTrie.select(nodeId);
        Contact existing = bucket.get(nodeId);
        if (existing != null) {
            this.updateContactInBucket(bucket, existing, node);
        } else if (!bucket.isActiveFull()) {
            if (this.isOkayToAdd(bucket, node)) {
                this.addContactToBucket(bucket, node);
            } else if (!this.canSplit(bucket)) {
                this.addContactToBucketCache(bucket, node);
            }
        } else if (this.split(bucket)) {
            this.add(node);
        } else {
            this.replaceContactInBucket(bucket, node);
        }
    }

    protected synchronized void updateContactInBucket(Bucket bucket, Contact existing, Contact node) {
        assert (existing.getNodeID().equals(node.getNodeID()));
        if (this.isLocalNode(existing)) {
            if (!this.isLocalNode(node)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(node + " collides with " + existing);
                }
            } else {
                if (!(node instanceof LocalContact)) {
                    String msg = "Attempting to replace the local Node " + existing + " with " + node;
                    if (LOG.isErrorEnabled()) {
                        LOG.error(msg);
                    }
                    throw new IllegalArgumentException(msg);
                }
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Updating " + existing + " with " + node);
                }
                bucket.updateContact(node);
                this.localNode = node;
                this.fireContactUpdate(bucket, existing, node);
            }
            return;
        }
        if (existing.isAlive() && !node.isAlive()) {
            return;
        }
        if (!existing.isAlive() || this.isLocalNode(node) || existing.equals(node) || ContactUtils.areLocalContacts(existing, node)) {
            node.updateWithExistingContact(existing);
            Contact replaced = bucket.updateContact(node);
            assert (replaced == existing);
            long delay = System.currentTimeMillis() - bucket.getTimeStamp();
            if (bucket.containsCachedContact(node.getNodeID()) && delay > RouteTableSettings.BUCKET_PING_LIMIT.getValue()) {
                this.pingLeastRecentlySeenNode(bucket);
            }
            this.touchBucket(bucket);
            this.fireContactUpdate(bucket, existing, node);
        } else if (node.isAlive() && !existing.hasBeenRecentlyAlive()) {
            this.doSpoofCheck(bucket, existing, node);
        }
    }

    protected synchronized void doSpoofCheck(Bucket bucket, final Contact existing, final Contact node) {
        DHTFutureAdapter<PingResult> listener = new DHTFutureAdapter<PingResult>(){

            @Override
            public void handleFutureSuccess(PingResult result) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn(node + " is trying to spoof " + result);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleExecutionException(ExecutionException e) {
                DHTTimeoutException timeout = ExceptionUtils.getCause(e, DHTTimeoutException.class);
                if (timeout == null) {
                    return;
                }
                KUID nodeId = timeout.getNodeID();
                SocketAddress address = timeout.getSocketAddress();
                if (LOG.isInfoEnabled()) {
                    LOG.info(ContactUtils.toString(nodeId, address) + " did not respond! Replacing it with " + node);
                }
                RouteTableImpl routeTableImpl = RouteTableImpl.this;
                synchronized (routeTableImpl) {
                    Bucket bucket = (Bucket)RouteTableImpl.this.bucketTrie.select(nodeId);
                    Contact current = bucket.get(nodeId);
                    if (current != null && current.equals(existing)) {
                        node.updateWithExistingContact(current);
                        Contact replaced = bucket.updateContact(node);
                        assert (replaced == current);
                        RouteTableImpl.this.fireContactUpdate(bucket, current, node);
                        if (bucket.containsCachedContact(nodeId)) {
                            RouteTableImpl.this.pingLeastRecentlySeenNode(bucket);
                        }
                    } else {
                        RouteTableImpl.this.add(node);
                    }
                }
            }
        };
        this.fireContactCheck(bucket, existing, node);
        this.ping(existing, (DHTFutureListener<PingResult>)listener);
        this.touchBucket(bucket);
    }

    protected synchronized void addContactToBucket(Bucket bucket, Contact node) {
        bucket.addActiveContact(node);
        this.fireActiveContactAdded(bucket, node);
    }

    protected synchronized void addContactToBucketCache(Bucket bucket, Contact node) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Adding " + node + " to " + bucket + " replacement cache");
        }
        Contact existing = bucket.addCachedContact(node);
        this.fireCachedContactAdded(bucket, existing, node);
    }

    private boolean canSplit(Bucket bucket) {
        boolean containsLocalNode = bucket.contains(this.getLocalNode().getNodeID());
        return containsLocalNode || bucket.isInSmallestSubtree() || !bucket.isTooDeep();
    }

    protected synchronized boolean split(Bucket bucket) {
        if (this.canSplit(bucket)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Splitting bucket: " + bucket);
            }
            List<Bucket> buckets = bucket.split();
            assert (buckets.size() == 2);
            Bucket left = buckets.get(0);
            Bucket right = buckets.get(1);
            Bucket oldLeft = this.bucketTrie.put(left.getBucketID(), left);
            assert (oldLeft == bucket);
            Bucket oldRight = this.bucketTrie.put(right.getBucketID(), right);
            assert (oldRight == null);
            this.fireSplitBucket(bucket, left, right);
            return true;
        }
        return false;
    }

    protected synchronized void replaceContactInBucket(Bucket bucket, Contact node) {
        Contact leastRecentlySeen;
        if (node.isAlive() && this.isOkayToAdd(bucket, node) && !this.isLocalNode(leastRecentlySeen = bucket.getLeastRecentlySeenActiveContact()) && (leastRecentlySeen.isUnknown() || leastRecentlySeen.isDead() || node.getTimeStamp() == 0x7FFFFFFFFFFFFFFEL)) {
            if (LOG.isTraceEnabled()) {
                LOG.info("Replacing " + leastRecentlySeen + " with " + node);
            }
            boolean removed = bucket.removeActiveContact(leastRecentlySeen.getNodeID());
            assert (removed);
            bucket.addActiveContact(node);
            this.touchBucket(bucket);
            this.fireReplaceContact(bucket, leastRecentlySeen, node);
            return;
        }
        this.addContactToBucketCache(bucket, node);
        this.pingLeastRecentlySeenNode(bucket);
    }

    @Override
    public synchronized void handleFailure(KUID nodeId, SocketAddress address) {
        if (nodeId == null) {
            return;
        }
        if (nodeId.equals(this.getLocalNode().getNodeID())) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Cannot handle local Node's errors: " + ContactUtils.toString(nodeId, address));
            }
            return;
        }
        Bucket bucket = this.bucketTrie.select(nodeId);
        Contact node = bucket.get(nodeId);
        if (node == null) {
            return;
        }
        if (!node.getContactAddress().equals(address)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn(node + " address and " + address + " do not match");
            }
            return;
        }
        if (this.consecutiveFailures >= RouteTableSettings.MAX_CONSECUTIVE_FAILURES.getValue()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Ignoring node failure as it appears that we are disconnected");
            }
            return;
        }
        ++this.consecutiveFailures;
        node.handleFailure();
        if (node.isDead()) {
            if (bucket.containsActiveContact(nodeId)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removing " + node + " and replacing it with the MRS Node from Cache");
                }
                if (bucket.getCacheSize() > 0) {
                    Contact mrs = null;
                    while ((mrs = bucket.getMostRecentlySeenCachedContact()) != null) {
                        boolean removed = bucket.removeCachedContact(mrs.getNodeID());
                        assert (removed);
                        if (!this.isOkayToAdd(bucket, mrs)) continue;
                        removed = bucket.removeActiveContact(nodeId);
                        assert (removed);
                        assert (!bucket.isActiveFull());
                        bucket.addActiveContact(mrs);
                        this.fireReplaceContact(bucket, node, mrs);
                        break;
                    }
                } else if (node.getFailures() >= RouteTableSettings.MAX_ACCEPT_NODE_FAILURES.getValue()) {
                    bucket.removeActiveContact(nodeId);
                    assert (!bucket.isActiveFull());
                    this.fireRemoveContact(bucket, node);
                }
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Removing " + node + " from Cache");
                }
                boolean removed = bucket.removeCachedContact(nodeId);
                assert (removed);
            }
        }
    }

    protected synchronized boolean isOkayToAdd(Bucket bucket, Contact node) {
        boolean okay;
        ClassfulNetworkCounter counter = bucket.getClassfulNetworkCounter();
        boolean bl = okay = counter == null || counter.isOkayToAdd(node);
        if (LOG.isTraceEnabled()) {
            if (okay) {
                LOG.trace("It's okay to add " + node + " to " + bucket);
            } else {
                LOG.trace("It's NOT okay to add " + node + " to " + bucket);
            }
        }
        return okay;
    }

    protected synchronized boolean remove(Contact node) {
        return this.remove(node.getNodeID());
    }

    protected synchronized boolean remove(KUID nodeId) {
        return this.bucketTrie.select(nodeId).remove(nodeId);
    }

    @Override
    public synchronized Bucket getBucket(KUID nodeId) {
        return this.bucketTrie.select(nodeId);
    }

    @Override
    public synchronized Contact select(final KUID nodeId) {
        final Contact[] node = new Contact[]{null};
        this.bucketTrie.select(nodeId, new Trie.Cursor<KUID, Bucket>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                node[0] = entry.getValue().select(nodeId);
                if (node[0] != null) {
                    return Trie.Cursor.SelectStatus.EXIT;
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return node[0];
    }

    @Override
    public synchronized Contact get(KUID nodeId) {
        return this.bucketTrie.select(nodeId).get(nodeId);
    }

    public synchronized Collection<Contact> select(KUID nodeId, int count) {
        return this.select(nodeId, count, RouteTable.SelectMode.ALL);
    }

    @Override
    public synchronized Collection<Contact> select(final KUID nodeId, final int count, final RouteTable.SelectMode mode) {
        if (count == 0) {
            return Collections.emptyList();
        }
        final int maxNodeFailures = RouteTableSettings.MAX_ACCEPT_NODE_FAILURES.getValue();
        final ArrayList<Contact> nodes = new ArrayList<Contact>(count);
        this.bucketTrie.select(nodeId, new Trie.Cursor<KUID, Bucket>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                Bucket bucket = entry.getValue();
                Collection<Contact> list = null;
                list = mode == RouteTable.SelectMode.ALIVE || mode == RouteTable.SelectMode.ALIVE_WITH_LOCAL ? bucket.select(nodeId, bucket.getActiveSize()) : bucket.select(nodeId, count);
                for (Contact node : list) {
                    if (nodes.size() >= count) {
                        return Trie.Cursor.SelectStatus.EXIT;
                    }
                    if (mode == RouteTable.SelectMode.ALIVE && !node.isAlive() || mode == RouteTable.SelectMode.ALIVE_WITH_LOCAL && !node.isAlive() && !RouteTableImpl.this.isLocalNode(node) || node.isShutdown()) continue;
                    if (node.isDead()) {
                        float fact = (float)(maxNodeFailures - node.getFailures()) / (float)Math.max(1, maxNodeFailures);
                        if (Math.random() >= (double)fact) continue;
                    }
                    nodes.add(node);
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        assert (nodes.size() <= count) : "Expected " + count + " or less elements but is " + nodes.size();
        return nodes;
    }

    @Override
    public synchronized Collection<Contact> getContacts() {
        Collection<Contact> live = this.getActiveContacts();
        Collection<Contact> cached = this.getCachedContacts();
        ArrayList<Contact> nodes = new ArrayList<Contact>(live.size() + cached.size());
        nodes.addAll(live);
        nodes.addAll(cached);
        return nodes;
    }

    @Override
    public synchronized Collection<Contact> getActiveContacts() {
        ArrayList<Contact> nodes = new ArrayList<Contact>();
        for (Bucket bucket : this.bucketTrie.values()) {
            nodes.addAll(bucket.getActiveContacts());
        }
        return nodes;
    }

    @Override
    public synchronized Collection<Contact> getCachedContacts() {
        ArrayList<Contact> nodes = new ArrayList<Contact>();
        for (Bucket bucket : this.bucketTrie.values()) {
            nodes.addAll(bucket.getCachedContacts());
        }
        return nodes;
    }

    @Override
    public synchronized Collection<KUID> getRefreshIDs(final boolean bootstrapping) {
        KUID nodeId = this.getLocalNode().getNodeID();
        final ArrayList<KUID> randomIds = new ArrayList<KUID>();
        this.bucketTrie.select(nodeId, new Trie.Cursor<KUID, Bucket>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                Bucket bucket = entry.getValue();
                if (bootstrapping && bucket.contains(RouteTableImpl.this.getLocalNode().getNodeID())) {
                    return Trie.Cursor.SelectStatus.CONTINUE;
                }
                if (bootstrapping || bucket.isRefreshRequired()) {
                    KUID randomId = KUID.createPrefxNodeID(bucket.getBucketID(), bucket.getDepth());
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Refreshing bucket:" + bucket + " with random ID: " + randomId);
                    }
                    randomIds.add(randomId);
                    RouteTableImpl.this.touchBucket(bucket);
                }
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
        return randomIds;
    }

    @Override
    public synchronized Collection<Bucket> getBuckets() {
        return Collections.unmodifiableCollection(this.bucketTrie.values());
    }

    private void touchBucket(Bucket bucket) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Touching bucket: " + bucket);
        }
        bucket.touch();
    }

    private void pingLeastRecentlySeenNode(Bucket bucket) {
        Contact lrs = bucket.getLeastRecentlySeenActiveContact();
        if (!this.isLocalNode(lrs)) {
            this.ping(lrs, null);
        }
    }

    private void ping(Contact node, DHTFutureListener<PingResult> listener) {
        RouteTable.ContactPinger pinger = this.pinger;
        if (pinger != null) {
            pinger.ping(node, listener);
        } else {
            this.handleFailure(node.getNodeID(), node.getContactAddress());
            if (listener != null) {
                ExecutionException exception = new ExecutionException(new DHTTimeoutException(node.getNodeID(), node.getContactAddress(), null, 0L));
                listener.handleExecutionException(exception);
            }
        }
    }

    @Override
    public Contact getLocalNode() {
        if (this.localNode == null) {
            throw new IllegalStateException("RouteTable is not initialized");
        }
        return this.localNode;
    }

    @Override
    public boolean isLocalNode(Contact node) {
        return node.equals(this.getLocalNode());
    }

    @Override
    public synchronized int size() {
        return this.getActiveContacts().size() + this.getCachedContacts().size();
    }

    @Override
    public synchronized void clear() {
        this.bucketTrie.clear();
        this.fireClear();
        this.init();
    }

    @Override
    public synchronized void purge(long elapsedTimeSinceLastContact) {
        if (this.localNode == null) {
            throw new IllegalStateException("RouteTable is not initialized");
        }
        if (elapsedTimeSinceLastContact == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        for (Contact node : this.getActiveContacts()) {
            if (this.isLocalNode(node) || currentTime - node.getTimeStamp() < elapsedTimeSinceLastContact) continue;
            this.remove(node);
        }
        for (Contact node : this.getCachedContacts()) {
            if (currentTime - node.getTimeStamp() < elapsedTimeSinceLastContact) continue;
            this.remove(node);
        }
        this.mergeBuckets();
    }

    @Override
    public synchronized void purge(RouteTable.PurgeMode first, RouteTable.PurgeMode ... rest) {
        if (this.localNode == null) {
            throw new IllegalStateException("RouteTable is not initialized");
        }
        EnumSet<RouteTable.PurgeMode[]> modes = EnumSet.of(first, rest);
        if (modes.contains((Object)RouteTable.PurgeMode.DROP_CACHE)) {
            this.dropCache();
        }
        if (modes.contains((Object)RouteTable.PurgeMode.PURGE_CONTACTS)) {
            this.purgeContacts();
        }
        if (modes.contains((Object)RouteTable.PurgeMode.MERGE_BUCKETS)) {
            this.mergeBuckets();
        }
        if (modes.contains((Object)RouteTable.PurgeMode.STATE_TO_UNKNOWN)) {
            this.changeStateToUnknown(this.getActiveContacts());
            this.changeStateToUnknown(this.getCachedContacts());
        }
    }

    private synchronized void dropCache() {
        for (Contact node : this.getCachedContacts()) {
            this.remove(node);
        }
    }

    private synchronized void purgeContacts() {
        this.bucketTrie.traverse(new Trie.Cursor<KUID, Bucket>(){

            @Override
            public Trie.Cursor.SelectStatus select(Map.Entry<? extends KUID, ? extends Bucket> entry) {
                Bucket bucket = entry.getValue();
                bucket.purge();
                return Trie.Cursor.SelectStatus.CONTINUE;
            }
        });
    }

    private synchronized void mergeBuckets() {
        Collection<Contact> activeNodes = this.getActiveContacts();
        activeNodes = ContactUtils.sortAliveToFailed(activeNodes);
        Collection<Contact> cachedNodes = this.getCachedContacts();
        cachedNodes = ContactUtils.sort(cachedNodes);
        this.clear();
        boolean removed = activeNodes.remove(this.localNode);
        assert (removed);
        for (Contact node : activeNodes) {
            this.add(node);
        }
        for (Contact node : cachedNodes) {
            this.add(node);
        }
    }

    private synchronized void changeStateToUnknown(Collection<Contact> nodes) {
        for (Contact node : nodes) {
            node.unknown();
        }
    }

    protected void fireActiveContactAdded(Bucket bucket, Contact node) {
        this.fireRouteTableEvent(bucket, null, null, null, node, RouteTable.RouteTableEvent.EventType.ADD_ACTIVE_CONTACT);
    }

    protected void fireCachedContactAdded(Bucket bucket, Contact existing, Contact node) {
        this.fireRouteTableEvent(bucket, null, null, existing, node, RouteTable.RouteTableEvent.EventType.ADD_CACHED_CONTACT);
    }

    protected void fireContactUpdate(Bucket bucket, Contact existing, Contact node) {
        this.fireRouteTableEvent(bucket, null, null, existing, node, RouteTable.RouteTableEvent.EventType.UPDATE_CONTACT);
    }

    protected void fireReplaceContact(Bucket bucket, Contact existing, Contact node) {
        this.fireRouteTableEvent(bucket, null, null, existing, node, RouteTable.RouteTableEvent.EventType.REPLACE_CONTACT);
    }

    protected void fireRemoveContact(Bucket bucket, Contact node) {
        this.fireRouteTableEvent(bucket, null, null, null, node, RouteTable.RouteTableEvent.EventType.REMOVE_CONTACT);
    }

    protected void fireContactCheck(Bucket bucket, Contact existing, Contact node) {
        this.fireRouteTableEvent(bucket, null, null, existing, node, RouteTable.RouteTableEvent.EventType.CONTACT_CHECK);
    }

    protected void fireSplitBucket(Bucket bucket, Bucket left, Bucket right) {
        this.fireRouteTableEvent(bucket, left, right, null, null, RouteTable.RouteTableEvent.EventType.SPLIT_BUCKET);
    }

    protected void fireClear() {
        this.fireRouteTableEvent(null, null, null, null, null, RouteTable.RouteTableEvent.EventType.CLEAR);
    }

    protected void fireRouteTableEvent(Bucket bucket, Bucket left, Bucket right, Contact existing, Contact node, RouteTable.RouteTableEvent.EventType type) {
        if (this.listeners.isEmpty()) {
            return;
        }
        final RouteTable.RouteTableEvent event = new RouteTable.RouteTableEvent(this, bucket, left, right, existing, node, type);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                for (RouteTable.RouteTableListener listener : RouteTableImpl.this.listeners) {
                    listener.handleRouteTableEvent(event);
                }
            }
        };
        DHTExecutorService e = this.notifier;
        if (e != null) {
            e.executeSequentially(r);
        } else {
            r.run();
        }
    }

    public synchronized String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Local: ").append(this.getLocalNode()).append("\n");
        int alive = 0;
        int dead = 0;
        int down = 0;
        int unknown = 0;
        for (Bucket bucket : this.getBuckets()) {
            buffer.append(bucket).append("\n");
            for (Contact node : bucket.getActiveContacts()) {
                if (node.isShutdown()) {
                    ++down;
                }
                if (node.isAlive()) {
                    ++alive;
                    continue;
                }
                if (node.isDead()) {
                    ++dead;
                    continue;
                }
                ++unknown;
            }
            for (Contact node : bucket.getCachedContacts()) {
                if (node.isShutdown()) {
                    ++down;
                }
                if (node.isAlive()) {
                    ++alive;
                    continue;
                }
                if (node.isDead()) {
                    ++dead;
                    continue;
                }
                ++unknown;
            }
        }
        buffer.append("Total Buckets: ").append(this.bucketTrie.size()).append("\n");
        buffer.append("Total Active Contacts: ").append(this.getActiveContacts().size()).append("\n");
        buffer.append("Total Cached Contacts: ").append(this.getCachedContacts().size()).append("\n");
        buffer.append("Total Alive Contacts: ").append(alive).append("\n");
        buffer.append("Total Dead Contacts: ").append(dead).append("\n");
        buffer.append("Total Down Contacts: ").append(down).append("\n");
        buffer.append("Total Unknown Contacts: ").append(unknown).append("\n");
        return buffer.toString();
    }
}

