/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.IP;
import org.limewire.io.IpPort;
import org.limewire.util.ByteUtils;

class MemoryOptimizedIpPortImpl
implements IpPort {
    private int addr;
    private short shortport;

    public MemoryOptimizedIpPortImpl(IP ip, short shortport) {
        this.addr = ip.addr;
        this.shortport = shortport;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public InetAddress getInetAddress() {
        byte[] baddr = new byte[4];
        ByteUtils.int2beb(this.addr, baddr, 0);
        try {
            return InetAddress.getByAddress(baddr);
        }
        catch (UnknownHostException uhe) {
            throw new RuntimeException(uhe);
        }
    }

    @Override
    public String getAddress() {
        return (this.addr >> 24 & 0xFF) + "." + (this.addr >> 16 & 0xFF) + "." + (this.addr >> 8 & 0xFF) + "." + (this.addr & 0xFF);
    }

    @Override
    public int getPort() {
        return ByteUtils.ushort2int(this.shortport);
    }

    public String toString() {
        return "host: " + this.getAddress() + ", port: " + this.getPort();
    }
}

