/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.geocode;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class GeocodeInformation {
    private final Map<Property, String> names2values = new EnumMap<Property, String>(Property.class);
    private static final Map<String, Property> STRINGS2PROPERTIES = new HashMap<String, Property>();
    public static final GeocodeInformation EMPTY_GEO_INFO = new GeocodeInformation(){

        @Override
        public void setProperty(Property arg0, String arg1) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProperty(String arg0, String arg1) {
            throw new UnsupportedOperationException();
        }
    };

    public String getProperty(Property p) {
        return this.names2values.get((Object)p);
    }

    public boolean isEmpty() {
        return this.names2values.isEmpty();
    }

    public void setProperty(String name, String value) {
        Property prop = GeocodeInformation.getStrings2Properties().get(name);
        if (prop != null) {
            this.setProperty(prop, value);
        }
    }

    public void setProperty(Property p, String value) {
        this.names2values.put(p, value);
    }

    public String toString() {
        return String.valueOf(this.names2values);
    }

    public static Map<String, Property> getStrings2Properties() {
        return STRINGS2PROPERTIES;
    }

    public Properties toProperties() {
        Properties props = new Properties();
        for (Map.Entry<Property, String> entry : this.names2values.entrySet()) {
            props.setProperty(entry.getKey().getValue(), entry.getValue());
        }
        return props;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GeocodeInformation) {
            return ((Object)this.names2values).equals(((GeocodeInformation)obj).names2values);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.names2values).hashCode();
    }

    public static GeocodeInformation fromProperties(Properties props) {
        GeocodeInformation info = new GeocodeInformation();
        for (Property property : Property.values()) {
            String value = props.getProperty(property.getValue());
            if (value == null) continue;
            info.setProperty(property, value);
        }
        return info;
    }

    static {
        Property.AreaCode.getValue();
    }

    public static enum Property {
        Ip("Ip"),
        CountryCode("CountryCode"),
        CountryCode3("CountryCode3"),
        CountryName("CountryName"),
        Region("Region"),
        Region2("Region2"),
        City("City"),
        PostalCode("PostalCode"),
        Latitude("Latitude"),
        Longitude("Longitude"),
        DmaCode("DmaCode"),
        AreaCode("AreaCode");

        private final String s;

        private Property(String s) {
            this.s = s;
            GeocodeInformation.getStrings2Properties().put(s, this);
        }

        public String getValue() {
            return this.s;
        }
    }
}

