/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jcip.annotations.GuardedBy;
import org.limewire.collection.glazedlists.AbstractListEventListener;
import org.limewire.core.api.browse.Browse;
import org.limewire.core.api.browse.BrowseFactory;
import org.limewire.core.api.browse.BrowseListener;
import org.limewire.core.api.library.FriendLibrary;
import org.limewire.core.api.library.PresenceLibrary;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.library.RemoteLibraryState;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.impl.friend.FriendRemoteFileDescDeserializer;
import org.limewire.core.impl.search.RemoteFileDescAdapter;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.LibraryChangedEvent;
import org.limewire.friend.api.feature.AddressFeature;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.Address;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.net.ConnectivityChangeEvent;
import org.limewire.net.SocketsManager;
import org.limewire.net.address.AddressResolutionObserver;

@EagerSingleton
class PresenceLibraryBrowser
implements EventListener<LibraryChangedEvent> {
    private static final Log LOG = LogFactory.getLog(PresenceLibraryBrowser.class);
    private final BrowseFactory browseFactory;
    private final RemoteLibraryManager remoteLibraryManager;
    private final SocketsManager socketsManager;
    final Set<PresenceLibrary> librariesToBrowse = Collections.synchronizedSet(new HashSet());
    @GuardedBy(value="librariesToBrowse")
    private volatile int latestConnectivityEventRevision = 0;

    @Inject
    public PresenceLibraryBrowser(BrowseFactory browseFactory, RemoteLibraryManager remoteLibraryManager, SocketsManager socketsManager, FriendRemoteFileDescDeserializer remoteFileDescDeserializer) {
        this.browseFactory = browseFactory;
        this.remoteLibraryManager = remoteLibraryManager;
        this.socketsManager = socketsManager;
    }

    @Inject
    void register(ListenerSupport<LibraryChangedEvent> listenerSupport) {
        listenerSupport.addListener(this);
    }

    @Inject
    void registerToSocksManager() {
        this.socketsManager.addListener(new ConnectivityChangeListener());
    }

    @Inject
    void registerToRemoteLibraryManager() {
        this.remoteLibraryManager.getFriendLibraryList().addListEventListener(new ListEventListener<FriendLibrary>(){

            @Override
            public void listChanged(ListEvent<FriendLibrary> listChanges) {
                while (listChanges.next()) {
                    if (listChanges.getType() != 2) continue;
                    FriendLibrary friendLibrary = (FriendLibrary)listChanges.getSourceList().get(listChanges.getIndex());
                    new AbstractListEventListener<PresenceLibrary>(){

                        @Override
                        protected void itemAdded(PresenceLibrary presenceLibrary, int idx, EventList<PresenceLibrary> source) {
                            PresenceLibraryBrowser.this.tryToResolveAndBrowse(presenceLibrary, PresenceLibraryBrowser.this.latestConnectivityEventRevision);
                        }

                        @Override
                        protected void itemRemoved(PresenceLibrary item, int idx, EventList<PresenceLibrary> source) {
                            PresenceLibraryBrowser.this.librariesToBrowse.remove(item);
                        }

                        @Override
                        protected void itemUpdated(PresenceLibrary item, PresenceLibrary prior, int idx, EventList<PresenceLibrary> source) {
                        }
                    }.install(friendLibrary.getPresenceLibraryList());
                }
            }
        });
    }

    @Override
    public void handleEvent(LibraryChangedEvent event) {
        FriendPresence friend = (FriendPresence)event.getData();
        PresenceLibrary existingLibrary = this.remoteLibraryManager.getPresenceLibrary(friend);
        if (!this.remoteLibraryManager.addPresenceLibrary(friend) && existingLibrary != null) {
            LOG.debugf("Library changed event for {0}, but existing library -- rebrowsing into existing library", (Object)friend);
            this.tryToResolveAndBrowse(existingLibrary, this.latestConnectivityEventRevision);
        }
    }

    void browse(final PresenceLibrary presenceLibrary) {
        presenceLibrary.setState(RemoteLibraryState.LOADING);
        final FriendPresence friendPresence = presenceLibrary.getPresence();
        AddressFeature addressFeature = (AddressFeature)friendPresence.getFeature(AddressFeature.ID);
        if (addressFeature == null) {
            return;
        }
        LOG.debugf("browsing {0} ...", (Object)friendPresence.getPresenceId());
        Browse browse = this.browseFactory.createBrowse(friendPresence);
        browse.start(new BrowseListener(){
            private final List<SearchResult> transitList;
            {
                int size = presenceLibrary.size();
                if (size == 0) {
                    this.transitList = null;
                } else if (PresenceLibraryBrowser.this.remoteLibraryManager.getAllFriendsLibrary().size() > 5000) {
                    presenceLibrary.clear();
                    this.transitList = null;
                } else {
                    this.transitList = new ArrayList<SearchResult>(size);
                }
            }

            @Override
            public void handleBrowseResult(SearchResult searchResult) {
                LOG.debugf("browse result: {0}, {1}", (Object)searchResult.getUrn(), (Object)searchResult.getSize());
                RemoteFileDescAdapter remoteFileDescAdapter = (RemoteFileDescAdapter)searchResult;
                remoteFileDescAdapter = new RemoteFileDescAdapter(remoteFileDescAdapter, friendPresence);
                if (this.transitList != null) {
                    this.transitList.add(remoteFileDescAdapter);
                } else {
                    presenceLibrary.addNewResult(remoteFileDescAdapter);
                }
            }

            @Override
            public void browseFinished(boolean success) {
                if (this.transitList != null) {
                    LOG.debugf("Finished browse of {0}, setting resulting files into existing list", (Object)friendPresence);
                    presenceLibrary.setNewResults(this.transitList);
                } else {
                    LOG.debugf("Finished browse of {0}, no in-transit list.", (Object)friendPresence);
                }
                if (success) {
                    presenceLibrary.setState(RemoteLibraryState.LOADED);
                } else {
                    presenceLibrary.setState(RemoteLibraryState.FAILED_TO_LOAD);
                    LOG.debugf("browse failed: {0}", (Object)presenceLibrary);
                }
            }
        });
    }

    void tryToResolveAndBrowse(final PresenceLibrary presenceLibrary, final int startConnectivityRevision) {
        presenceLibrary.setState(RemoteLibraryState.LOADING);
        final FriendPresence friendPresence = presenceLibrary.getPresence();
        AddressFeature addressFeature = (AddressFeature)friendPresence.getFeature(AddressFeature.ID);
        if (addressFeature == null) {
            LOG.debug("no address feature");
            this.handleFailedResolution(presenceLibrary, startConnectivityRevision);
            return;
        }
        Address address = (Address)addressFeature.getFeature();
        if (this.socketsManager.canResolve(address)) {
            this.socketsManager.resolve(address, new AddressResolutionObserver(){

                @Override
                public void resolved(Address address) {
                    if (PresenceLibraryBrowser.this.socketsManager.canConnect(address)) {
                        LOG.debugf("resolved {0} for {1} and can connect", (Object)address, (Object)friendPresence);
                        PresenceLibraryBrowser.this.browse(presenceLibrary);
                    } else {
                        LOG.debugf("resolved {0} for {1} and cannot connect", (Object)address, (Object)friendPresence);
                        PresenceLibraryBrowser.this.handleFailedResolution(presenceLibrary, startConnectivityRevision);
                    }
                }

                @Override
                public void handleIOException(IOException iox) {
                    LOG.debug("resolve error", iox);
                    PresenceLibraryBrowser.this.handleFailedResolution(presenceLibrary, startConnectivityRevision);
                }

                @Override
                public void shutdown() {
                }
            });
        } else if (this.socketsManager.canConnect(address)) {
            this.browse(presenceLibrary);
        } else {
            this.handleFailedResolution(presenceLibrary, startConnectivityRevision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailedResolution(PresenceLibrary presenceLibrary, int startRevision) {
        boolean retry;
        LOG.debugf("failed resolution for:{0} revision:{1}", (Object)presenceLibrary.getPresence().getPresenceId(), (Object)startRevision);
        presenceLibrary.setState(RemoteLibraryState.FAILED_TO_LOAD);
        Set<PresenceLibrary> set = this.librariesToBrowse;
        synchronized (set) {
            boolean bl = retry = this.latestConnectivityEventRevision > startRevision;
            if (!retry) {
                LOG.debugf("readding and not trying after fail {0}", (Object)presenceLibrary);
                boolean wasAdded = this.librariesToBrowse.add(presenceLibrary);
                assert (wasAdded);
            } else {
                startRevision = this.latestConnectivityEventRevision;
                LOG.debugf("retrying with new revision {0}", (Object)startRevision);
            }
            LOG.debugf("libraries to browser after fail: {0}, size {1}", (Object)this.librariesToBrowse, (Object)this.librariesToBrowse.size());
        }
        if (retry) {
            this.tryToResolveAndBrowse(presenceLibrary, startRevision);
        }
    }

    private class ConnectivityChangeListener
    implements EventListener<ConnectivityChangeEvent> {
        private ConnectivityChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleEvent(ConnectivityChangeEvent event) {
            ArrayList<PresenceLibrary> copy;
            int currentRevision;
            LOG.debug("connectivity change");
            Set<PresenceLibrary> set = PresenceLibraryBrowser.this.librariesToBrowse;
            synchronized (set) {
                currentRevision = ++PresenceLibraryBrowser.this.latestConnectivityEventRevision;
                copy = new ArrayList<PresenceLibrary>(PresenceLibraryBrowser.this.librariesToBrowse);
                PresenceLibraryBrowser.this.librariesToBrowse.clear();
            }
            LOG.debugf("revision: {0}, libraries to browse again: {1}", (Object)currentRevision, (Object)copy);
            for (PresenceLibrary library : copy) {
                PresenceLibraryBrowser.this.tryToResolveAndBrowse(library, currentRevision);
            }
        }
    }
}

