/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import com.google.common.base.Predicate;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.library.FileCollection;
import com.limegroup.gnutella.library.FileDesc;
import com.limegroup.gnutella.library.FileViewChangeEvent;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.ListeningFutureDelegator;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.core.api.library.LocalFileList;
import org.limewire.core.impl.library.CoreLocalFileItemFactory;
import org.limewire.listener.EventListener;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

abstract class LocalFileListImpl
implements LocalFileList {
    private static final Log LOG = LogFactory.getLog(LocalFileListImpl.class);
    protected final EventList<LocalFileItem> baseList;
    protected final TransformedList<LocalFileItem, LocalFileItem> threadSafeList;
    protected final TransformedList<LocalFileItem, LocalFileItem> readOnlyList;
    protected volatile TransformedList<LocalFileItem, LocalFileItem> swingEventList;
    private final CoreLocalFileItemFactory fileItemFactory;

    LocalFileListImpl(EventList<LocalFileItem> eventList, CoreLocalFileItemFactory fileItemFactory) {
        this.baseList = eventList;
        this.threadSafeList = GlazedListsFactory.threadSafeList(eventList);
        this.readOnlyList = GlazedListsFactory.readOnlyList(this.threadSafeList);
        this.fileItemFactory = fileItemFactory;
    }

    protected abstract FileCollection getCoreCollection();

    @Override
    public ListeningFuture<LocalFileItem> addFile(File file) {
        return new Wrapper(this.getCoreCollection().add(file));
    }

    @Override
    public void removeFile(File file) {
        this.getCoreCollection().remove(file);
    }

    @Override
    public ListeningFuture<List<ListeningFuture<LocalFileItem>>> addFolder(File folder, FileFilter fileFilter) {
        return new ListWrapper(this.getCoreCollection().addFolder(folder, fileFilter));
    }

    @Override
    public boolean contains(File file) {
        return this.getCoreCollection().contains(file);
    }

    @Override
    public boolean contains(org.limewire.core.api.URN urn) {
        if (urn instanceof URN) {
            return this.containsCoreUrn((URN)urn);
        }
        return false;
    }

    protected boolean containsCoreUrn(URN urn) {
        return !this.getCoreCollection().getFileDescsMatching(urn).isEmpty();
    }

    @Override
    public EventList<LocalFileItem> getModel() {
        return this.readOnlyList;
    }

    @Override
    public EventList<LocalFileItem> getSwingModel() {
        assert (EventQueue.isDispatchThread());
        if (this.swingEventList == null) {
            this.swingEventList = GlazedListsFactory.swingThreadProxyEventList(this.readOnlyList);
        }
        return this.swingEventList;
    }

    void dispose() {
        if (this.swingEventList != null) {
            this.swingEventList.dispose();
        }
        this.threadSafeList.dispose();
        this.readOnlyList.dispose();
    }

    @Override
    public int size() {
        return this.threadSafeList.size();
    }

    protected void addFileDesc(FileDesc fd) {
        this.threadSafeList.add(this.getOrCreateLocalFileItem(fd));
    }

    private LocalFileItem getOrCreateLocalFileItem(FileDesc fileDesc) {
        LocalFileItem item;
        Object object = fileDesc.getClientProperty("limewire.fileitem");
        if (object != null) {
            item = (LocalFileItem)object;
        } else {
            item = this.fileItemFactory.createCoreLocalFileItem(fileDesc);
            fileDesc.putClientProperty("limewire.fileitem", item);
        }
        return item;
    }

    protected void addAllFileDescs(Iterable<FileDesc> fileDescs) {
        ArrayList<LocalFileItem> fileItems = new ArrayList<LocalFileItem>();
        for (FileDesc fileDesc : fileDescs) {
            fileItems.add(this.getOrCreateLocalFileItem(fileDesc));
        }
        this.threadSafeList.addAll(fileItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileDesc(FileDesc fd) {
        LocalFileItem item = (LocalFileItem)fd.getClientProperty("limewire.fileitem");
        if (item != null) {
            this.threadSafeList.getReadWriteLock().writeLock().lock();
            try {
                int idx = this.threadSafeList.indexOf(item);
                if (idx > 0) {
                    this.threadSafeList.set(idx, item);
                }
                LOG.warnf("Attempted to update FD w/ LocalFileItem that is not in list anymore. Item {0}", (Object)item);
            }
            finally {
                this.threadSafeList.getReadWriteLock().writeLock().unlock();
            }
        } else {
            LOG.warnf("Attempted to update FD without LocalFileItem, FD {0}", (Object)fd);
        }
    }

    protected void changeFileDesc(FileDesc old, FileDesc now) {
        this.removeFileDesc(old);
        this.addFileDesc(now);
    }

    protected void removeFileDesc(FileDesc fd) {
        LocalFileItem item = (LocalFileItem)fd.getClientProperty("limewire.fileitem");
        this.threadSafeList.remove(item);
    }

    protected void clearFileDescs() {
        this.threadSafeList.clear();
    }

    protected EventListener<FileViewChangeEvent> newEventListener() {
        return new EventListener<FileViewChangeEvent>(){

            @Override
            public void handleEvent(FileViewChangeEvent event) {
                switch (event.getType()) {
                    case FILE_META_CHANGED: {
                        LocalFileListImpl.this.updateFileDesc(event.getFileDesc());
                        break;
                    }
                    case FILE_ADDED: {
                        LocalFileListImpl.this.addFileDesc(event.getFileDesc());
                        break;
                    }
                    case FILE_CHANGED: {
                        LocalFileListImpl.this.changeFileDesc(event.getOldValue(), event.getFileDesc());
                        break;
                    }
                    case FILE_REMOVED: {
                        LocalFileListImpl.this.removeFileDesc(event.getFileDesc());
                        break;
                    }
                    case FILES_CLEARED: {
                        LocalFileListImpl.this.clearFileDescs();
                    }
                }
            }
        };
    }

    @Override
    public LocalFileItem getFileItem(File file) {
        FileDesc fileDesc = this.getCoreCollection().getFileDesc(file);
        if (fileDesc != null) {
            return (LocalFileItem)fileDesc.getClientProperty("limewire.fileitem");
        }
        return null;
    }

    @Override
    public boolean isFileAllowed(File file) {
        return this.getCoreCollection().isFileAllowed(file);
    }

    @Override
    public boolean isDirectoryAllowed(File folder) {
        return this.getCoreCollection().isDirectoryAllowed(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFiles(Predicate<LocalFileItem> filter) {
        ArrayList<LocalFileItem> files = new ArrayList<LocalFileItem>();
        this.getModel().getReadWriteLock().readLock().lock();
        try {
            for (LocalFileItem localFileItem : this.getModel()) {
                if (!filter.apply(localFileItem)) continue;
                files.add(localFileItem);
            }
        }
        finally {
            this.getModel().getReadWriteLock().readLock().unlock();
        }
        for (LocalFileItem localFileItem : files) {
            this.removeFile(localFileItem.getFile());
        }
    }

    @Override
    public void clear() {
        this.getCoreCollection().clear();
    }

    private static class Wrapper
    extends ListeningFutureDelegator<FileDesc, LocalFileItem> {
        public Wrapper(ListeningFuture<FileDesc> delegate) {
            super(delegate);
        }

        @Override
        protected LocalFileItem convertSource(FileDesc source) {
            return (LocalFileItem)source.getClientProperty("limewire.fileitem");
        }

        @Override
        protected LocalFileItem convertException(ExecutionException ee) throws ExecutionException {
            throw ee;
        }
    }

    private static class ListWrapper
    extends ListeningFutureDelegator<List<ListeningFuture<FileDesc>>, List<ListeningFuture<LocalFileItem>>> {
        public ListWrapper(ListeningFuture<List<ListeningFuture<FileDesc>>> delegate) {
            super(delegate);
        }

        @Override
        protected List<ListeningFuture<LocalFileItem>> convertSource(List<ListeningFuture<FileDesc>> source) {
            ArrayList<ListeningFuture<LocalFileItem>> replaced = new ArrayList<ListeningFuture<LocalFileItem>>(source.size());
            for (ListeningFuture<FileDesc> future : source) {
                replaced.add(new Wrapper(future));
            }
            return replaced;
        }

        @Override
        protected List<ListeningFuture<LocalFileItem>> convertException(ExecutionException ee) throws ExecutionException {
            throw ee;
        }
    }
}

