/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.AsfExtHeaderModifier;
import org.jaudiotagger.audio.asf.io.AsfHeaderReader;
import org.jaudiotagger.audio.asf.io.AsfStreamer;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.ChunkRemover;
import org.jaudiotagger.audio.asf.io.RandomAccessFileInputstream;
import org.jaudiotagger.audio.asf.io.RandomAccessFileOutputStream;
import org.jaudiotagger.audio.asf.io.WriteableChunkModifer;
import org.jaudiotagger.audio.asf.tag.AsfTag;
import org.jaudiotagger.audio.asf.tag.AsfTagField;
import org.jaudiotagger.audio.asf.util.TagConverter;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.generic.AudioFileWriter;
import org.jaudiotagger.tag.Tag;

public class AsfFileWriter
extends AudioFileWriter {
    private ExtendedContentDescription createNewExtendedContentDescription(AsfTag tag) {
        ExtendedContentDescription result = new ExtendedContentDescription();
        TagConverter.assignCommonTagValues(tag, result);
        TagConverter.assignOptionalTagValues(tag, result);
        return result;
    }

    @Override
    protected void deleteTag(RandomAccessFile raf, RandomAccessFile tempRaf) throws CannotWriteException, IOException {
        this.writeTag(new AsfTag(true), raf, tempRaf);
    }

    private boolean isContentdescriptionMandatory(AsfTag tag) {
        return !Utils.isBlank(tag.getFirstArtist()) || !Utils.isBlank(tag.getFirstComment()) || !Utils.isBlank(tag.getFirstTitle()) || !Utils.isBlank(tag.getFirstCopyright()) || !Utils.isBlank(tag.getFirstRating());
    }

    private boolean isExtendedContentDescriptionMandatory(AsfTag tag) {
        Iterator asfFields = tag.getAsfFields();
        boolean found = false;
        while (asfFields.hasNext() && !found) {
            AsfTagField curr = (AsfTagField)asfFields.next();
            found = !AsfTag.storesDescriptor(curr.getDescriptor());
        }
        return found;
    }

    @Override
    protected void writeTag(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        ChunkRemover remover;
        WriteableChunkModifer Modifier2;
        AsfHeader sourceHeader = AsfHeaderReader.readTagHeader(raf);
        raf.seek(0L);
        boolean headerCD = sourceHeader.getContentDescription() != null;
        boolean headerECD = sourceHeader.getExtendedContentDescription() != null;
        boolean extHeaderCD = sourceHeader.getExtendedHeader() != null && sourceHeader.getExtendedHeader().getContentDescription() != null;
        boolean extHeaderECD = sourceHeader.getExtendedHeader() != null && sourceHeader.getExtendedHeader().getExtendedContentDescription() != null;
        AsfTag copy = new AsfTag(tag, true);
        ArrayList<ChunkModifier> headerModifier = new ArrayList<ChunkModifier>();
        ArrayList<ChunkModifier> extHeaderModifier = new ArrayList<ChunkModifier>();
        if (this.isContentdescriptionMandatory(copy)) {
            Modifier2 = new WriteableChunkModifer(TagConverter.createContentDescription(copy));
            if (headerCD || !extHeaderCD) {
                headerModifier.add(Modifier2);
            }
            if (extHeaderCD) {
                extHeaderModifier.add(Modifier2);
            }
        } else {
            remover = new ChunkRemover(GUID.GUID_CONTENTDESCRIPTION);
            if (headerCD) {
                headerModifier.add(remover);
            }
            if (extHeaderCD) {
                extHeaderModifier.add(remover);
            }
        }
        if (this.isExtendedContentDescriptionMandatory(copy)) {
            Modifier2 = new WriteableChunkModifer(this.createNewExtendedContentDescription(copy));
            if (headerECD || !extHeaderECD) {
                headerModifier.add(Modifier2);
            }
            if (extHeaderECD) {
                extHeaderModifier.add(Modifier2);
            }
        } else {
            remover = new ChunkRemover(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION);
            if (headerECD) {
                headerModifier.add(remover);
            }
            if (extHeaderECD) {
                extHeaderModifier.add(remover);
            }
        }
        if (!extHeaderModifier.isEmpty()) {
            headerModifier.add(new AsfExtHeaderModifier(extHeaderModifier));
        }
        new AsfStreamer().createModifiedCopy(new RandomAccessFileInputstream(raf), new RandomAccessFileOutputStream(rafTemp), headerModifier);
    }
}

