/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.objeditor;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.fmj.ui.objeditor.ComponentValidationException;

public class ComponentValidator {
    public void validateNotEmpty(JTextField f, JLabel label) throws ComponentValidationException {
        String s = f.getText();
        if (s == null || s.equals("")) {
            throw new ComponentValidationException(f, ComponentValidator.buildMessage(label.getText(), "may not be empty"));
        }
    }

    public void validateNotEmpty(JComboBox c, JLabel label) throws ComponentValidationException {
        String s;
        Object o = c.getSelectedItem();
        String string = s = o == null ? null : o.toString();
        if (s == null || s.equals("")) {
            throw new ComponentValidationException(c, ComponentValidator.buildMessage(label.getText(), "may not be empty"));
        }
    }

    public void validateInteger(JComboBox c, JLabel label) throws ComponentValidationException {
        Object o = c.getSelectedItem();
        String s = o == null ? null : o.toString();
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ComponentValidationException(c, ComponentValidator.buildMessage(label.getText(), "not a valid number"));
        }
    }

    public void validateInteger(JTextField f, JLabel label) throws ComponentValidationException {
        String s = f.getText();
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new ComponentValidationException(f, ComponentValidator.buildMessage(label.getText(), "not a valid number"));
        }
    }

    private static String buildMessage(String label, String msg) {
        if (label == null || label.equals("")) {
            return msg;
        }
        if (label.endsWith(":")) {
            return label + " " + msg;
        }
        return label + ": " + msg;
    }
}

