/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.media.codec.audio.speex;

import com.ibm.media.codec.audio.AudioCodec;
import java.io.StreamCorruptedException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.xiph.speex.SpeexDecoder;

public class JavaDecoder
extends AudioCodec {
    private Format lastFormat = null;
    private int numberOfChannels = 0;
    private SpeexDecoder decoder = null;
    static int[] SpeexSubModeSz = new int[]{0, 43, 119, 160, 220, 300, 364, 492, 79, 0, 0, 0, 0, 0, 0, 0};
    static int[] SpeexInBandSz = new int[]{1, 1, 4, 4, 4, 4, 4, 4, 8, 8, 16, 16, 32, 32, 64, 64};
    static int[] SpeexWBSubModeSz = new int[]{0, 36, 112, 192, 352, 0, 0, 0};

    public JavaDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("speex/rtp", 8000.0, 8, 1, -1, -1)};
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("speex/rtp", 8000.0, 8, 1, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "Speex Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", af.getSampleRate(), 16, af.getChannels(), 0, 1)};
        return this.supportedOutputFormats;
    }

    public void open() {
    }

    public void close() {
    }

    private void initConverter(AudioFormat inFormat) {
        this.lastFormat = inFormat;
        this.numberOfChannels = inFormat.getChannels();
        this.decoder = new SpeexDecoder();
        this.decoder.init(0, (int)inFormat.getSampleRate(), inFormat.getChannels(), false);
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        int channels = this.outputFormat.getChannels();
        byte[] inData = (byte[])inputBuffer.getData();
        int inpLength = inputBuffer.getLength();
        int outLength = 0;
        int inOffset = inputBuffer.getOffset();
        int outOffset = outputBuffer.getOffset();
        Format newFormat = inputBuffer.getFormat();
        if (this.lastFormat != newFormat) {
            this.initConverter((AudioFormat)newFormat);
        }
        try {
            this.decoder.processData(inData, inOffset, inpLength);
            outLength = this.decoder.getProcessedDataByteSize();
            byte[] outData = this.validateByteArraySize(outputBuffer, outLength);
            this.decoder.getProcessedData(outData, outOffset);
        }
        catch (StreamCorruptedException ex) {
            ex.printStackTrace();
        }
        this.updateOutput(outputBuffer, this.outputFormat, outLength, 0);
        return 0;
    }

    private static int speex_get_samples(byte[] data, int len) {
        int bit = 0;
        int cnt = 0;
        int off = 0;
        while (len * 8 - bit >= 5 && (off = JavaDecoder.speex_get_wb_sz_at(data, len, bit)) >= 0 && len * 8 - (bit += off) >= 5) {
            int c = JavaDecoder.get_n_bits_at(data, 5, bit);
            bit += 5;
            if (c == 15) break;
            if (c == 14) {
                c = JavaDecoder.get_n_bits_at(data, 4, bit);
                bit += 4;
                bit += SpeexInBandSz[c];
                continue;
            }
            if (c == 13) {
                c = JavaDecoder.get_n_bits_at(data, 5, bit);
                bit += 5;
                bit += c * 8;
                continue;
            }
            if (c > 8) break;
            bit += SpeexSubModeSz[c] - 5;
            cnt += 160;
        }
        return cnt;
    }

    private static int get_n_bits_at(byte[] data, int n, int bit) {
        int byteInt = bit / 8;
        int rem = 8 - bit % 8;
        int ret = 0;
        if (n <= 0 || n > 8) {
            return 0;
        }
        if (rem < n) {
            ret = data[byteInt] << n - rem;
            ret |= data[byteInt + 1] >> 8 - n + rem;
        } else {
            ret = data[byteInt] >> rem - n;
        }
        return ret & 255 >> 8 - n;
    }

    private static int speex_get_wb_sz_at(byte[] data, int len, int bit) {
        int c;
        int off = bit;
        if (len * 8 - off >= 5 && JavaDecoder.get_n_bits_at(data, 1, off) != 0 && len * 8 - (off += SpeexWBSubModeSz[c = JavaDecoder.get_n_bits_at(data, 3, off + 1)]) >= 5 && JavaDecoder.get_n_bits_at(data, 1, off) != 0 && len * 8 - (off += SpeexWBSubModeSz[c = JavaDecoder.get_n_bits_at(data, 3, off + 1)]) >= 5 && JavaDecoder.get_n_bits_at(data, 1, off) != 0) {
            return -1;
        }
        return off - bit;
    }
}

