/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.mimeutil.detector;

import java.util.HashMap;
import java.util.Map;

final class MagicMimeEntryOperation {
    private static final Map operationID2operation = new HashMap();
    public static final MagicMimeEntryOperation EQUALS = new MagicMimeEntryOperation('=');
    public static final MagicMimeEntryOperation LESS_THAN = new MagicMimeEntryOperation('<');
    public static final MagicMimeEntryOperation GREATER_THAN = new MagicMimeEntryOperation('>');
    public static final MagicMimeEntryOperation AND = new MagicMimeEntryOperation('&');
    public static final MagicMimeEntryOperation CLEAR = new MagicMimeEntryOperation('^');
    public static final MagicMimeEntryOperation NEGATED = new MagicMimeEntryOperation('~');
    public static final MagicMimeEntryOperation ANY = new MagicMimeEntryOperation('x');
    public static final MagicMimeEntryOperation NOT_EQUALS = new MagicMimeEntryOperation('!');
    private final char operationID;

    public static MagicMimeEntryOperation getOperation(char c) {
        Character c2 = new Character(c);
        return (MagicMimeEntryOperation)operationID2operation.get(c2);
    }

    public static MagicMimeEntryOperation getOperationForStringField(String string) {
        MagicMimeEntryOperation magicMimeEntryOperation = MagicMimeEntryOperation.getOperation(string);
        if (EQUALS.equals(magicMimeEntryOperation) || LESS_THAN.equals(magicMimeEntryOperation) || GREATER_THAN.equals(magicMimeEntryOperation)) {
            return magicMimeEntryOperation;
        }
        return EQUALS;
    }

    public static MagicMimeEntryOperation getOperationForNumberField(String string) {
        return MagicMimeEntryOperation.getOperation(string);
    }

    private static MagicMimeEntryOperation getOperation(String string) {
        if (string.length() == 0) {
            return EQUALS;
        }
        MagicMimeEntryOperation magicMimeEntryOperation = MagicMimeEntryOperation.getOperation(string.charAt(0));
        if (magicMimeEntryOperation == null) {
            return EQUALS;
        }
        return magicMimeEntryOperation;
    }

    private static void registerOperation(MagicMimeEntryOperation magicMimeEntryOperation) {
        Character c = new Character(magicMimeEntryOperation.getOperationID());
        if (operationID2operation.containsKey(c)) {
            throw new IllegalStateException("Duplicate registration of operation " + c);
        }
        operationID2operation.put(c, magicMimeEntryOperation);
    }

    MagicMimeEntryOperation(char c) {
        this.operationID = c;
        MagicMimeEntryOperation.registerOperation(this);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.operationID;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MagicMimeEntryOperation magicMimeEntryOperation = (MagicMimeEntryOperation)object;
        return this.operationID == magicMimeEntryOperation.operationID;
    }

    public final char getOperationID() {
        return this.operationID;
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.operationID + ']';
    }
}

