/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.security.MerkleTree;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.core.settings.SharingSettings;
import org.limewire.util.SystemUtils;

public class HashTreeUtils {
    private static final Log LOG = LogFactory.getLog(HashTreeUtils.class);
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final int BLOCK_SIZE = 1024;
    public static final byte INTERNAL_HASH_PREFIX = 1;
    private static final ThreadLocal<byte[]> BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[131072];
        }
    };

    public static List<List<byte[]>> createAllParentNodes(List<byte[]> nodes, MessageDigest messageDigest) {
        ArrayList<List<byte[]>> allNodes = new ArrayList<List<byte[]>>();
        allNodes.add(Collections.unmodifiableList(nodes));
        while (nodes.size() > 1) {
            nodes = HashTreeUtils.createParentGeneration(nodes, messageDigest);
            allNodes.add(0, nodes);
        }
        return allNodes;
    }

    public static List<byte[]> createParentGeneration(List<byte[]> nodes, MessageDigest md) {
        md.reset();
        int size = nodes.size();
        size = size % 2 == 0 ? size / 2 : (size + 1) / 2;
        ArrayList<byte[]> ret = new ArrayList<byte[]>(size);
        Iterator<byte[]> iter = nodes.iterator();
        while (iter.hasNext()) {
            byte[] left = iter.next();
            if (iter.hasNext()) {
                byte[] right = iter.next();
                md.reset();
                md.update((byte)1);
                md.update(left, 0, left.length);
                md.update(right, 0, right.length);
                byte[] result = md.digest();
                ret.add(result);
                continue;
            }
            ret.add(left);
        }
        return ret;
    }

    public static List<byte[]> createTreeNodes(int nodeSize, long fileSize, InputStream is, MessageDigest messageDigest) throws IOException {
        ArrayList<byte[]> ret = new ArrayList<byte[]>((int)Math.ceil((double)fileSize / (double)nodeSize));
        MerkleTree tt = new MerkleTree(messageDigest);
        byte[] block = BUFFER.get();
        long offset = 0L;
        int read = 0;
        while (offset < fileSize) {
            int nodeOffset = 0;
            tt.reset();
            while (nodeOffset < nodeSize && (read = is.read(block)) != -1) {
                long time = System.currentTimeMillis();
                tt.update(block, 0, read);
                nodeOffset += read;
                offset += (long)read;
                if (SystemUtils.getIdleTime() >= (long)SharingSettings.MIN_IDLE_TIME_FOR_FULL_HASHING.getValue() || !SharingSettings.FRIENDLY_HASHING.getValue()) continue;
                long sleep = (System.currentTimeMillis() - time) * 2L;
                if (sleep > 0L) {
                    try {
                        Thread.sleep(sleep);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("interrupted during hashing operation");
                    }
                }
                Thread.yield();
            }
            ret.add(tt.digest());
            if (offset == fileSize) {
                if (read == -1 || is.read() == -1) continue;
                LOG.warn("More data than fileSize!");
                throw new IOException("unknown file size.");
            }
            if (read != -1 || offset == fileSize) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn("couldn't hash whole file. read: " + read + ", offset: " + offset + ", fileSize: " + fileSize);
            }
            throw new IOException("couldn't hash whole file.");
        }
        return ret;
    }

    public static int calculateDepth(long size) {
        if (size < 262144L) {
            return 0;
        }
        if (size < 524288L) {
            return 1;
        }
        if (size < 0x100000L) {
            return 2;
        }
        if (size < 0x200000L) {
            return 3;
        }
        if (size < 0x400000L) {
            return 4;
        }
        if (size < 0x800000L) {
            return 5;
        }
        if (size < 0x1000000L) {
            return 6;
        }
        if (size < 0x2000000L) {
            return 7;
        }
        if (size < 0x4000000L) {
            return 8;
        }
        if (size < 0x10000000L) {
            return 9;
        }
        if (size < 0x40000000L) {
            return 10;
        }
        if (size < 0x100000000L) {
            return 11;
        }
        if (size < 0x1000000000L) {
            return 12;
        }
        return 13;
    }

    public static int calculateNodeSize(long fileSize, int depth) {
        long maxNodes = 1 << depth;
        long idealNodeSize = fileSize / maxNodes;
        if (fileSize % maxNodes != 0L) {
            ++idealNodeSize;
        }
        int n = MerkleTree.log2Ceil(idealNodeSize);
        int nodeSize = 1 << n;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fileSize " + fileSize);
            LOG.debug("depth " + depth);
            LOG.debug("nodeSize " + nodeSize);
        }
        assert ((long)nodeSize * maxNodes >= fileSize) : "nodeSize: " + nodeSize + ", fileSize: " + fileSize + ", maxNode: " + maxNodes;
        assert ((long)nodeSize * maxNodes <= fileSize * 2L) : "nodeSize: " + nodeSize + ", fileSize: " + fileSize + ", maxNode: " + maxNodes;
        return nodeSize;
    }
}

