/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.search.QueryHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class ProbeQuery {
    private final List<RoutedConnection> TTL_1_PROBES;
    private final List<RoutedConnection> TTL_2_PROBES;
    private final QueryHandler QUERY_HANDLER;

    ProbeQuery(List<? extends RoutedConnection> connections, QueryHandler qh) {
        this.QUERY_HANDLER = qh;
        List<List<RoutedConnection>> lists = ProbeQuery.createProbeLists(connections, qh.getTemplateQueryRequest());
        this.TTL_1_PROBES = lists.get(0);
        this.TTL_2_PROBES = lists.get(1);
    }

    long getTimeToWait() {
        if (!this.TTL_2_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * 1.3);
        }
        if (!this.TTL_1_PROBES.isEmpty()) {
            return (long)((double)this.QUERY_HANDLER.getTimeToWaitPerHop() * ((double)this.TTL_1_PROBES.size() / 2.0));
        }
        return 0L;
    }

    int sendProbe() {
        int hosts = 0;
        QueryRequest query = this.QUERY_HANDLER.createQuery((byte)1);
        for (RoutedConnection mc : this.TTL_1_PROBES) {
            hosts += this.QUERY_HANDLER.sendQueryToHost(query, mc);
        }
        query = this.QUERY_HANDLER.createQuery((byte)2);
        for (RoutedConnection mc : this.TTL_2_PROBES) {
            hosts += this.QUERY_HANDLER.sendQueryToHost(query, mc);
        }
        this.TTL_1_PROBES.clear();
        this.TTL_2_PROBES.clear();
        return hosts;
    }

    private static List<List<RoutedConnection>> createProbeLists(List<? extends RoutedConnection> connections, QueryRequest query) {
        boolean adequateData;
        LinkedList<RoutedConnection> missConnections = new LinkedList<RoutedConnection>();
        LinkedList<RoutedConnection> oldConnections = new LinkedList<RoutedConnection>();
        LinkedList<RoutedConnection> hitConnections = new LinkedList<RoutedConnection>();
        for (RoutedConnection routedConnection : connections) {
            if (routedConnection.getConnectionCapabilities().isUltrapeerQueryRoutingConnection()) {
                if (routedConnection.shouldForwardQuery(query)) {
                    hitConnections.add(routedConnection);
                    continue;
                }
                missConnections.add(routedConnection);
                continue;
            }
            oldConnections.add(routedConnection);
        }
        ArrayList<List<RoutedConnection>> returnLists = new ArrayList<List<RoutedConnection>>(2);
        LinkedList linkedList = new LinkedList();
        LinkedList ttl2List = new LinkedList();
        returnLists.add(linkedList);
        returnLists.add(ttl2List);
        boolean bl = adequateData = missConnections.size() + hitConnections.size() > 8;
        if (hitConnections.size() == 0 || !adequateData) {
            return ProbeQuery.createAggressiveProbe(oldConnections, missConnections, hitConnections, returnLists);
        }
        int numHitConnections = hitConnections.size();
        double popularity = (double)numHitConnections / ((double)missConnections.size() + (double)numHitConnections);
        if (popularity == 1.0) {
            linkedList.add(hitConnections.removeFirst());
            return returnLists;
        }
        if (numHitConnections > 3) {
            int numToTry = Math.min(9, numHitConnections);
            int startIndex = numHitConnections - numToTry;
            int endIndex = numHitConnections;
            linkedList.addAll(hitConnections.subList(startIndex, endIndex));
            return returnLists;
        }
        linkedList.addAll(hitConnections);
        ProbeQuery.addToList(ttl2List, oldConnections, missConnections, 3);
        return returnLists;
    }

    private static <T> void addToList(List<T> listToAddTo, List<? extends T> list1, List<? extends T> list2, int numElements) {
        if (list1.size() >= numElements) {
            listToAddTo.addAll(list1.subList(0, numElements));
            return;
        }
        listToAddTo.addAll(list1);
        if (list2.size() >= (numElements -= list1.size())) {
            listToAddTo.addAll(list2.subList(0, numElements));
        } else {
            listToAddTo.addAll(list2);
        }
    }

    private static <T> List<List<T>> createAggressiveProbe(List<? extends T> oldConnections, List<? extends T> missConnections, List<? extends T> hitConnections, List<List<T>> returnLists) {
        ProbeQuery.addToList(returnLists.get(1), oldConnections, missConnections, 3);
        int maxIndex = Math.min(4, hitConnections.size());
        returnLists.get(0).addAll(hitConnections.subList(0, maxIndex));
        return returnLists;
    }
}

