/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.routing.BitSetQRTTableStorage;
import com.limegroup.gnutella.routing.QRTTableStorage;
import com.limegroup.gnutella.routing.SparseSetStorage;
import java.util.Iterator;

class DynamicQRTStorage
implements QRTTableStorage {
    private final float TRESHOLD = 2.5f;
    private QRTTableStorage storage;

    DynamicQRTStorage(int length) {
        this(new SparseSetStorage(length));
    }

    private DynamicQRTStorage(QRTTableStorage storage) {
        this.storage = storage;
    }

    @Override
    public void clear(int hash) {
        this.storage.clear(hash);
    }

    @Override
    public void compact() {
        this.changeStorage();
        this.storage.compact();
    }

    private void changeStorage() {
        if (this.storage.getPercentFull() > 2.5) {
            if (this.storage instanceof SparseSetStorage) {
                BitSetQRTTableStorage bitSet = new BitSetQRTTableStorage(this.storage.maxSize());
                bitSet.or(this.storage);
                this.storage = bitSet;
            }
        } else if (this.storage instanceof BitSetQRTTableStorage) {
            SparseSetStorage sparse = new SparseSetStorage(this.storage.maxSize());
            sparse.or(this.storage);
            this.storage = sparse;
        }
    }

    @Override
    public double getPercentFull() {
        return this.storage.getPercentFull();
    }

    @Override
    public int getUnitsInUse() {
        return this.storage.getUnitsInUse();
    }

    @Override
    public int getUnusedUnits() {
        return this.storage.getUnusedUnits();
    }

    @Override
    public int numUnitsWithLoad(int load) {
        return this.storage.numUnitsWithLoad(load);
    }

    @Override
    public void or(QRTTableStorage other) {
        if (other instanceof DynamicQRTStorage) {
            other = ((DynamicQRTStorage)other).storage;
        }
        this.storage.or(other);
    }

    @Override
    public QRTTableStorage resize(int newSize) {
        return this.storage.resize(newSize);
    }

    @Override
    public void set(int hash) {
        this.storage.set(hash);
    }

    @Override
    public void xor(QRTTableStorage other) {
        if (other instanceof DynamicQRTStorage) {
            other = ((DynamicQRTStorage)other).storage;
        }
        this.storage.xor(other);
    }

    @Override
    public int cardinality() {
        return this.storage.cardinality();
    }

    @Override
    public boolean get(int i) {
        return this.storage.get(i);
    }

    @Override
    public int maxSize() {
        return this.storage.maxSize();
    }

    @Override
    public int nextClearBit(int i) {
        return this.storage.nextClearBit(i);
    }

    @Override
    public int nextSetBit(int i) {
        return this.storage.nextSetBit(i);
    }

    @Override
    public DynamicQRTStorage clone() throws CloneNotSupportedException {
        return new DynamicQRTStorage(this.storage.clone());
    }

    public boolean equals(Object o) {
        if (o instanceof DynamicQRTStorage) {
            o = ((DynamicQRTStorage)o).storage;
        }
        return this.storage.equals(o);
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.storage.iterator();
    }

    public String toString() {
        return "DynamicQRTStorage: " + this.storage.toString();
    }
}

