/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.malware;

import com.limegroup.gnutella.malware.DangerousFileChecker;
import com.limegroup.gnutella.malware.DangerousFileType;
import com.limegroup.gnutella.malware.FileExtensionEncoder;
import eu.medsea.mimeutil.MimeException;
import eu.medsea.mimeutil.MimeUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import org.limewire.core.settings.FilterSettings;
import org.limewire.inject.LazySingleton;
import org.limewire.util.FileUtils;

@LazySingleton
class FileExtensionChecker
implements DangerousFileChecker {
    private final DangerousFileType[] fileTypes;

    FileExtensionChecker() {
        DangerousFileType[] ft;
        try {
            String setting = FilterSettings.DANGEROUS_FILE_TYPES.get();
            ft = FileExtensionEncoder.decodeSetting(setting);
        }
        catch (IllegalArgumentException e) {
            ft = new DangerousFileType[]{};
        }
        this.fileTypes = ft;
    }

    protected int getNumKnownTypes() {
        return this.fileTypes.length;
    }

    @Override
    public boolean isDangerous(File file) {
        if (!file.exists()) {
            return false;
        }
        HashSet<String> types = new HashSet<String>();
        try {
            for (Object o : MimeUtil.getMimeTypes(file)) {
                types.add(o.toString());
            }
        }
        catch (MimeException e) {
            return false;
        }
        String ext = FileUtils.getFileExtension(file).toLowerCase(Locale.US);
        for (DangerousFileType type : this.fileTypes) {
            if (!types.contains(type.mimeType)) continue;
            boolean extensionMatchesType = false;
            for (String allowed : type.extensions) {
                if (!ext.equals(allowed)) continue;
                extensionMatchesType = true;
                break;
            }
            return !extensionMatchesType;
        }
        return false;
    }
}

