/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeSupport;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.http.WriteHeadersIOState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Properties;
import org.limewire.util.StringUtils;

public abstract class WriteHandshakeState
extends WriteHeadersIOState {
    protected final HandshakeSupport support;

    protected WriteHandshakeState(HandshakeSupport support) {
        super(null);
        this.support = support;
    }

    static class WriteRequestState
    extends WriteHandshakeState {
        private Properties request;

        WriteRequestState(HandshakeSupport support, Properties request) {
            super(support);
            this.request = request;
        }

        @Override
        protected ByteBuffer createOutgoingData() {
            StringBuilder sb = new StringBuilder();
            this.support.appendConnectLine(sb);
            this.support.appendHeaders(this.request, sb);
            return ByteBuffer.wrap(StringUtils.toAsciiBytes(sb.toString()));
        }

        @Override
        protected void processWrittenHeaders() {
        }
    }

    static class WriteResponseState
    extends WriteHandshakeState {
        private HandshakeResponder responder;
        private HandshakeResponse response;
        private boolean outgoing;

        WriteResponseState(HandshakeSupport support, HandshakeResponder responder, boolean outgoing) {
            super(support);
            this.responder = responder;
            this.outgoing = outgoing;
        }

        @Override
        protected ByteBuffer createOutgoingData() throws IOException {
            HandshakeResponse theirResponse = this.outgoing ? this.support.getReadHandshakeRemoteResponse() : this.support.getReadHandshakeResponse();
            this.response = this.responder.respond(theirResponse, this.outgoing);
            StringBuilder sb = new StringBuilder();
            this.support.appendResponse(this.response, sb);
            return ByteBuffer.wrap(StringUtils.toAsciiBytes(sb.toString()));
        }

        @Override
        protected void processWrittenHeaders() throws IOException {
            block10: {
                block9: {
                    if (!this.outgoing) break block9;
                    switch (this.response.getStatusCode()) {
                        case 200: {
                            break block10;
                        }
                        case 503: {
                            throw NoGnutellaOkException.CLIENT_REJECT;
                        }
                        case 577: {
                            throw NoGnutellaOkException.CLIENT_REJECT_LOCALE;
                        }
                        default: {
                            throw NoGnutellaOkException.createClientUnknown(this.response.getStatusCode());
                        }
                    }
                }
                switch (this.response.getStatusCode()) {
                    case 200: 
                    case 593: {
                        break;
                    }
                    case 503: {
                        throw NoGnutellaOkException.CLIENT_REJECT;
                    }
                    default: {
                        throw NoGnutellaOkException.createClientUnknown(this.response.getStatusCode());
                    }
                }
            }
        }
    }
}

