/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader.serial;

import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.Address;
import org.limewire.io.ConnectableImpl;
import org.limewire.net.address.AddressFactory;
import org.limewire.net.address.AddressSerializer;
import org.limewire.util.StringUtils;
import org.limewire.util.UnboxUtils;

public class RemoteHostMemento
implements Serializable {
    private static final Log LOG = LogFactory.getLog(RemoteHostMemento.class);
    private static final long serialVersionUID = 1452696797555431199L;
    private final Map<Keys, Serializable> propertiesMap = new HashMap<Keys, Serializable>(Keys.values().length);

    public RemoteHostMemento(Address address, String filename, long index, byte[] clientGuid, int speed, long size, int quality, boolean replyToMulticast, String xml, Set<URN> urns, boolean browseHost, String vendor, boolean http1, String type, AddressFactory addressFactory) {
        this.propertiesMap.put(Keys.FILENAME, (Serializable)((Object)filename));
        this.propertiesMap.put(Keys.INDEX, Long.valueOf(index));
        this.propertiesMap.put(Keys.CLIENTGUID, (Serializable)clientGuid);
        this.propertiesMap.put(Keys.SPEED, Integer.valueOf(speed));
        this.propertiesMap.put(Keys.SIZE, Long.valueOf(size));
        this.propertiesMap.put(Keys.QUALITY, Integer.valueOf(quality));
        this.propertiesMap.put(Keys.REPLY_TO_MULTICAST, Boolean.valueOf(replyToMulticast));
        this.propertiesMap.put(Keys.XML, (Serializable)((Object)xml));
        this.propertiesMap.put(Keys.URNS, (Serializable)((Object)urns));
        this.propertiesMap.put(Keys.BH, Boolean.valueOf(browseHost));
        this.propertiesMap.put(Keys.VENDOR, (Serializable)((Object)vendor));
        this.propertiesMap.put(Keys.HTTP11, Boolean.valueOf(http1));
        this.propertiesMap.put(Keys.ADDRESS, (Serializable)((Object)RemoteHostMemento.serializeAddress(address, addressFactory)));
        this.propertiesMap.put(Keys.TYPE, (Serializable)((Object)type));
    }

    public static String serializeAddress(Address address, AddressFactory addressFactory) {
        AddressSerializer serializer = addressFactory.getSerializer(address);
        assert (serializer != null) : "for address class: " + address.getClass();
        StringBuilder builder = new StringBuilder(serializer.getAddressType());
        builder.append(":");
        try {
            builder.append(StringUtils.getUTF8String(Base64.encodeBase64(serializer.serialize(address))));
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Address deserializeAddress(final String addressString, AddressFactory addressFactory) {
        StringTokenizer st = new StringTokenizer(addressString, ":");
        if (st.hasMoreTokens()) {
            String type = st.nextToken();
            if (st.hasMoreTokens()) {
                String addressPart = st.nextToken();
                AddressSerializer serializer = addressFactory.getSerializer(type);
                if (serializer != null) {
                    try {
                        return serializer.deserialize(Base64.decodeBase64(StringUtils.toUTF8Bytes(addressPart)));
                    }
                    catch (IOException e) {
                        LOG.debug("", e);
                    }
                }
                LOG.debug("not enough arguments");
            }
        }
        return new Address(){

            @Override
            public String getAddressDescription() {
                return addressString;
            }
        };
    }

    public String getHost() {
        return (String)((Object)this.propertiesMap.get((Object)Keys.HOST));
    }

    public int getPort() {
        return UnboxUtils.toInt((Integer)this.propertiesMap.get((Object)Keys.PORT));
    }

    public String getFileName() {
        return (String)((Object)this.propertiesMap.get((Object)Keys.FILENAME));
    }

    public long getIndex() {
        return UnboxUtils.toLong((Long)this.propertiesMap.get((Object)Keys.INDEX));
    }

    public byte[] getClientGuid() {
        return (byte[])this.propertiesMap.get((Object)Keys.CLIENTGUID);
    }

    public int getSpeed() {
        return UnboxUtils.toInt((Integer)this.propertiesMap.get((Object)Keys.SPEED));
    }

    public long getSize() {
        return UnboxUtils.toLong((Long)this.propertiesMap.get((Object)Keys.SIZE));
    }

    public int getQuality() {
        return UnboxUtils.toInt((Integer)this.propertiesMap.get((Object)Keys.QUALITY));
    }

    public boolean isReplyToMulticast() {
        return UnboxUtils.toBoolean((Boolean)this.propertiesMap.get((Object)Keys.REPLY_TO_MULTICAST));
    }

    public String getXml() {
        return (String)((Object)this.propertiesMap.get((Object)Keys.XML));
    }

    public Set<URN> getUrns() {
        return (Set)((Object)this.propertiesMap.get((Object)Keys.URNS));
    }

    public boolean isBrowseHost() {
        return UnboxUtils.toBoolean((Boolean)this.propertiesMap.get((Object)Keys.BH));
    }

    public String getVendor() {
        return (String)((Object)this.propertiesMap.get((Object)Keys.VENDOR));
    }

    public boolean isHttp11() {
        return UnboxUtils.toBoolean((Boolean)this.propertiesMap.get((Object)Keys.HTTP11));
    }

    public boolean isTls() {
        return UnboxUtils.toBoolean((Boolean)this.propertiesMap.get((Object)Keys.TLS));
    }

    public String getPushAddr() {
        return (String)((Object)this.propertiesMap.get((Object)Keys.PUSH_ADDR));
    }

    public URL getCustomUrl() {
        return (URL)this.propertiesMap.get((Object)Keys.CUSTOM_URL);
    }

    public String getType() {
        String type = (String)((Object)this.propertiesMap.get((Object)Keys.TYPE));
        if (type != null) {
            return type;
        }
        return "RFD";
    }

    public Address getAddress(AddressFactory addressFactory, PushEndpointFactory pushEndpointFactory) throws IOException {
        return this.getAddress((String)((Object)this.propertiesMap.get((Object)Keys.ADDRESS)), addressFactory, pushEndpointFactory);
    }

    public Address getAddress(String address, AddressFactory addressFactory, PushEndpointFactory pushEndpointFactory) throws IOException {
        if (address != null) {
            return RemoteHostMemento.deserializeAddress(address, addressFactory);
        }
        String pushAddress = this.getPushAddr();
        if (pushAddress != null) {
            return pushEndpointFactory.createPushEndpoint(pushAddress);
        }
        return new ConnectableImpl(this.getHost(), this.getPort(), this.isTls());
    }

    public void setCustomUrl(URL url) {
        this.propertiesMap.put(Keys.CUSTOM_URL, url);
    }

    private static enum Keys {
        HOST,
        PORT,
        FILENAME,
        INDEX,
        CLIENTGUID,
        SPEED,
        SIZE,
        CHAT,
        QUALITY,
        REPLY_TO_MULTICAST,
        XML,
        URNS,
        BH,
        FIREWALLED,
        VENDOR,
        HTTP11,
        TLS,
        PUSH_ADDR,
        CUSTOM_URL,
        ADDRESS,
        TYPE;

    }
}

