/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.downloader.serial.RemoteHostMemento;
import com.limegroup.gnutella.util.QueryUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.auth.Credentials;
import org.limewire.core.settings.SearchSettings;
import org.limewire.io.Address;
import org.limewire.io.GUID;
import org.limewire.net.address.AddressFactory;
import org.limewire.security.SecureMessage;
import org.limewire.util.Objects;

public class RemoteFileDescImpl
implements RemoteFileDesc {
    private static final Log LOG = LogFactory.getLog(RemoteFileDesc.class);
    private final String _filename;
    private final long _index;
    private final byte[] _clientGUID;
    private final byte[] queryGUID;
    private final int _speed;
    private final int _quality;
    private final boolean _replyToMulticast;
    private final LimeXMLDocument _xmlDoc;
    private final Set<URN> _urns;
    private final boolean _browseHostEnabled;
    private final String _vendor;
    public static final String TYPE = "RFD";
    private boolean _http11;
    private boolean _tlsCapable;
    private int _hashCode = 0;
    private final long _creationTime;
    private volatile float _spamRating = 0.0f;
    private SecureMessage.Status _secureStatus = SecureMessage.Status.INSECURE;
    private final long _size;
    private final Address address;
    private final AddressFactory addressFactory;

    public RemoteFileDescImpl(Address address, long index, String filename, long size, byte[] clientGUID, int speed, int quality, boolean browseHost, LimeXMLDocument xmlDoc, Set<? extends URN> urns, boolean replyToMulticast, String vendor, long createTime, boolean http11, AddressFactory addressFactory, byte[] queryGUID) {
        this.addressFactory = addressFactory;
        this.address = Objects.nonNull(address, "address");
        if (((long)speed & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid speed: " + speed);
        }
        if (filename.equals("")) {
            throw new IllegalArgumentException("cannot accept empty string file name");
        }
        if (size < 0L || size > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
        if ((index & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + index);
        }
        this._speed = speed;
        this._index = index;
        this._filename = filename;
        this._size = size;
        this._clientGUID = clientGUID;
        this._quality = quality;
        this._browseHostEnabled = browseHost;
        this._replyToMulticast = replyToMulticast;
        this._vendor = vendor;
        this._creationTime = createTime;
        this._xmlDoc = xmlDoc;
        this._http11 = http11;
        this._urns = UrnSet.resolve(urns);
        this.queryGUID = queryGUID;
    }

    public boolean isTLSCapable() {
        return this._tlsCapable;
    }

    @Override
    public boolean isHTTP11() {
        return this._http11;
    }

    @Override
    public void setHTTP11(boolean http11) {
        this._http11 = http11;
    }

    @Override
    public boolean isMe(byte[] myClientGUID) {
        return Arrays.equals(this._clientGUID, myClientGUID);
    }

    @Override
    public boolean isFromAlternateLocation() {
        return "ALT".equals(this._vendor);
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public final long getIndex() {
        return this._index;
    }

    @Override
    public final long getSize() {
        return this._size;
    }

    @Override
    public final String getFileName() {
        return this._filename;
    }

    @Override
    public final byte[] getClientGUID() {
        return this._clientGUID;
    }

    @Override
    public final byte[] getQueryGUID() {
        return this.queryGUID;
    }

    @Override
    public final int getSpeed() {
        return this._speed;
    }

    @Override
    public final String getVendor() {
        return this._vendor;
    }

    @Override
    public final boolean isBrowseHostEnabled() {
        return this._browseHostEnabled;
    }

    @Override
    public final int getQuality() {
        return this._quality;
    }

    @Override
    public final LimeXMLDocument getXMLDocument() {
        return this._xmlDoc;
    }

    @Override
    public final Set<URN> getUrns() {
        return this._urns;
    }

    @Override
    public final URN getSHA1Urn() {
        return UrnSet.getSha1(this._urns);
    }

    @Override
    public String getUrlPath() {
        URN urn = this.getSHA1Urn();
        if (urn == null) {
            return "/get/" + this._index + "/" + this._filename;
        }
        return "/uri-res/N2R?" + urn.httpStringValue();
    }

    @Override
    public final boolean isReplyToMulticast() {
        return this._replyToMulticast;
    }

    @Override
    public final boolean isAltLocCapable() {
        if (this.address instanceof PushEndpoint && ((PushEndpoint)this.address).getProxies().isEmpty()) {
            return false;
        }
        return this.getSHA1Urn() != null && !this._replyToMulticast;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteFileDesc)) {
            return false;
        }
        RemoteFileDesc other = (RemoteFileDesc)o;
        if (!((Object)this.address).equals(other.getAddress())) {
            return false;
        }
        if (this._size != other.getSize()) {
            return false;
        }
        if (this._clientGUID == null != (other.getClientGUID() == null)) {
            return false;
        }
        if (this._clientGUID != null && !Arrays.equals(this._clientGUID, other.getClientGUID())) {
            return false;
        }
        if (this._urns.isEmpty() && other.getUrns().isEmpty()) {
            return Objects.equalOrNull(this._filename, other.getFileName());
        }
        return ((Object)this._urns).equals(other.getUrns());
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int result = 17;
            result = 37 * result + ((Object)this.address).hashCode();
            result = (int)((long)(37 * result) + this._size);
            result = 37 * result + ((Object)this._urns).hashCode();
            if (this._clientGUID != null) {
                result = 37 * result + new GUID(this._clientGUID).hashCode();
            }
            this._hashCode = result;
        }
        return this._hashCode;
    }

    public String toString() {
        return this.address.toString();
    }

    @Override
    public void setSpamRating(float rating) {
        this._spamRating = rating;
    }

    @Override
    public float getSpamRating() {
        return this._spamRating;
    }

    @Override
    public SecureMessage.Status getSecureStatus() {
        return this._secureStatus;
    }

    @Override
    public void setSecureStatus(SecureMessage.Status secureStatus) {
        this._secureStatus = secureStatus;
    }

    @Override
    public RemoteHostMemento toMemento() {
        return new RemoteHostMemento(this.address, this._filename, this._index, this._clientGUID, this._speed, this._size, this._quality, this._replyToMulticast, this.xmlString(), this._urns, this._browseHostEnabled, this._vendor, this._http11, TYPE, this.addressFactory);
    }

    private String xmlString() {
        if (this._xmlDoc == null) {
            return null;
        }
        return this._xmlDoc.getXMLString();
    }

    @Override
    public boolean isSpam() {
        return this.getSpamRating() >= SearchSettings.FILTER_SPAM_RESULTS.getValue();
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Credentials getCredentials() {
        return null;
    }

    @Override
    public float getRelevance(String query) {
        return QueryUtils.calculateRelevance(this._filename, this._xmlDoc, query);
    }
}

