/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.google.inject.Singleton;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.downloader.RemoteFileDescContext;
import java.util.Comparator;

@Singleton
class PingedRemoteFileDescComparator
implements Comparator<RemoteFileDescContext> {
    PingedRemoteFileDescComparator() {
    }

    private static boolean isFirewalled(RemoteFileDescContext rfdContext) {
        return rfdContext.getAddress() instanceof PushEndpoint;
    }

    @Override
    public int compare(RemoteFileDescContext pongA, RemoteFileDescContext pongB) {
        if (pongA.isReplyToMulticast() != pongB.isReplyToMulticast()) {
            if (pongA.isReplyToMulticast()) {
                return -1;
            }
            return 1;
        }
        if (pongA.getQueueStatus() > pongB.getQueueStatus()) {
            return 1;
        }
        if (pongA.getQueueStatus() < pongB.getQueueStatus()) {
            return -1;
        }
        if (PingedRemoteFileDescComparator.isFirewalled(pongA) != PingedRemoteFileDescComparator.isFirewalled(pongB)) {
            if (PingedRemoteFileDescComparator.isFirewalled(pongA)) {
                return -1;
            }
            return 1;
        }
        if (pongA.isPartialSource() != pongB.isPartialSource()) {
            if (pongA.isPartialSource()) {
                return -1;
            }
            return 1;
        }
        if (pongA.getRoundTripTime() > pongB.getRoundTripTime()) {
            return 1;
        }
        if (pongA.getRoundTripTime() < pongB.getRoundTripTime()) {
            return -1;
        }
        return pongA.hashCode() - pongB.hashCode();
    }
}

