/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.util.AntBuilderLocator;
import groovy.util.BuilderSupport;
import groovy.xml.QName;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.NoBannerLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.codehaus.groovy.ant.FileScanner;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class AntBuilder
extends BuilderSupport {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Project project;
    private final AntXMLContext antXmlContext;
    private final ProjectHelper2.ElementHandler antElementHandler = new ProjectHelper2.ElementHandler();
    private final ProjectHelper2.TargetHandler antTargetHandler = new ProjectHelper2.TargetHandler();
    private final Target collectorTarget;
    private final Target implicitTarget;
    private Object lastCompletedNode;
    boolean insideTask;

    public AntBuilder() {
        this(AntBuilder.createProject());
    }

    public AntBuilder(Project project) {
        this(project, new Target());
    }

    public AntBuilder(Project project, Target owningTarget) {
        this.project = project;
        this.project.setInputHandler((InputHandler)new DefaultInputHandler());
        this.collectorTarget = owningTarget;
        this.antXmlContext = new AntXMLContext(project);
        this.collectorTarget.setProject(project);
        this.antXmlContext.setCurrentTarget(this.collectorTarget);
        this.antXmlContext.setLocator((Locator)new AntBuilderLocator());
        this.antXmlContext.setCurrentTargets(new HashMap());
        this.implicitTarget = new Target();
        this.implicitTarget.setProject(project);
        this.implicitTarget.setName("");
        this.antXmlContext.setImplicitTarget(this.implicitTarget);
        project.addDataTypeDefinition("fileScanner", FileScanner.class);
    }

    public AntBuilder(Task parentTask) {
        this(parentTask.getProject(), parentTask.getOwningTarget());
        UnknownElement ue = new UnknownElement(parentTask.getTaskName());
        ue.setProject(parentTask.getProject());
        ue.setTaskType(parentTask.getTaskType());
        ue.setTaskName(parentTask.getTaskName());
        ue.setLocation(parentTask.getLocation());
        ue.setOwningTarget(parentTask.getOwningTarget());
        ue.setRuntimeConfigurableWrapper(parentTask.getRuntimeConfigurableWrapper());
        parentTask.getRuntimeConfigurableWrapper().setProxy((Object)ue);
        this.antXmlContext.pushWrapper(parentTask.getRuntimeConfigurableWrapper());
    }

    public Project getProject() {
        return this.project;
    }

    public AntXMLContext getAntXmlContext() {
        return this.antXmlContext;
    }

    protected static Project createProject() {
        Project project = new Project();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", (Object)helper);
        helper.getImportStack().addElement("AntBuilder");
        NoBannerLogger logger = new NoBannerLogger();
        logger.setMessageOutputLevel(2);
        logger.setOutputPrintStream(System.out);
        logger.setErrorPrintStream(System.err);
        project.addBuildListener((BuildListener)logger);
        project.init();
        project.getBaseDir();
        return project;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        super.doInvokeMethod(methodName, name, args);
        return this.lastCompletedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nodeCompleted(Object parent, Object node) {
        if (parent == null) {
            this.insideTask = false;
        }
        this.antElementHandler.onEndElement(null, null, this.antXmlContext);
        this.lastCompletedNode = node;
        if (parent != null && !(parent instanceof Target)) {
            this.log.finest("parent is not null: no perform on nodeCompleted");
            return;
        }
        if (node instanceof Task) {
            Object task = node;
            if (node instanceof UnknownElement) {
                UnknownElement unknownElement = (UnknownElement)node;
                unknownElement.maybeConfigure();
                task = unknownElement.getRealThing();
            }
            this.lastCompletedNode = task;
            if (task instanceof Task) {
                String taskName = ((Task)task).getTaskName();
                if ("antcall".equals(taskName) && parent == null) {
                    throw new BuildException("antcall not supported within AntBuilder, consider using 'ant.project.executeTarget('targetName')' instead.");
                }
                InputStream savedIn = System.in;
                InputStream savedProjectInputStream = this.project.getDefaultInputStream();
                if (!(savedIn instanceof DemuxInputStream)) {
                    this.project.setDefaultInputStream(savedIn);
                    System.setIn((InputStream)new DemuxInputStream(this.project));
                }
                try {
                    ((Task)task).perform();
                }
                finally {
                    this.project.setDefaultInputStream(savedProjectInputStream);
                    System.setIn(savedIn);
                }
                if ("import".equals(taskName)) {
                    this.antXmlContext.setCurrentTarget(this.collectorTarget);
                }
            }
        } else if (node instanceof Target) {
            this.antXmlContext.setCurrentTarget(this.collectorTarget);
        } else {
            RuntimeConfigurable r = (RuntimeConfigurable)node;
            r.maybeConfigure(this.project);
        }
    }

    protected Object createNode(Object tagName) {
        return this.createNode(tagName, Collections.EMPTY_MAP);
    }

    protected Object createNode(Object name, Object value) {
        Object task = this.createNode(name);
        this.setText(task, value.toString());
        return task;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Object task = this.createNode(name, attributes);
        this.setText(task, value.toString());
        return task;
    }

    protected static Attributes buildAttributes(Map attributes) {
        AttributesImpl attr = new AttributesImpl();
        for (Map.Entry entry : attributes.entrySet()) {
            String attributeName = (String)entry.getKey();
            String attributeValue = String.valueOf(entry.getValue());
            attr.addAttribute(null, attributeName, attributeName, "CDATA", attributeValue);
        }
        return attr;
    }

    protected Object createNode(Object name, Map attributes) {
        Attributes attrs = AntBuilder.buildAttributes(attributes);
        String tagName = name.toString();
        String ns = "";
        if (name instanceof QName) {
            QName q = (QName)name;
            tagName = q.getLocalPart();
            ns = q.getNamespaceURI();
        }
        if ("import".equals(name)) {
            this.antXmlContext.setCurrentTarget(this.implicitTarget);
        } else if ("target".equals(name) && !this.insideTask) {
            return this.onStartTarget(attrs, tagName, ns);
        }
        try {
            this.antElementHandler.onStartElement(ns, tagName, tagName, attrs, this.antXmlContext);
        }
        catch (SAXParseException e) {
            this.log.log(Level.SEVERE, "Caught: " + e, e);
        }
        this.insideTask = true;
        RuntimeConfigurable wrapper = (RuntimeConfigurable)this.antXmlContext.getWrapperStack().lastElement();
        return wrapper.getProxy();
    }

    private Target onStartTarget(Attributes attrs, String tagName, String ns) {
        Target target = new Target();
        target.setProject(this.project);
        target.setLocation(new Location(this.antXmlContext.getLocator()));
        try {
            this.antTargetHandler.onStartElement(ns, tagName, tagName, attrs, this.antXmlContext);
            Target newTarget = (Target)this.getProject().getTargets().get(attrs.getValue("name"));
            Vector targets = new Vector();
            Enumeration deps = newTarget.getDependencies();
            while (deps.hasMoreElements()) {
                String targetName = (String)deps.nextElement();
                targets.add(this.project.getTargets().get(targetName));
            }
            this.getProject().executeSortedTargets(targets);
            this.antXmlContext.setCurrentTarget(newTarget);
            return newTarget;
        }
        catch (SAXParseException e) {
            this.log.log(Level.SEVERE, "Caught: " + e, e);
            return null;
        }
    }

    protected void setText(Object task, String text) {
        char[] characters = text.toCharArray();
        try {
            this.antElementHandler.characters(characters, 0, characters.length, this.antXmlContext);
        }
        catch (SAXParseException e) {
            this.log.log(Level.WARNING, "SetText failed: " + task + ". Reason: " + e, e);
        }
    }

    public Project getAntProject() {
        return this.project;
    }
}

