/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.template.image;

import com.openstego.desktop.DataHidingPlugin;
import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.ui.OpenStegoUI;
import com.openstego.desktop.ui.PluginEmbedOptionsUI;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;

public abstract class DHImagePluginTemplate
extends DataHidingPlugin {
    protected static List<String> readFormats = null;
    protected static List<String> writeFormats = null;

    @Override
    public final byte[] getDiff(byte[] stegoData, String stegoFileName, byte[] coverData, String coverFileName, String diffFileName) throws OpenStegoException {
        ImageHolder stegoImage = null;
        ImageHolder coverImage = null;
        ImageHolder diffImage = null;
        stegoImage = ImageUtil.byteArrayToImage(stegoData, stegoFileName);
        coverImage = ImageUtil.byteArrayToImage(coverData, coverFileName);
        diffImage = ImageUtil.getDiffImage(stegoImage, coverImage);
        return ImageUtil.imageToByteArray(diffImage, diffFileName, this);
    }

    @Override
    public List<String> getReadableFileExtensions() throws OpenStegoException {
        if (readFormats != null) {
            return readFormats;
        }
        String format = null;
        String[] formats = null;
        readFormats = new ArrayList<String>();
        formats = ImageIO.getReaderFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            format = formats[i].toLowerCase();
            if (format.indexOf("jpeg") >= 0 && format.indexOf("2000") >= 0) {
                format = "jp2";
            }
            if (readFormats.contains(format)) continue;
            readFormats.add(format);
        }
        Collections.sort(readFormats);
        return readFormats;
    }

    @Override
    public List<String> getWritableFileExtensions() throws OpenStegoException {
        if (writeFormats != null) {
            return writeFormats;
        }
        String format = null;
        String[] formats = null;
        writeFormats = new ArrayList<String>();
        formats = ImageIO.getWriterFormatNames();
        for (int i = 0; i < formats.length; ++i) {
            format = formats[i].toLowerCase();
            if (format.indexOf("jpeg") >= 0 && format.indexOf("2000") >= 0) {
                format = "jp2";
            }
            if (writeFormats.contains(format)) continue;
            writeFormats.add(format);
        }
        Collections.sort(writeFormats);
        return writeFormats;
    }

    @Override
    public PluginEmbedOptionsUI getEmbedOptionsUI(OpenStegoUI stegoUI) throws OpenStegoException {
        return null;
    }

    @Override
    public void populateStdCmdLineOptions(CmdLineOptions options) throws OpenStegoException {
    }

    @Override
    public Class<? extends OpenStegoConfig> getConfigClass() {
        return OpenStegoConfig.class;
    }
}

