/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.lsb;

import com.openstego.desktop.OpenStegoConfig;
import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.plugin.lsb.LSBEmbedOptionsUI;
import com.openstego.desktop.plugin.lsb.LSBErrors;
import com.openstego.desktop.plugin.lsb.LSBInputStream;
import com.openstego.desktop.plugin.lsb.LSBOutputStream;
import com.openstego.desktop.plugin.template.image.DHImagePluginTemplate;
import com.openstego.desktop.ui.OpenStegoUI;
import com.openstego.desktop.ui.PluginEmbedOptionsUI;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.LabelUtil;
import com.openstego.desktop.util.cmd.CmdLineOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;

public class LSBPlugin
extends DHImagePluginTemplate {
    private static LabelUtil labelUtil = LabelUtil.getInstance("LSB");
    public static final String NAMESPACE = "LSB";

    public LSBPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "i18n.LSBPluginLabels");
        new LSBErrors();
    }

    @Override
    public String getName() {
        return NAMESPACE;
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        int numOfPixels = 0;
        ImageHolder image = null;
        LSBOutputStream lsbOS = null;
        try {
            if (cover == null) {
                numOfPixels = (int)((double)(LSBDataHeader.getMaxHeaderSize() * 8) / 3.0);
                image = ImageUtil.generateRandomImage(numOfPixels += (int)((double)(msg.length * 8) / (3.0 * (double)((LSBConfig)this.config).getMaxBitsUsedPerChannel())));
            } else {
                image = ImageUtil.byteArrayToImage(cover, coverFileName);
            }
            lsbOS = new LSBOutputStream(image, msg.length, msgFileName, this.config);
            lsbOS.write(msg);
            lsbOS.close();
            return ImageUtil.imageToByteArray(lsbOS.getImage(), stegoFileName, this);
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extractMsgFileName(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        InputStream lsbIS = null;
        try {
            lsbIS = new LSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
            String string = ((LSBInputStream)lsbIS).getDataHeader().getFileName();
            return string;
        }
        finally {
            if (lsbIS != null) {
                try {
                    lsbIS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        int bytesRead = 0;
        byte[] data = null;
        LSBDataHeader header = null;
        InputStream lsbIS = null;
        try {
            lsbIS = new LSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
            header = ((LSBInputStream)lsbIS).getDataHeader();
            data = new byte[header.getDataLength()];
            bytesRead = lsbIS.read(data, 0, data.length);
            if (bytesRead != data.length) {
                throw new OpenStegoException(null, NAMESPACE, 1);
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        finally {
            if (lsbIS != null) {
                try {
                    lsbIS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public List<String> getWritableFileExtensions() throws OpenStegoException {
        if (writeFormats != null) {
            return writeFormats;
        }
        super.getWritableFileExtensions();
        String format = null;
        String[] compTypes = null;
        Iterator<ImageWriter> iter = null;
        ImageWriteParam writeParam = null;
        block2: for (int i = writeFormats.size() - 1; i >= 0; --i) {
            format = (String)writeFormats.get(i);
            iter = ImageIO.getImageWritersBySuffix(format);
            while (iter.hasNext()) {
                block5: {
                    writeParam = iter.next().getDefaultWriteParam();
                    try {
                        writeParam.setCompressionMode(2);
                        compTypes = writeParam.getCompressionTypes();
                        if (compTypes.length <= 0) break block5;
                        writeParam.setCompressionType(compTypes[0]);
                    }
                    catch (UnsupportedOperationException uoEx) {
                        continue block2;
                    }
                }
                if (writeParam.isCompressionLossless()) continue block2;
                writeFormats.remove(i);
            }
        }
        writeFormats.remove("gif");
        writeFormats.remove("wbmp");
        writeFormats.remove("tif");
        writeFormats.remove("tiff");
        return writeFormats;
    }

    @Override
    public PluginEmbedOptionsUI getEmbedOptionsUI(OpenStegoUI stegoUI) throws OpenStegoException {
        return new LSBEmbedOptionsUI(stegoUI);
    }

    @Override
    public void populateStdCmdLineOptions(CmdLineOptions options) throws OpenStegoException {
        options.add("-b", "--maxBitsUsedPerChannel", 1, true);
    }

    @Override
    public Class<? extends OpenStegoConfig> getConfigClass() {
        return LSBConfig.class;
    }

    @Override
    public String getUsage() throws OpenStegoException {
        LSBConfig defaultConfig = new LSBConfig();
        return labelUtil.getString("plugin.usage", defaultConfig.getMaxBitsUsedPerChannel());
    }
}

