/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class SecuredStorage
implements IStorage {
    private IStorage storage;
    private String cipherAlgorithm;
    private Key secretKey;

    public SecuredStorage(IStorage storage, String cipherAlgorithm, Key secretKey) {
        Assert.isNotNull((Object)storage);
        this.storage = storage;
        this.cipherAlgorithm = cipherAlgorithm;
        this.secretKey = secretKey;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    private Cipher createCipher(int mode) {
        try {
            Cipher cipher = Cipher.getInstance(this.cipherAlgorithm);
            cipher.init(mode, this.secretKey);
            return cipher;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Should not happen", e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalStateException("Should not happen", e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException("Should not happen", e);
        }
    }

    public IInputSource getInputSource() {
        return new SecuredInputSource(this.storage.getInputSource());
    }

    public IOutputTarget getOutputTarget() {
        return new SecuredOutputTarget(this.storage.getOutputTarget());
    }

    public String getName() {
        return this.storage.getName();
    }

    public String getFullPath() {
        return this.storage.getFullPath();
    }

    public void clear() {
        this.storage.clear();
    }

    public void deleteEntry(String entryName) {
        this.storage.deleteEntry(entryName);
    }

    public void renameEntry(String entryName, String newName) {
        this.storage.renameEntry(entryName, newName);
    }

    public int hashCode() {
        return this.storage.hashCode() ^ this.cipherAlgorithm.hashCode() ^ this.secretKey.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SecuredStorage)) {
            return false;
        }
        SecuredStorage that = (SecuredStorage)obj;
        return this.storage.equals(that.storage) && this.cipherAlgorithm.equals(that.cipherAlgorithm) && this.secretKey.equals(that.secretKey);
    }

    private class SecuredInputSource
    implements IInputSource,
    Closeable {
        private IInputSource source;

        public SecuredInputSource(IInputSource source) {
            this.source = source;
        }

        @Override
        public void close() throws IOException {
            if (this.source instanceof Closeable) {
                ((Closeable)this.source).close();
            }
        }

        public boolean hasEntry(String entryName) {
            return this.source.hasEntry(entryName);
        }

        public Iterator<String> getEntries() {
            return this.source.getEntries();
        }

        public boolean isEntryAvailable(String entryName) {
            return this.source.isEntryAvailable(entryName);
        }

        @Deprecated
        public InputStream getEntryStream(String entryName) {
            return this.source.getEntryStream(entryName);
        }

        public InputStream openEntryStream(String entryName) throws IOException {
            InputStream stream = this.source.openEntryStream(entryName);
            return new CipherInputStream(stream, SecuredStorage.this.createCipher(2));
        }

        public long getEntrySize(String entryName) {
            return this.source.getEntrySize(entryName);
        }

        public long getEntryTime(String entryName) {
            return this.source.getEntryTime(entryName);
        }
    }

    private class SecuredOutputTarget
    implements IOutputTarget,
    Closeable {
        private IOutputTarget target;

        public SecuredOutputTarget(IOutputTarget target) {
            this.target = target;
        }

        @Override
        public void close() throws IOException {
            if (this.target instanceof Closeable) {
                ((Closeable)this.target).close();
            }
        }

        public boolean isEntryAvaialble(String entryName) {
            return this.target.isEntryAvaialble(entryName);
        }

        @Deprecated
        public OutputStream getEntryStream(String entryName) {
            return this.target.getEntryStream(entryName);
        }

        public OutputStream openEntryStream(String entryName) throws IOException {
            OutputStream stream = this.target.openEntryStream(entryName);
            return new CipherOutputStream(stream, SecuredStorage.this.createCipher(1));
        }

        public void setEntryTime(String entryName, long time) {
            this.target.setEntryTime(entryName, time);
        }
    }
}

