/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.command.remote;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.xmind.core.command.remote.ICommandServiceDomain;
import org.xmind.core.command.remote.ICommandServiceDomainManager;
import org.xmind.core.command.remote.IDomainServiceFactory;
import org.xmind.core.internal.command.remote.CommandServiceDomainImpl;
import org.xmind.core.internal.command.remote.IDomainsExtensionConstants;
import org.xmind.core.internal.command.remote.NullDomainService;
import org.xmind.core.internal.command.remote.RemoteCommandPlugin;

public class CommandServiceDomainManagerImpl
implements ICommandServiceDomainManager,
IDomainsExtensionConstants {
    private static final CommandServiceDomainManagerImpl singleton = new CommandServiceDomainManagerImpl();
    private Map<String, CommandServiceDomainImpl> domains = null;
    private Map<String, DomainServiceFactoryDescriptor> factories = null;

    private CommandServiceDomainManagerImpl() {
    }

    public synchronized ICommandServiceDomain[] getCommandServiceDomains() {
        this.ensureLoaded();
        return this.domains.values().toArray(new ICommandServiceDomain[this.domains.size()]);
    }

    public synchronized ICommandServiceDomain getCommandServiceDomain(String domainId) {
        this.ensureLoaded();
        return this.domains.get(domainId);
    }

    public IDomainServiceFactory getServiceFactory(String factoryId) {
        DomainServiceFactoryDescriptor factory = this.factories.get(factoryId);
        return factory == null ? null : factory.getFactory();
    }

    private void ensureLoaded() {
        if (this.domains == null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.xmind.core.command.remote.domains");
            if (extensionPoint != null) {
                this.loadFromExtensions(extensionPoint.getExtensions());
            }
            if (this.domains == null) {
                this.domains = new HashMap<String, CommandServiceDomainImpl>(1);
            }
        }
    }

    private void loadFromExtensions(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            this.loadFromExtensionElements(extensions[i].getConfigurationElements());
            ++i;
        }
    }

    private void loadFromExtensionElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.loadFromExtensionElement(elements[i]);
            ++i;
        }
    }

    private void loadFromExtensionElement(IConfigurationElement element) {
        if ("domain".equals(element.getName())) {
            this.loadRemoteCommandServiceDomain(element);
        } else if ("serviceFactory".equals(element.getName())) {
            this.loadServiceFactory(element);
        }
        this.loadFromExtensionElements(element.getChildren());
    }

    private void loadRemoteCommandServiceDomain(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || "".equals(id)) {
            RemoteCommandPlugin.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid domain extension: (missing id)"));
            return;
        }
        if (element.getAttribute("server") == null) {
            RemoteCommandPlugin.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid domain extension: (missing server) " + id));
            return;
        }
        if (element.getAttribute("advertiser") == null) {
            RemoteCommandPlugin.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid domain extension: (missing advertiser) " + id));
            return;
        }
        if (element.getAttribute("discoverer") == null) {
            RemoteCommandPlugin.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid domain extension: (missing discoverer) " + id));
            return;
        }
        CommandServiceDomainImpl domain = new CommandServiceDomainImpl(this, id, element);
        if (this.domains == null) {
            this.domains = new HashMap<String, CommandServiceDomainImpl>(3);
        }
        this.domains.put(id, domain);
    }

    private void loadServiceFactory(IConfigurationElement element) {
        String id = element.getAttribute("id");
        if (id == null || "".equals(id)) {
            RemoteCommandPlugin.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid serviceFactory extension: (missing id)"));
            return;
        }
        if (element.getAttribute("class") == null) {
            RemoteCommandPlugin.log((IStatus)new Status(4, element.getNamespaceIdentifier(), "Invalid serviceFactory extension: (missing class) " + id));
            return;
        }
        DomainServiceFactoryDescriptor factory = new DomainServiceFactoryDescriptor(element);
        if (this.factories == null) {
            this.factories = new HashMap<String, DomainServiceFactoryDescriptor>(3);
        }
        this.factories.put(id, factory);
    }

    public static CommandServiceDomainManagerImpl getDefault() {
        return singleton;
    }

    private static class DomainServiceFactoryDescriptor {
        private IConfigurationElement element;
        private IDomainServiceFactory factory = null;

        public DomainServiceFactoryDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        public IDomainServiceFactory getFactory() {
            if (this.factory == null) {
                try {
                    this.factory = (IDomainServiceFactory)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    RemoteCommandPlugin.log(null, e);
                    this.factory = NullDomainService.getDefault();
                }
            }
            return this.factory == NullDomainService.getDefault() ? null : this.factory;
        }
    }
}

