/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.ITransparentableFigure;

public class SimpleRectangleFigure
extends Figure
implements ITransparentableFigure {
    public Rectangle client = new Rectangle(0, 0, 0, 0);
    private int borderAlpha = 255;
    private int fillAlpha = 0;
    private int lineWidth = 1;

    public SimpleRectangleFigure() {
    }

    public SimpleRectangleFigure(Rectangle client) {
        this.client.setBounds(client);
        this.pack();
    }

    public void pack() {
        this.setBounds(Rectangle.SINGLETON.setBounds(this.client).expand(this.getLineWidth(), this.getLineWidth()).resize(1, 1));
        this.revalidate();
        this.repaint();
    }

    public void setClient(int x, int y, int width, int height) {
        this.setClient(Rectangle.SINGLETON.setLocation(x, y).setSize(width, height));
    }

    public void setClient(Rectangle client) {
        if (client == null || client.equals((Object)this.client)) {
            return;
        }
        this.client.setBounds(client);
        this.pack();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        if (lineWidth == this.lineWidth) {
            return;
        }
        this.lineWidth = lineWidth;
        this.pack();
        this.repaint();
    }

    public int getMainAlpha() {
        return this.borderAlpha;
    }

    public int getSubAlpha() {
        return this.fillAlpha;
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.borderAlpha) {
            return;
        }
        this.borderAlpha = alpha;
        this.repaint();
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.fillAlpha) {
            return;
        }
        this.fillAlpha = alpha;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        Color borderColor;
        graphics.setAntialias(1);
        graphics.setLineStyle(1);
        int w = this.getLineWidth();
        int w2 = w / 2;
        graphics.setLineWidth(w);
        Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
        Color fillColor = this.getLocalBackgroundColor();
        if (fillColor != null && this.getSubAlpha() > 0) {
            graphics.setAlpha(this.getSubAlpha());
            graphics.setBackgroundColor(fillColor);
            graphics.fillRectangle(r.shrink(w2, w2));
        }
        if ((borderColor = this.getLocalForegroundColor()) != null && this.getMainAlpha() > 0) {
            graphics.setAlpha(this.getMainAlpha());
            graphics.setForegroundColor(borderColor);
            graphics.drawRectangle(r.resize(-1, -1));
        }
    }
}

