/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.resources.ColorUtils;

class ThemeOverrideDialog
extends Dialog {
    private Button rememberCheck;
    private ResourceManager resources;

    protected ThemeOverrideDialog(Shell parentShell) {
        super(parentShell);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ThemesView_Dialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Label label = new Label(composite, 0);
        label.setText(Messages.ThemesView_Dialog_message);
        this.createRememberCheck(composite);
        return composite;
    }

    private void createRememberCheck(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginTop = 25;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(1808));
        this.rememberCheck = new Button(composite, 32);
        this.rememberCheck.setText(Messages.ThemesView_Dialog_Check);
        this.rememberCheck.setLayoutData((Object)new GridData(4, 1024, true, true));
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gridLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        gridLayout.marginBottom = this.convertVerticalDLUsToPixels(7);
        gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        gridLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)gridLayout);
        this.createPrefLink(composite);
        Composite buttonBar = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        buttonBar.setLayout((Layout)layout);
        buttonBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        buttonBar.setFont(parent.getFont());
        this.createButtonsForButtonBar(buttonBar);
        return buttonBar;
    }

    private void createPrefLink(Composite parent) {
        Hyperlink prefLink = new Hyperlink(parent, 4);
        prefLink.setText(Messages.ThemesView_Dialog_PrefLink);
        prefLink.setUnderlined(false);
        prefLink.setForeground(this.resources.createColor(ColorUtils.toDescriptor((String)"#0082F9")));
        prefLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PreferencesUtil.createPreferenceDialogOn(null, (String)"org.xmind.ui.ThemePrefPage", null, null).open();
            }
        });
        prefLink.getParent().setFocus();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.ThemesView_OverrideButton, true);
        this.createButton(parent, 3, Messages.ThemesView_KeepButton, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (3 == buttonId) {
            this.noPressed();
        }
    }

    protected void okPressed() {
        IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();
        if (this.rememberCheck.getSelection()) {
            pref.setValue("Theme_Apply", "THEME_OVERRIDE");
        } else {
            pref.setValue("Theme_Apply", "ASK_USER");
        }
        super.okPressed();
    }

    private void noPressed() {
        IPreferenceStore pref = MindMapUIPlugin.getDefault().getPreferenceStore();
        if (this.rememberCheck.getSelection()) {
            pref.setValue("Theme_Apply", "THEME_KEEP");
        } else {
            pref.setValue("Theme_Apply", "ASK_USER");
        }
        this.setReturnCode(3);
        this.close();
    }
}

