/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.datepicker;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;

public class TextLayer
extends Layer {
    private int alpha = 255;
    private String text;
    private int dx = 0;
    private int dy = 0;
    private Dimension computedSize;
    private String[] candidates;
    private Dimension candidatesSize;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.repaint();
    }

    public void setOffset(int dx, int dy) {
        this.dx = dx;
        this.dy = dy;
        this.repaint();
    }

    public void setCandidates(String[] candidates) {
        this.candidates = candidates;
        this.candidatesSize = null;
        this.revalidate();
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.candidatesSize = null;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.computedSize == null) {
            this.computeSize(wHint, hHint);
        }
        return this.computedSize;
    }

    private void computeSize(int wHint, int hHint) {
        this.computedSize = GraphicsUtils.getAdvanced().getTextSize(this.text == null || "".equals(this.text) ? "A" : this.text, this.getFont()).expand(10, 8);
        this.computeCandidatesSize();
        this.computedSize.union(this.candidatesSize);
    }

    private void computeCandidatesSize() {
        if (this.candidatesSize != null) {
            return;
        }
        this.candidatesSize = new Dimension();
        if (this.candidates == null || this.candidates.length == 0) {
            return;
        }
        String[] stringArray = this.candidates;
        int n = this.candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.candidatesSize.union(GraphicsUtils.getAdvanced().getTextSize(str, this.getFont()));
            ++n2;
        }
    }

    public void invalidate() {
        super.invalidate();
        this.computedSize = null;
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.text == null || "".equals(this.text)) {
            return;
        }
        graphics.setAlpha(this.alpha);
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.setFont(this.getFont());
        Dimension textSize = GraphicsUtils.getAdvanced().getTextSize(this.text, this.getFont());
        Rectangle b = this.getBounds();
        graphics.drawText(this.text, b.x + (b.width - textSize.width) / 2 + this.dx, b.y + (b.height - textSize.height) / 2 + this.dy);
    }
}

