/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.IFileEntry;
import org.xmind.core.IResourceRef;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;

public class PresentationStoryLabelProvider
extends LabelProvider {
    private Map<IResourceRef, Image> imageCache = new HashMap<IResourceRef, Image>();

    public Image getImage(Object element) {
        PresentationSlide s;
        IResourceRef ref;
        if (element instanceof PresentationSlide && (ref = (s = (PresentationSlide)element).getResourceRef()) != null) {
            Image image = this.imageCache.get(ref);
            if (image == null) {
                image = this.createImage(ref);
                this.imageCache.put(ref, image);
            }
            return image;
        }
        return super.getImage(element);
    }

    private Image createImage(IResourceRef ref) {
        Object o = ref.getResource();
        if (o instanceof IFileEntry) {
            Image image;
            IFileEntry entry = (IFileEntry)o;
            InputStream stream = entry.openInputStream();
            try {
                image = new Image((Device)Display.getCurrent(), stream);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
            }
            stream.close();
            return image;
        }
        return null;
    }

    public void invalidateImageCache() {
        Object[] images = this.imageCache.values().toArray();
        this.imageCache.clear();
        Object[] objectArray = images;
        int n = images.length;
        int n2 = 0;
        while (n2 < n) {
            Object image = objectArray[n2];
            if (image != null) {
                ((Image)image).dispose();
            }
            ++n2;
        }
    }

    public String getText(Object element) {
        return "";
    }

    public void dispose() {
        this.invalidateImageCache();
        super.dispose();
    }
}

