/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.AbstractSplashHandler;
import org.osgi.framework.Bundle;
import org.xmind.cathy.internal.CathyPlugin;

public class CathySplashHandler
extends AbstractSplashHandler {
    private GC shellGC = null;
    private Image image = null;
    private Object resourceLock = new Object();

    public void init(Shell splash) {
        super.init(splash);
        ImageLoader loader = new ImageLoader();
        final ImageData[] imageDataArray = this.loadAnimationImageData(loader);
        if (imageDataArray == null) {
            return;
        }
        if (imageDataArray.length <= 1 || loader.repeatCount != 0) {
            CathyPlugin.log("Invalid GIF format of application loading indicator.");
            return;
        }
        this.shellGC = new GC((Drawable)splash);
        splash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CathySplashHandler.this.releaseResources();
            }
        });
        final Display display = splash.getDisplay();
        Thread animateThread = new Thread(new Runnable(){

            @Override
            public void run() {
                CathySplashHandler.this.showLoadingAnimation(display, imageDataArray);
            }
        }, "LoadingIndicatorAnimation");
        animateThread.setDaemon(true);
        animateThread.start();
    }

    /*
     * Loose catch block
     */
    private ImageData[] loadAnimationImageData(ImageLoader loader) {
        URL url = FileLocator.find((Bundle)Platform.getBundle((String)"org.xmind.cathy"), (IPath)new Path("icons/progress.gif"), null);
        if (url == null) {
            return null;
        }
        InputStream imageStream = null;
        imageStream = url.openStream();
        ImageData[] imageDataArray = loader.load(imageStream);
        try {
            imageStream.close();
        }
        catch (IOException iOException) {}
        return imageDataArray;
        catch (IOException e) {
            try {
                CathyPlugin.log(e, "There was an error loading GIF from " + url.toExternalForm());
            }
            catch (Throwable throwable) {
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                imageStream.close();
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResources() {
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.image != null) {
                if (!this.image.isDisposed()) {
                    this.image.dispose();
                }
                this.image = null;
            }
            if (this.shellGC != null) {
                if (!this.shellGC.isDisposed()) {
                    this.shellGC.dispose();
                }
                this.shellGC = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLoadingAnimation(Display display, ImageData[] imageDataArray) {
        int imageDataIndex = -1;
        while (true) {
            imageDataIndex = (imageDataIndex + 1) % imageDataArray.length;
            ImageData imageData = imageDataArray[imageDataIndex];
            Object object = this.resourceLock;
            synchronized (object) {
                if (display.isDisposed() || this.shellGC == null || this.shellGC.isDisposed()) {
                    return;
                }
                if (this.image != null && !this.image.isDisposed()) {
                    this.image.dispose();
                    this.image = null;
                }
                this.image = new Image((Device)display, imageData);
                this.shellGC.drawImage(this.image, 233, 215);
            }
            try {
                int ms = imageData.delayTime * 10;
                if (ms < 20) {
                    ms += 30;
                }
                if (ms < 30) {
                    ms += 10;
                }
                Thread.sleep(ms);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

