/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class BoundedRangeInputStream
extends FilterInputStream
implements BoundedRangeModel {
    private int nread_ = 0;
    private int size_ = 0;
    private boolean valueIsAdjusting_;
    protected transient ChangeEvent changeEvent_ = null;
    protected EventListenerList listenerList_ = new EventListenerList();

    public BoundedRangeInputStream(InputStream in) {
        super(in);
        try {
            this.size_ = in.available();
        }
        catch (IOException ioe) {
            this.size_ = 0;
        }
    }

    @Override
    public int read() throws IOException {
        int c = this.in.read();
        if (c >= 0) {
            this.incrementValue(1);
        }
        return c;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int nr = this.in.read(b);
        this.incrementValue(nr);
        return nr;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nr = this.in.read(b, off, len);
        this.incrementValue(nr);
        return nr;
    }

    @Override
    public long skip(long n) throws IOException {
        long nr = this.in.skip(n);
        this.incrementValue((int)nr);
        return nr;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.nread_ = this.size_ - this.in.available();
        this.fireStateChanged();
    }

    private void incrementValue(int inc) {
        if (inc > 0) {
            this.nread_ += inc;
            if (this.nread_ > this.size_) {
                this.size_ = this.nread_;
            }
            this.fireStateChanged();
        }
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMinimum(int newMinimum) {
    }

    @Override
    public int getMaximum() {
        return this.size_;
    }

    @Override
    public void setMaximum(int newMaximum) {
        this.size_ = newMaximum;
        this.fireStateChanged();
    }

    @Override
    public int getValue() {
        return this.nread_;
    }

    @Override
    public void setValue(int newValue) {
    }

    @Override
    public void setValueIsAdjusting(boolean b) {
        this.valueIsAdjusting_ = b;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting_;
    }

    @Override
    public int getExtent() {
        return 0;
    }

    @Override
    public void setExtent(int newExtent) {
    }

    @Override
    public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList_.add(ChangeListener.class, l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listenerList_.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList_.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent_ == null) {
                this.changeEvent_ = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent_);
        }
    }
}

